static char copyright []
= "$Id: xessCOTestCmd.c,v 1.1 1994/08/26 13:31:17 johnsonm Exp $\n\
   Copyright (c) 1992 General Electric.  All rights reserved.";

/*
 *   Permission to use, copy, modify, and distribute this
 *   software and its documentation for any purpose and without
 *   fee is hereby granted, provided that the above copyright
 *   notice appear in all copies and that both that copyright
 *   notice and this permission notice appear in supporting
 *   documentation, and that the name of General Electric not be used in
 *   advertising or publicity pertaining to distribution of the
 *   software without specific, written prior permission.
 *   General Electric makes no representations about the suitability of
 *   this software for any purpose.  It is provided "as is"
 *   without express or implied warranty.
 *
 *   This work was supported by the DARPA Initiative in Concurrent
 *   Engineering (DICE) through DARPA Contract MDA972-88-C-0047.
 *
 * $Log: xessCOTestCmd.c,v $
 * Revision 1.1  1994/08/26  13:31:17  johnsonm
 * Initial revision
 *
 *
 * Old log:
 * Revision 1.1  1992/10/09  19:02:19  kennykb
 * Initial revision
 *
 *
 * xessCOTestCmd.c --
 * 
 *	Handle the `test' command on an Xess connection object
 */

#include <tcl.h>
#include <tk.h>
#include "tclXessInt.h"

/*
 * XessConnObj_test_cmd
 *
 *	Handle the `test' command on an Xess connection object
 *
 * Syntax:
 *	connectionName test
 *
 * Where:
 *	connectionName is the name of the Xess connection to be tested.
 *
 * Results:
 *	Returns a standard Tcl result.
 *
 * Bugs:
 *	The connection library always seems to report that the connection
 *	is closed.
 */

int
XessConnObj_test_cmd (clientData, interp, argc, argv)
     ClientData clientData;
     Tcl_Interp * interp;
     int argc;
     char * * argv;
{
  XessConnection * conn = (XessConnection *) clientData;

  if (argc != 1) {
    Tcl_AppendResult (interp, "wrong # args, should be \"", argv [-1],
		      " ", argv [0], "\"", (char *) NULL);
    return TCL_ERROR;
  }

  if (xess_test_connection (conn -> port))
    return TCL_OK;
  else {
    Tcl_SetResult (interp, "connection closed", TCL_STATIC);
    Tcl_DeleteCommand (interp, conn -> objectName);
    return TCL_ERROR;
  }
}
