static char copyright []
= "$Id: xessCloseCallback.c,v 1.1 1994/08/26 13:37:26 johnsonm Exp $\n\
   Copyright (c) 1992 General Electric.  All rights reserved.";

/*
 *   Permission to use, copy, modify, and distribute this
 *   software and its documentation for any purpose and without
 *   fee is hereby granted, provided that the above copyright
 *   notice appear in all copies and that both that copyright
 *   notice and this permission notice appear in supporting
 *   documentation, and that the name of General Electric not be used in
 *   advertising or publicity pertaining to distribution of the
 *   software without specific, written prior permission.
 *   General Electric makes no representations about the suitability of
 *   this software for any purpose.  It is provided "as is"
 *   without express or implied warranty.
 *
 *   This work was supported by the DARPA Initiative in Concurrent
 *   Engineering (DICE) through DARPA Contract MDA972-88-C-0047.
 *
 * $Log: xessCloseCallback.c,v $
 * Revision 1.1  1994/08/26  13:37:26  johnsonm
 * Initial revision
 *
 *
 * Old log:
 * Revision 1.2  1994/02/28  20:45:09  kennykb
 * Removed call to simpleReportBackgroundError to avoid using the
 * `simple event manager' -- which is not required since the tclXess
 * package assumes linking with Tk.  Instead, use Tk_BackgroundError to
 * report errors on closing Xess connections.
 *
 * Revision 1.1  1992/10/09  19:03:04  kennykb
 * Initial revision
 *
 *
 * xessCloseCallback.c --
 *
 * 	This file contains the code needed to handle a callback from the
 * Xess interface that reports a closed connection port, and report it
 * back to the Tcl environment for further processing.
 *
 */


#include <tcl.h>
#include <tk.h>
#include "tclXessInt.h"

static void XessCloseCallback2 _ANSI_ARGS_((ClientData));

/*
 * xessCloseCallback --
 *
 *	This function is called from the Xess connection library when a
 * connection to Xess is unexpectedly closed (e.g., when the copy of Xess
 * terminates).  It locates the connection object, executes the Tcl procedure
 * responsible for closing it, and returns.
 *
 * Bugs:
 *	It appears that if more than one connection is live to the
 * 	same Xess instance, only the most recently created one is notified
 * 	of the close.
 */

void
XessCloseCallback (port)
     int port;
{
  Tk_DoWhenIdle (XessCloseCallback2, (ClientData) port);
}

static void
XessCloseCallback2 (clientData)
     ClientData clientData;
{
  int port = (int) clientData;
  XessConnection * connection;
  int status;

  /* Find the connection entry in the connection table */

  connection = XessConnTable [port];

  /* Execute the user-specified callback to close the connection */

  if (connection != NULL) {

    connection -> flags |= XESS_CONNECTION_CLOSED;
    Tcl_ResetResult (connection -> interp);
    status = XessEvalCallback (connection,
			       connection -> interp,
			       connection -> closeCmd,
			       "CDNPW");

    if (status != TCL_OK) {
      Tcl_AddErrorInfo (connection -> interp,
			"(command invoked by closing Xess connection)\n");
      Tk_BackgroundError (connection -> interp);
    }

    Tcl_ResetResult (connection -> interp);

    /* Delete the connection */

    Tcl_DeleteCommand (connection -> interp, connection -> objectName);
  }

    
}
