static char copyright []
= "$Id: xessConstraint.c,v 1.1 1994/08/26 13:43:06 johnsonm Exp $\n\
   Copyright (c) 1992 General Electric.  All rights reserved.";

/*
 *   Permission to use, copy, modify, and distribute this
 *   software and its documentation for any purpose and without
 *   fee is hereby granted, provided that the above copyright
 *   notice appear in all copies and that both that copyright
 *   notice and this permission notice appear in supporting
 *   documentation, and that the name of General Electric not be used in
 *   advertising or publicity pertaining to distribution of the
 *   software without specific, written prior permission.
 *   General Electric makes no representations about the suitability of
 *   this software for any purpose.  It is provided "as is"
 *   without express or implied warranty.
 *
 *   This work was supported by the DARPA Initiative in Concurrent
 *   Engineering (DICE) through DARPA Contract MDA972-88-C-0047.
 *
 * $Log: xessConstraint.c,v $
 * Revision 1.1  1994/08/26  13:43:06  johnsonm
 * Initial revision
 *
 *
 * Old log:
 * Revision 1.3  1994/03/02  22:53:52  kennykb
 * Corrected typo in RCS identification.
 *
 * Revision 1.2  1994/02/28  20:50:55  kennykb
 * Removed #includes that are now obtained from tclXessInt.h
 *
 * Revision 1.1  1992/10/09  19:03:39  kennykb
 * Initial revision
 *
 *
 * xessConstraint.c --
 *
 *	This file contains the functions providing a Tcl interface to the
 * `Constraints' functions in the Xess connection library.
 */

#include "tclXessInt.h"

/* XessConnObj_evaluate_contraint_cmd --
 *
 *	Command on an Xess connection object to test the constraint in a
 *	specified cell.
 *
 * Syntax:
 *	connection evaluate_constraint cell
 *
 * Where:
 *	connection is the name of an Xess connection object.
 *	cell is the address of a cell.
 *
 * Result:
 *	Returns a standard Tcl result.  The result indicates success and is
 *	empty if the constraint is satisfied.  The result is `constraint
 *	violation' and is an error if the constraint fails.
 */

int
XessConnObj_evaluate_constraint_cmd (clientData, interp, argc, argv)
     ClientData clientData;
     Tcl_Interp * interp;
     int argc;
     char * * argv;
{
  XessConnection * conn = (XessConnection *) clientData;
  XessCell cell;
  int status;

  /* Check syntax */

  if (argc != 2) {
    Tcl_AppendResult (interp, "wrong # args: should be \"", argv [-1], " ",
		      argv [0], " cell\"", (char *) NULL);
    return TCL_ERROR;
  }

  /* Get the cell address */

  status = xessGetCell (interp, argv [1], &cell);
  if (status != TCL_OK)
    return status;

  /* Check the constraint */

  status = xess_evaluate_constraint (conn -> port, cell.row, cell.col);
  switch (status)
    {
    case 0:
      return TCL_OK;
    case 1:
      Tcl_SetResult (interp, "constraint violation", TCL_STATIC);
      return TCL_ERROR;
    default:
      sprintf (interp -> result,
	       "xess_evaluate_constraint returned unexpected status %d",
	       status);
      return TCL_ERROR;
    }
}

/* XessConnObj_recalculate_contraints_cmd --
 *
 *	Command on an Xess connection object to test the constraints in an
 *	entire spreadsheet.
 *
 * Syntax:
 *	connection recalculate_constraints
 *
 * Where:
 *	connection is the name of an Xess connection object.
 *
 * Result:
 *	Returns a standard Tcl result.  The result indicates success and is
 *	zero if all constraints are satisfied.  Otherwise, the result is an
 *	error and consists of the number of failed constraints.
 */

int
XessConnObj_recalculate_constraints_cmd (clientData, interp, argc, argv)
     ClientData clientData;
     Tcl_Interp * interp;
     int argc;
     char * * argv;
{
  XessConnection * conn = (XessConnection *) clientData;
  XessCell cell;
  int status;

  /* Check syntax */

  if (argc != 1) {
    Tcl_AppendResult (interp, "wrong # args: should be \"", argv [-1], " ",
		      argv [0], "\"", (char *) NULL);
    return TCL_ERROR;
  }

  /* Check the constraint */

  status = xess_recalc_constraints (conn -> port);
  if (status == 0)
    return TCL_OK;
  else if (status > 0) {
    sprintf (interp -> result, "%d constraint%s violated", status,
	     (status > 1) ? "s" : "");
    return TCL_ERROR;
  }
  else {
    sprintf (interp -> result,
	     "xess_recalc_constraints returned unexpected status %d",
	     status);
    return TCL_ERROR;
  }
}
