static char copyright []
= "$Id: xessDialog.c,v 1.1 1994/08/26 13:48:27 johnsonm Exp $\n\
   Copyright (c) 1992 General Electric.  All rights reserved.";

/*
 *   Permission to use, copy, modify, and distribute this
 *   software and its documentation for any purpose and without
 *   fee is hereby granted, provided that the above copyright
 *   notice appear in all copies and that both that copyright
 *   notice and this permission notice appear in supporting
 *   documentation, and that the name of General Electric not be used in
 *   advertising or publicity pertaining to distribution of the
 *   software without specific, written prior permission.
 *   General Electric makes no representations about the suitability of
 *   this software for any purpose.  It is provided "as is"
 *   without express or implied warranty.
 *
 *   This work was supported by the DARPA Initiative in Concurrent
 *   Engineering (DICE) through DARPA Contract MDA972-88-C-0047.
 *
 * $Log: xessDialog.c,v $
 * Revision 1.1  1994/08/26  13:48:27  johnsonm
 * Initial revision
 *
 *
 * Old log:
 * Revision 1.2  1994/02/28  20:51:41  kennykb
 * Removed #includes that are now obtained from tclXessInt.h
 *
 * Changed the Tk_ConfigureWidget call for the dialog box so that it
 * uses Tk_MainWindow to get the main window for the application, rather than
 * needing to store it in the XessConnection structure.
 *
 * Revision 1.1  1992/10/09  19:04:27  kennykb
 * Initial revision
 *
 *
 * xessDialog.c --
 *
 *	Functions to control Xess dialog boxes.
 */

#include "tclXessInt.h"

/* Pointer to the connection object that is maintaining the current dialog */

static
XessConnection * XessCurrentDialog = (XessConnection *) NULL;

/* Data structure controlling the current dialog */

static
struct XessDialog {
  char * busycommand;		/* Tcl callback for BUSY status */
  char * cancelcommand;		/* Tcl callback for CANCEL status */
  char * command;		/* Tcl callback for OK status */
  char * dfault;		/* Default value for user input */
  char * prompt;		/* Message for prompt */
} XessDialog;

/* Options for the `dialogue' command */

static Tk_ConfigSpec xessDialogOpts [] = {
  {TK_CONFIG_STRING, "-busycommand", "xessDialogBusyCommand",
     "XessDialogBusyCommand", (char *) NULL,
     Tk_Offset (struct XessDialog, busycommand), TK_CONFIG_NULL_OK},
  {TK_CONFIG_STRING, "-cancelcommand", "xessDialogCancelCommand",
     "XessDialogCancelCommand", (char *) NULL,
     Tk_Offset (struct XessDialog, cancelcommand), TK_CONFIG_NULL_OK},
  {TK_CONFIG_STRING, "-command", "xessDialogCommand", "XessDialogCommand",
     (char *) NULL, Tk_Offset (struct XessDialog, command), TK_CONFIG_NULL_OK},
  {TK_CONFIG_STRING, "-default", "xessDialogDefault", "XessDialogDefault",
     "", Tk_Offset (struct XessDialog, dfault), 0},
  {TK_CONFIG_STRING, "-prompt", "xessDialogPrompt", "XessDialogPrompt",
     "Input requested from application.",
     Tk_Offset (struct XessDialog, prompt), 0},
  {TK_CONFIG_END}
};

/* Static functions in this file */

static void XessDialogCallback _ANSI_ARGS_((int, char *));
				/* Callback when a dialog completes */

/*
 * xessConnObj_dialogue_cmd --
 *
 *	Display a dialogue box to prompt the user for the answer to a question.
 *
 * Syntax:
 *
 *	connectionName dialogue ?-option value?... 
 *
 * Where:
 *
 *	connectionName is the name of an Xess connection object
 *
 * Options:
 *
 *	-prompt TEXT
 *		Specifies the text with which to prompt the user.
 *		Default is `Input requested from application.', which
 *		isn't terribly informative
 *
 *	-default TEXT
 *		Specifies the data with which to pre-initialize the entry
 *		area of the dialog box.  Default is the empty string.
 *
 *	-busycommand COMMAND
 *		Specifies the Tcl command to execute if the dialog fails
 *		because Xess had another dialog in progress.  Default is
 *		the null string, which does nothing.
 *
 *	-cancelcommand COMMAND
 *		Specifies the Tcl command to execute if the dialog fails
 *		because the user pressed `Cancel'.  Default is the null
 *		string, which does nothing.
 *
 *	-command COMMAND
 *		Specifies the Tcl command to execute if the dialog succeeds.
 *
 * Notes:
 *	All the options allow for standard % substitutions.  The %m
 *	substitution returns the user's input.
 *
 * Result:
 *	Returns a standard Tcl result.
 *
 * Bugs:
 *	The connection library appears not to handle the `default' input
 *	properly.  It's probably a better idea to build the dialog box with
 *	Tk, anyway...
 */

int
XessConnObj_dialogue_cmd (clientData, interp, argc, argv)
     ClientData clientData;
     Tcl_Interp * interp;
     int argc;
     char * * argv;
{
  XessConnection * conn = (XessConnection *) clientData;

  int status;
  Tk_Window win;

  /* Make sure that there isn't another dialog box up.  The connection
     library can't do multiple dialogs at a time. */

  if (XessCurrentDialog != NULL) {
    Tcl_SetResult (interp, "another dialog is active", TCL_STATIC);
    return TCL_ERROR;
  }

  /* Parse the arguments */

  status = Tk_ConfigureWidget (interp, Tk_MainWindow (interp), xessDialogOpts,
			       argc-1, argv+1, (char *) &XessDialog, 0);
  if (status != TCL_OK)
    return status;

  /* Launch the dialog. */

  XessCurrentDialog = conn;
#ifdef DEBUG_PRINTF
  fprintf (stderr, "\nxess_dialog, port %d prompt \"%s\" default \"%s\"\n",
	   conn -> port, XessDialog.prompt, XessDialog.dfault);
#endif
  xess_dialog (conn -> port, XessDialog.prompt, XessDialog.dfault,
	       XessDialogCallback);

  /* All done until the connection library gets back to us. */

  return TCL_OK;
}

/*
 * XessDialogCallback --
 *
 *	Handle the callback from the Xess connection library when an Xess
 * 	dialog completes.
 */

static void
XessDialogCallback (status, string)
     int status;
     char * string;
{
  char * command;
  int tclStatus;

  /* Make sure that we know about the callback.  Otherwise, things
     could get weird. */

  if (XessCurrentDialog == NULL) {
    fprintf (stderr,
	     "\nXess dialog callback received when no dialog was active!?\n");
    abort ();
  }

  /* Decode the status */

  switch (status)
    {
    case XESS_DIALOG_OK:
      command = XessDialog.command;
      break;
    case XESS_DIALOG_CANCELED:
      command = XessDialog.cancelcommand;
      break;
    default:
      command = XessDialog.busycommand;
      break;
    }

  /* Execute a callback into the Tcl environment */

  if (command != NULL) {
    if (string != NULL)
      XessCallbackMessage = string;
    else
      XessCallbackMessage = "";
    Tcl_ResetResult (XessCurrentDialog -> interp);
    tclStatus = XessEvalCallback (XessCurrentDialog,
				  XessCurrentDialog -> interp,

				  command, "CDNPWm");
    if (tclStatus != TCL_OK) {
      xess_display_message (XessCurrentDialog -> port,
			    XessCurrentDialog -> interp -> result);
    }
    Tcl_ResetResult (XessCurrentDialog -> interp);
    XessCallbackMessage = "";
  }

  /* Release the dialog */

  XessDialogCleanup (XessCurrentDialog);
}

/*
 * XessDialogCleanup --
 *
 *	Release storage occupied by an Xess dialog when it terminates, either
 *	with its callback or because its connection was closed.
 */

void
XessDialogCleanup (conn)
     XessConnection * conn;
{
  /* Make sure we're working with the right connection */

  if (conn != XessCurrentDialog)
    return;

  /* Free storage */

  if (XessDialog.busycommand != NULL)
    (void) ckfree (XessDialog.busycommand);
  XessDialog.busycommand = NULL;
  if (XessDialog.cancelcommand != NULL)
    (void) ckfree (XessDialog.cancelcommand);
  XessDialog.cancelcommand = NULL;
  if (XessDialog.command != NULL)
    (void) ckfree (XessDialog.command);
  XessDialog.command = NULL;
  if (XessDialog.dfault != NULL)
    (void) ckfree (XessDialog.dfault);
  XessDialog.dfault = NULL;
  if (XessDialog.prompt != NULL)
    (void) ckfree (XessDialog.prompt);
  XessDialog.prompt = NULL;

  /* Dialog no longer in progress */

  XessCurrentDialog = (XessConnection *) NULL;
}
