static char copyright []
= "$Id: xessFlush.c,v 1.1 1994/11/09 15:56:58 johnsonm Exp $\n\
   Copyright (C) 1994 Applied Information Systems.  All rights reserved.";

/*
 *   Permission to use, copy, modify, and distribute this
 *   software and its documentation for any purpose and without
 *   fee is hereby granted, provided that the above copyright
 *   notice appear in all copies and that both that copyright
 *   notice and this permission notice appear in supporting
 *   documentation, and that the name of Applied Information
 *   Systems not be used in advertising or publicity pertaining
 *   to distribution of the software without specific, written
 *   prior permission.
 *   Applied Information Systems makes no representations about
 *   the suitability of this software for any purpose.  It is
 *   provided "as is" without express or implied warranty.
 *
 * $Log: xessFlush.c,v $
 * Revision 1.1  1994/11/09  15:56:58  johnsonm
 * Initial revision
 *
 *
 *
 * xessFlush.c --
 *
 *	This file contains the C source for the `xess' subcommand that
 *      flushes all ports.
 */

#include "tclXessInt.h"

/*
 * Xess_flush_cmd --
 *
 *	Xess subcommand to flush all ports at once
 *
 * Syntax:
 *	xess flush
 *
 * Result:
 *	Returns a standard Tcl result.
 */

/* ARGSUSED */
int
Xess_flush_cmd (clientData, interp, argc, argv)
     ClientData clientData;
     Tcl_Interp * interp;
     int argc;
     char * * argv;
{
  if (argc != 1) {
    Tcl_AppendResult (interp, "wrong # args, should be \"", argv [-1], " ",
		      argv [0], (char *) NULL);
    return TCL_ERROR;
  }

  xess_flush();
  return TCL_OK;
}
