static char copyright []
= "$Id: xessFunct.c,v 1.1 1994/08/26 13:58:29 johnsonm Exp $\n\
   Copyright (c) 1992 General Electric.  All rights reserved.";

/*
 *   Permission to use, copy, modify, and distribute this
 *   software and its documentation for any purpose and without
 *   fee is hereby granted, provided that the above copyright
 *   notice appear in all copies and that both that copyright
 *   notice and this permission notice appear in supporting
 *   documentation, and that the name of General Electric not be used in
 *   advertising or publicity pertaining to distribution of the
 *   software without specific, written prior permission.
 *   General Electric makes no representations about the suitability of
 *   this software for any purpose.  It is provided "as is"
 *   without express or implied warranty.
 *
 *   This work was supported by the DARPA Initiative in Concurrent
 *   Engineering (DICE) through DARPA Contract MDA972-88-C-0047.
 *
 * $Log: xessFunct.c,v $
 * Revision 1.1  1994/08/26  13:58:29  johnsonm
 * Initial revision
 *
 *
 * Old log:
 * Revision 1.2  1994/02/28  20:56:12  kennykb
 * Removed #includes that are now obtained from tclXessInt.h
 * Changed call to Tcl_Eval for version 7 compatibility.
 *
 * Revision 1.1  1992/10/09  19:06:55  kennykb
 * Initial revision
 *
 *
 * xessFunct.c --
 *
 *	This file contains the procedures necessary to install Tcl
 *	functions as external functions in an Xess spreadsheet.
 */
 
#include <ctype.h>
#include "tclXessInt.h"

static Operand xessFunctCallback _ANSI_ARGS_((Operand *));
static int xessOperandConvert _ANSI_ARGS_((Tcl_Interp *, Operand, char * *));
static int xessEvalFunct _ANSI_ARGS_((XessConnection *, Tcl_Interp *, char *));
static void xessConvertResult _ANSI_ARGS_((int, Tcl_Interp *, Operand *));

/* Bugs -- xess_conv_warn isn't in xess.h */

extern int xess_conv_warn;

/* Bugs -- While the connection library accepts a tagged function, the tag is
 * not returned to the application on the callback.  This means that each
 * C function must be unique.  The following set of C functions allows for
 * 256 distinct remote functions per Tcl process.  It could be expanded.
 */

#define MAXFUNCT 256

static int tags [MAXFUNCT];
static int Tag;
static int nFunctions = 0;

#ifdef __STDC__
#define cat(a,b) a##b
#else
#ifdef __REISER__
#define cat(a,b) a/**/b
#else
#define cat(a,b) a\
b
#endif
#endif

#define makefunct(n) \
static Operand 								\
cat(function_,n) (operandv)						\
     Operand *operandv;							\
{									\
  Tag = tags [n];							\
  return xessFunctCallback (operandv);					\
}

makefunct(0) makefunct(1) makefunct(2) makefunct(3) makefunct(4)
makefunct(5) makefunct(6) makefunct(7) makefunct(8) makefunct(9)
makefunct(10) makefunct(11) makefunct(12) makefunct(13) makefunct(14)
makefunct(15) makefunct(16) makefunct(17) makefunct(18) makefunct(19)
makefunct(20) makefunct(21) makefunct(22) makefunct(23) makefunct(24)
makefunct(25) makefunct(26) makefunct(27) makefunct(28) makefunct(29)
makefunct(30) makefunct(31) makefunct(32) makefunct(33) makefunct(34)
makefunct(35) makefunct(36) makefunct(37) makefunct(38) makefunct(39)
makefunct(40) makefunct(41) makefunct(42) makefunct(43) makefunct(44)
makefunct(45) makefunct(46) makefunct(47) makefunct(48) makefunct(49)
makefunct(50) makefunct(51) makefunct(52) makefunct(53) makefunct(54)
makefunct(55) makefunct(56) makefunct(57) makefunct(58) makefunct(59)
makefunct(60) makefunct(61) makefunct(62) makefunct(63) makefunct(64)
makefunct(65) makefunct(66) makefunct(67) makefunct(68) makefunct(69)
makefunct(70) makefunct(71) makefunct(72) makefunct(73) makefunct(74)
makefunct(75) makefunct(76) makefunct(77) makefunct(78) makefunct(79)
makefunct(80) makefunct(81) makefunct(82) makefunct(83) makefunct(84)
makefunct(85) makefunct(86) makefunct(87) makefunct(88) makefunct(89)
makefunct(90) makefunct(91) makefunct(92) makefunct(93) makefunct(94)
makefunct(95) makefunct(96) makefunct(97) makefunct(98) makefunct(99)
makefunct(100) makefunct(101) makefunct(102) makefunct(103) makefunct(104)
makefunct(105) makefunct(106) makefunct(107) makefunct(108) makefunct(109)
makefunct(110) makefunct(111) makefunct(112) makefunct(113) makefunct(114)
makefunct(115) makefunct(116) makefunct(117) makefunct(118) makefunct(119)
makefunct(120) makefunct(121) makefunct(122) makefunct(123) makefunct(124)
makefunct(125) makefunct(126) makefunct(127) makefunct(128) makefunct(129)
makefunct(130) makefunct(131) makefunct(132) makefunct(133) makefunct(134)
makefunct(135) makefunct(136) makefunct(137) makefunct(138) makefunct(139)
makefunct(140) makefunct(141) makefunct(142) makefunct(143) makefunct(144)
makefunct(145) makefunct(146) makefunct(147) makefunct(148) makefunct(149)
makefunct(150) makefunct(151) makefunct(152) makefunct(153) makefunct(154)
makefunct(155) makefunct(156) makefunct(157) makefunct(158) makefunct(159)
makefunct(160) makefunct(161) makefunct(162) makefunct(163) makefunct(164)
makefunct(165) makefunct(166) makefunct(167) makefunct(168) makefunct(169)
makefunct(170) makefunct(171) makefunct(172) makefunct(173) makefunct(174)
makefunct(175) makefunct(176) makefunct(177) makefunct(178) makefunct(179)
makefunct(180) makefunct(181) makefunct(182) makefunct(183) makefunct(184)
makefunct(185) makefunct(186) makefunct(187) makefunct(188) makefunct(189)
makefunct(190) makefunct(191) makefunct(192) makefunct(193) makefunct(194)
makefunct(195) makefunct(196) makefunct(197) makefunct(198) makefunct(199)
makefunct(200) makefunct(201) makefunct(202) makefunct(203) makefunct(204)
makefunct(205) makefunct(206) makefunct(207) makefunct(208) makefunct(209)
makefunct(210) makefunct(211) makefunct(212) makefunct(213) makefunct(214)
makefunct(215) makefunct(216) makefunct(217) makefunct(218) makefunct(219)
makefunct(220) makefunct(221) makefunct(222) makefunct(223) makefunct(224)
makefunct(225) makefunct(226) makefunct(227) makefunct(228) makefunct(229)
makefunct(230) makefunct(231) makefunct(232) makefunct(233) makefunct(234)
makefunct(235) makefunct(236) makefunct(237) makefunct(238) makefunct(239)
makefunct(240) makefunct(241) makefunct(242) makefunct(243) makefunct(244)
makefunct(245) makefunct(246) makefunct(247) makefunct(248) makefunct(249)
makefunct(250) makefunct(251) makefunct(252) makefunct(253) makefunct(254)
makefunct(255)

static Operand (*functionTable [MAXFUNCT]) _ANSI_ARGS_((Operand *)) = {
  function_0, function_1, function_2, function_3, function_4,
  function_5, function_6, function_7, function_8, function_9,
  function_10, function_11, function_12, function_13, function_14,
  function_15, function_16, function_17, function_18, function_19,
  function_20, function_21, function_22, function_23, function_24,
  function_25, function_26, function_27, function_28, function_29,
  function_30, function_31, function_32, function_33, function_34,
  function_35, function_36, function_37, function_38, function_39,
  function_40, function_41, function_42, function_43, function_44,
  function_45, function_46, function_47, function_48, function_49,
  function_50, function_51, function_52, function_53, function_54,
  function_55, function_56, function_57, function_58, function_59,
  function_60, function_61, function_62, function_63, function_64,
  function_65, function_66, function_67, function_68, function_69,
  function_70, function_71, function_72, function_73, function_74,
  function_75, function_76, function_77, function_78, function_79,
  function_80, function_81, function_82, function_83, function_84,
  function_85, function_86, function_87, function_88, function_89,
  function_90, function_91, function_92, function_93, function_94,
  function_95, function_96, function_97, function_98, function_99,
  function_100, function_101, function_102, function_103, function_104,
  function_105, function_106, function_107, function_108, function_109,
  function_110, function_111, function_112, function_113, function_114,
  function_115, function_116, function_117, function_118, function_119,
  function_120, function_121, function_122, function_123, function_124,
  function_125, function_126, function_127, function_128, function_129,
  function_130, function_131, function_132, function_133, function_134,
  function_135, function_136, function_137, function_138, function_139,
  function_140, function_141, function_142, function_143, function_144,
  function_145, function_146, function_147, function_148, function_149,
  function_150, function_151, function_152, function_153, function_154,
  function_155, function_156, function_157, function_158, function_159,
  function_160, function_161, function_162, function_163, function_164,
  function_165, function_166, function_167, function_168, function_169,
  function_170, function_171, function_172, function_173, function_174,
  function_175, function_176, function_177, function_178, function_179,
  function_180, function_181, function_182, function_183, function_184,
  function_185, function_186, function_187, function_188, function_189,
  function_190, function_191, function_192, function_193, function_194,
  function_195, function_196, function_197, function_198, function_199,
  function_200, function_201, function_202, function_203, function_204,
  function_205, function_206, function_207, function_208, function_209,
  function_210, function_211, function_212, function_213, function_214,
  function_215, function_216, function_217, function_218, function_219,
  function_220, function_221, function_222, function_223, function_224,
  function_225, function_226, function_227, function_228, function_229,
  function_230, function_231, function_232, function_233, function_234,
  function_235, function_236, function_237, function_238, function_239,
  function_240, function_241, function_242, function_243, function_244,
  function_245, function_246, function_247, function_248, function_249,
  function_250, function_251, function_252, function_253, function_254,
  function_255
  };

/*
 * XessConnObj_install_function_cmd
 *
 *	Install a Tcl function as an external function in an Xess spreadsheet
 *
 * Syntax:
 *	connection install_function name tclname
 *
 * Where:
 *	connection is the name of an Xess connection
 *	name is the name of a new function to make available in the sheet
 *	tclname is the name of the Tcl function to bind to it.
 *
 * Results:
 *	Returns a standard Tcl result, normally empty.
 *
 * Description:
 *
 *	The `install_function' command makes a Tcl function available as
 *	an @-function in a spreadsheet.  When such a function is evaluated
 *	during recalculation, the Tcl function is called, with a Tcl
 *	representation of the parameters.  Each parameter may be:
 *		- a number, expressed in %#g format,
 *		- a cell, expressed as, e.g., `AY11'
 *		- a range of cells, expressed as ``AY11:BA13''
 *		- a string
 *		- an error message from a previous calculation
 *      The function returns the expected value of the cell.  If it throws
 *      an error, the error message is returned as an error message to Xess.
 *	
 *	During the execution of the function, the following global variables
 *	are set:
 *
 *	$xess_connection - Set to the connection ID that initiated the function
 *		call.
 *	$xess_current_cell - Set to the current cell in the spreadsheet
 *	$xess_flags - This variable is an array, with the following members:
 *		RECALC - Set to 1 if a recalculation is in progress, and
 *			0 otherwise.
 *		FORCE_RECALC - Set to 1 if a forced recalculation is in 
 *			progress, and 0 otherwise.
 *		FULL_RECALC - Set to 1 if a full recalculation is in progress,
 *			and 0 otherwise.
 *		MANUAL_MODE - Set to 1 if automatic recalculation is disabled.
 *		CONSTRAINT_MODE - Set to 1 if constraint checks are OFF.
 *		CONSTRAINT - Set to 1 if a function was invoked from a
 *			constraint expression
 *		CONV_WARN - Set to 1 if a floating point conversion error
 *			has occurred in parameter transmission.
 *
 * Rationale for global variables:
 *	All the other Xess callback bindings use %-expressions to describe
 *	the state of the connection.  This one, however, uses external
 *	variables.  The reason is that functions may reasonably expect
 *	to have a variable number of arguments, making a %-substitution
 *	for parameters difficult.  It is more reasonable to have a function's
 *	arguments match the caller's arguments, and have global variables
 *	`on the side' for the few examples where they are needed.
 */

int
XessConnObj_install_function_cmd (clientData, interp, argc, argv)
     ClientData clientData;
     Tcl_Interp * interp;
     int argc;
     char * * argv;
{
  XessConnection * conn = (XessConnection *) clientData;
  XessFunction * funct;
  char *p, *q;
  int c;

  /* Check syntax */

  if (argc != 3) {
    Tcl_AppendResult (interp, "wrong # args: should be \"", argv [-1], " ",
		      argv [0], " name tclName\"", (char *) NULL);
    return TCL_ERROR;
  }

  /* Make the function object */

  funct = ckalloc (sizeof * funct);
  funct -> next = conn -> firstFunction;
  if (funct -> next != NULL) {
    funct -> next -> prev = funct;
  }
  conn -> firstFunction = funct;
  funct -> prev = NULL;
  funct -> conn = conn;

  /* Fill in the function names.  Note that the XESS function name must be
   * all uppercase, so we convert it here.
   */

  p = argv [1];
  funct -> name = ckalloc (strlen (p) + 1);
  q = funct -> name;
  do {
    c = *p++;
    if (islower (c))
      c = toupper (c);
    *q++ = c;
  } while (c != '\0');
  funct -> function = ckalloc (strlen (argv [2]) + 1);
  (void) strcpy (funct -> function, argv [2]);

  /* Install the function in Xess */

  /*
    if tagged functions worked, this would be --
    xess_install_function (conn -> port, funct -> name, xessFunctCallback,
                           (int) funct);
  */
  if (nFunctions >= MAXFUNCT) {
    Tcl_SetResult (interp, "too many functions", TCL_STATIC);
    return TCL_ERROR;
  }
  tags [nFunctions] = (int) funct;
  xess_install_function (conn -> port, funct -> name,
			 functionTable [nFunctions++], (int) funct);

  return TCL_OK;
}

/*
 * XessFunctObj_Delete
 *
 *	This procedure deletes an Xess function object, removes all its
 * 	linkage, and returns its space.
 */

void
XessFunctObj_Delete (funct)
     XessFunction * funct;
{
  if (funct -> next != NULL) {
    funct -> next -> prev = funct -> prev;
  }
  if (funct -> prev != NULL) {
    funct -> prev -> next = funct -> next;
  } else {
    funct -> conn -> firstFunction = funct -> next;
  }
  (void) ckfree (funct -> name);
  (void) ckfree (funct -> function);
  (void) ckfree (funct);
}

/*
 * xessFunctCallback --
 *
 *	This function handles the callback from the Xess connection library
 * 	when an evaluation in an Xess spreadsheet tries to invoke a Tcl
 *	function.
 */

static Operand
xessFunctCallback (operandv)
     Operand *operandv;
{
  
  XessFunction * funct;		/* Function that was called */
  XessConnection * conn;	/* Connection that called it */
  Tcl_Interp * interp;		/* Interpreter in which to evaluate */
  int argc;			/* Number of arguments to function */
  char * * argv = NULL;		/* Place to store function arguments */
  int * argflags = NULL;	/* Flags for Tcl_ConvertElement, per arg. */
  int length;			/* Length of Tcl string to evaluate */
  char * string;		/* Tcl string to evaluate */
  Operand retval;		/* Operand to return */
  int status;
  char * p;
  int i;

  /* Find the function */

  /* if tagged functions worked, we'd use xess_tag instead of Tag */

  if (Tag == 0) {
    sprintf (xess_sbuf, "tag not supplied for function eval");
    retval.type = ARG_ERROR;
    retval.val.string = xess_sbuf;
    return retval;
  }
  funct = (XessFunction *) Tag;

  /* Get other constants */

  conn = funct -> conn;
  interp = conn -> interp;
  length = strlen (funct -> function) + 1;
  Tcl_ResetResult (interp);
  status = TCL_OK;

  /* Expand the function arguments to Tcl form */

  argc = operandv -> val.count;
  if (argc > 0) {
    argv = (char * *) ckalloc (argc * sizeof (*argv));
    argflags = (int *) ckalloc (argc * sizeof (*argflags));
    for (i = 0; i < argc; ++i) {
      status = xessOperandConvert (conn -> interp, operandv [i+1], argv + i);
      if (status != TCL_OK) {
	argc = i;
	break;
      }
      argflags [i] = 0;
      length += Tcl_ScanElement (argv [i], argflags + i);
      ++length;
    }
  }

  /* Make the Tcl command to be executed */

  if (status == TCL_OK) {
    string = (char *) ckalloc (length);
    (void) strcpy (string, funct -> function);
    p = string + strlen (string);
    for (i = 0; i < argc; ++i) {
      *p++ = ' ';
      p += Tcl_ConvertElement (argv [i], p, argflags [i]);
    }
    *p = '\0';

    /* Execute the command */

    status = xessEvalFunct (conn, interp, string);
    (void) ckfree (string);
  }
    
  /* Free up the argument list */

  for (i = 0; i < argc; ++i) {
    (void) ckfree (argv [i]);
  }
  if (operandv -> val.count > 0) {
    (void) ckfree ((char *) argv);
    (void) ckfree ((char *) argflags);
  }

  /* Convert the result of the operation for Xess */

  xessConvertResult (status, interp, &retval);
  Tcl_ResetResult (interp);
  return retval;
}

/*
 * xessOperandConvert --
 *
 *	This function converts a single Xess function argument to Tcl form
 *	for passing to the Tcl function evaluation
 */

static int
xessOperandConvert (interp, operand, string)
     Tcl_Interp * interp;
     Operand operand;
     char * * string;
{
  char convbuf [80];
  char * source = convbuf;
  int status = 0;
  int flags;

  switch (operand.type)
    {
    case ARG_NUMBER:
      sprintf (convbuf, "%#g", operand.val.number);
      break;
    case ARG_STRING:
      source = operand.val.string;
      break;
    case ARG_CELL:
      flags = 0;
      if (operand.val.range.flags & ABS_R0)
	flags |= XESS_CELL_ABSROW;
      if (operand.val.range.flags & ABS_C0)
	flags |= XESS_CELL_ABSCOL;
      status = xessStoreCell (interp,
			      operand.val.range.r0, operand.val.range.c0,
			      flags, convbuf, (char * *) NULL);
      break;
    case ARG_RANGE:
      status = xessStoreRange (interp, &(operand.val.range),
			       convbuf, (char * *) NULL);
      break;
    default:
      Tcl_SetResult (interp, "invalid argument", TCL_STATIC);
      status = TCL_ERROR;
      break;
    }

  if (status == TCL_OK) {
    *string = (char *) ckalloc (strlen (source) + 1);
    (void) strcpy (*string, source);
  }

  return status;
}

/*
 * xessEvalFunct --
 *
 *	This function does the actual Tcl_Eval when a Tcl function is
 *	evaluated from a spreadsheet.  The major complication is that
 *	the connection flags have to be updated to keep the Tcl program
 *	from trying to launch a recalculation, and the `xess' external
 *	variables have to be set with the appropriate values.
 */

static int
xessEvalFunct (conn, interp, code)
     XessConnection * conn;
     Tcl_Interp * interp;
     char * code;
{
  char ccell [30];
  int status;

  /* Mark that evaluation is in progress */

  conn -> flags |= XESS_FUNCTION_PENDING;
  
  /* Get the current cell address */

  status = xessStoreCell (interp, xess_row, xess_col, 0,
			  ccell, (char * *) NULL);
  if (status == TCL_OK) {

    /* Set external variables for evaluation */

    Tcl_SetVar (interp, "xess_connection", conn -> objectName,
		TCL_GLOBAL_ONLY);
    Tcl_SetVar (interp, "xess_current_cell", ccell, TCL_GLOBAL_ONLY);
    Tcl_SetVar2 (interp, "xess_flags", "RECALC",
		 (xess_recalc_flags & XESS_RECALC) ? "1" : "0",
		 TCL_GLOBAL_ONLY);
    Tcl_SetVar2 (interp, "xess_flags", "FORCE_RECALC",
		 (xess_recalc_flags & XESS_FORCE_RECALC) ? "1" : "0",
		 TCL_GLOBAL_ONLY);
    Tcl_SetVar2 (interp, "xess_flags", "FULL_RECALC",
		 (xess_recalc_flags & XESS_FULL_RECALC) ? "1" : "0",
		 TCL_GLOBAL_ONLY);
    Tcl_SetVar2 (interp, "xess_flags", "MANUAL_MODE",
		 (xess_recalc_flags & XESS_MANUAL_MODE) ? "1" : "0",
		 TCL_GLOBAL_ONLY);
    Tcl_SetVar2 (interp, "xess_flags", "CONSTRAINT_MODE",
		 (xess_recalc_flags & XESS_CONSTRAINT_MODE) ? "1" : "0",
		 TCL_GLOBAL_ONLY);
    Tcl_SetVar2 (interp, "xess_flags", "CONSTRAINT",
		 (xess_recalc_flags & XESS_CONSTRAINT) ? "1" : "0",
		 TCL_GLOBAL_ONLY);
    Tcl_SetVar2 (interp, "xess_flags", "CONV_WARN",
		 (xess_conv_warn) ? "1" : "0",
		 TCL_GLOBAL_ONLY);

    /* Call the Tcl function */

    status = Tcl_Eval (interp, code);

    /* Unset the externals */

    (void) Tcl_UnsetVar (interp, "xess_connection", TCL_GLOBAL_ONLY);
    (void) Tcl_UnsetVar (interp, "xess_current_cell", TCL_GLOBAL_ONLY);
    (void) Tcl_UnsetVar2 (interp, "xess_flags", "RECALC",
			  TCL_GLOBAL_ONLY);
    (void) Tcl_UnsetVar2 (interp, "xess_flags", "FORCE_RECALC",
			  TCL_GLOBAL_ONLY);
    (void) Tcl_UnsetVar2 (interp, "xess_flags", "FULL_RECALC",
			  TCL_GLOBAL_ONLY);
    (void) Tcl_UnsetVar2 (interp, "xess_flags", "MANUAL_MODE",
			  TCL_GLOBAL_ONLY);
    (void) Tcl_UnsetVar2 (interp, "xess_flags", "CONSTRAINT_MODE",
			  TCL_GLOBAL_ONLY);
    (void) Tcl_UnsetVar2 (interp, "xess_flags", "CONSTRAINT",
			  TCL_GLOBAL_ONLY);
    (void) Tcl_UnsetVar2 (interp, "xess_flags", "CONV_WARN",
			  TCL_GLOBAL_ONLY);
  }

  /* Evaluation done */

  conn -> flags &= ~ XESS_FUNCTION_PENDING;

  return status;
}

/*
 * xessConvertResult
 *
 *	This function is called to convert a result returned by a Tcl
 *	function into a value to be stored in an Xess spreadsheet.  It
 *	handles numbers, strings, and errors.  It does not handle cells
 *	or ranges (which are of questionable value), although the capability
 *	could be added.
 */

static void
xessConvertResult (status, interp, result)
     int status;
     Tcl_Interp * interp;
     Operand * result;
{
  double d;
  char * end;

  /* Convert errors */

  if (status != TCL_OK) {
    (void) strcpy (xess_sbuf, interp -> result);
    result -> type = ARG_ERROR;
    return;
  }

  /* Determine whether result is numeric */

  d = strtod (interp -> result, &end);
  while ((*end != '\0') && isspace (*end)) {
    ++end;
  }
	 
  /* Convert string result */

  if ((end == interp -> result) || (*end != '\0')) {
    (void) strcpy (xess_sbuf, interp -> result);
    result -> type = ARG_STRING;
    result -> val.string = xess_sbuf;
    return;
  }

  /* Convert numeric result */

  else {
    result -> type = ARG_NUMBER;
    result -> val.number = (Number) d;
    return;
  }
}
