static char copyright []
= "$Id: xessGetFont.c,v 1.1 1994/08/26 14:01:17 johnsonm Exp $\n\
   Copyright (c) 1992 General Electric.  All rights reserved.";

/*
 *   Permission to use, copy, modify, and distribute this
 *   software and its documentation for any purpose and without
 *   fee is hereby granted, provided that the above copyright
 *   notice appear in all copies and that both that copyright
 *   notice and this permission notice appear in supporting
 *   documentation, and that the name of General Electric not be used in
 *   advertising or publicity pertaining to distribution of the
 *   software without specific, written prior permission.
 *   General Electric makes no representations about the suitability of
 *   this software for any purpose.  It is provided "as is"
 *   without express or implied warranty.
 *
 *   This work was supported by the DARPA Initiative in Concurrent
 *   Engineering (DICE) through DARPA Contract MDA972-88-C-0047.
 *
 * $Log: xessGetFont.c,v $
 * Revision 1.1  1994/08/26  14:01:17  johnsonm
 * Initial revision
 *
 *
 * Old log:
 * Revision 1.2  1994/02/28  20:56:56  kennykb
 * Removed #includes that are now obtained from tclXessInt.h
 *
 * Revision 1.1  1992/10/09  19:07:26  kennykb
 * Initial revision
 *
 *
 * xessGetFont.c --
 *
 *	This file contains all the support needed to parse Xess font
 *	specifications.
 */

#include "tclXessInt.h"

static char * xessParseFont _ANSI_ARGS_((char *, int *));
				/* Service function that does the work */

static char * parseError;	/* Error message from the parse */

/*
 * xessGetFont --
 *	Get an Xess font code and return it in `font'.
 *	Returns a Tcl status.
 */

int
xessGetFont (interp, fontname, font)
     Tcl_Interp * interp;
     char * fontname;
     int * font;
{
  char * result;
  result = xessParseFont (fontname, font);
  if (result == NULL)
    return TCL_OK;
  Tcl_SetResult (interp, result, TCL_STATIC);
  return TCL_ERROR;
}

/*
 * xessGetFontArgv --
 *
 *	Do xessGetFont from the context of Tk_ParseArgv
 */

TK_MAKE_GENFUNC( xessGetFontArgv, int, xessGetFont )

/*
 * xessParseFont --
 *
 *	This function does all the real work of parsing a font name
 */

static char *
xessParseFont (fontName, font)
     char * fontName;
     int * font;
{
  int len;
  len = strlen (fontName);
  if (len >= 5 && strncmp (fontName, "bolditalic", len) == 0) {
    *font = FNT_BOLD_ITALIC;
    return NULL;
  }
  else if (strncmp (fontName, "bold", len) == 0) {
    *font = FNT_BOLD;
    return NULL;
  }
  else if (strncmp (fontName, "italic", len) == 0) {
    *font = FNT_ITALIC;
    return NULL;
  }
  else if (strncmp (fontName, "normal", len) == 0) {
    *font = FNT_NORMAL;
    return NULL;
  }
  else if (strncmp (fontName, "default", len) == 0) {
    *font = FNT_DEF;
    return NULL;
  }
  else {
    return "unknown font name";
  }
}
