char RCSid_xessScanCmd_c []
= "$Id: xessScanCmd.c,v 1.1 1994/08/26 14:16:07 johnsonm Exp $";
/* 
 * xessScanCmd --
 *
 *	This file contains the code needed to process the `xess scan_display'
 * Tcl command.
 *
 * $Log: xessScanCmd.c,v $
 * Revision 1.1  1994/08/26  14:16:07  johnsonm
 * Initial revision
 *
 */

/*   Copyright (c) 1994 General Electric.  All rights reserved. */

/*
 *   Permission to use, copy, modify, and distribute this
 *   software and its documentation for any purpose and without
 *   fee is hereby granted, provided that the above copyright
 *   notice appear in all copies and that both that copyright
 *   notice and this permission notice appear in supporting
 *   documentation, and that the name of General Electric not be used in
 *   advertising or publicity pertaining to distribution of the
 *   software without specific, written prior permission.
 *   General Electric makes no representations about the suitability of
 *   this software for any purpose.  It is provided "as is"
 *   without express or implied warranty.
 *
 *   This work was supported by the DARPA Initiative in Concurrent
 *   Engineering (DICE) through DARPA Contract MDA972-88-C-0047.
 *
 */

#include "tclXessInt.h"

static Tk_Window makeDummyWindow _ANSI_ARGS_((XessConnection *));



/*
 * Xess_scan_display_cmd --
 *
 * Process the `xess scan_display' Tcl command.
 *
 * The command takes the form:
 *
 * 	xess scan_display ?-display DISPLAYNAME?
 *
 * 	-display NAME
 *
 *	Attempts to connect to a copy of Xess running on the display called
 *	NAME.  The default is the display on which the Tk application's main
 *	window appears.
 *
 * Return value:
 *	A list of window ID's corresponding to the Xess windows open
 *	on the specified display.
 */

int
Xess_scan_display_cmd (clientData, interp, argc, argv)
     ClientData clientData;
     Tcl_Interp * interp;
     int argc;
     char * * argv;
{

  Display * theDisplay;		/* X Display to scan */
  int dispID = 0;		/* Xess display ID for the display */
  Window * windowList;		/* Xess window list for the display */
  int windowCount;		/* Number of Xess windows on display */
  Tcl_DString result;		/* Return value for Tcl */
  int status = TCL_OK;		/* Status return to Tcl interpreter */
  int i;
  char tempString [16];

  /* Check that sufficient arguments are supplied */

  if (argc != 1 && argc != 3) {
    Tcl_AppendResult (interp, "wrong # args, should be \"", argv [-1], " ",
		      argv [0], " name ?-display displayName?...\"",
		      (char *) NULL);
    return TCL_ERROR;
  }

  /* Check the `-display' option */

  if (argc == 3 && 
      (argv [1] [0] != '-' || argv [1] [1] != 'd'
       || strncmp (argv [1], "-display", strlen (argv [1])) != 0)) {
    Tcl_AppendResult (interp, "unknown option `", argv [1],
		      "', should be ", argv [-1], " ", argv [0],
		      " ?-display displayName?", (char *) NULL);
    return TCL_ERROR;
  }

  /* Open the requested display */

  if (argc == 1) {
    theDisplay = Tk_Display (Tk_MainWindow (interp));
  } else {
    theDisplay = XOpenDisplay (argv [2]);
    if (theDisplay == NULL) {
      Tcl_AppendResult (interp, "unable to connect to display \"", argv[2],
			"\"", (char *) NULL);
      return TCL_ERROR;
    }
  }

  /* Give the display to the Xess connection library. */

  dispID = xess_new_display (theDisplay);
  if (dispID == 0) {
    Tcl_AppendResult (interp,
		      "xess connection library refused to register display ",
		      "\"", DisplayString (theDisplay), "\"",
		      (char *) NULL);
    status = TCL_ERROR;
  }

  /* Have Xess scan the display */

  if (status == TCL_OK
      && xess_scan_display (dispID, &windowList, &windowCount) == 0) {
    Tcl_AppendResult (interp,
		      "xess_scan_display failed for display \"",
		      DisplayString (theDisplay), "\"", (char *) NULL);
    status = TCL_ERROR;
  }

  /* Convert results to ASCII form */

  if (status == TCL_OK) {
    Tcl_DStringInit (&result);
    for (i = 0; i < windowCount; ++i) {
      sprintf (tempString, "0x%lx", (long) windowList [i]);
      Tcl_DStringAppendElement (&result, tempString);
    }
    (void) free ((char *) windowList);
    Tcl_DStringResult (interp, &result);
  }

  if (argc == 3) {
    if (dispID != 0) {
      (void) xess_remove_display (dispID);
    }
    (void) XCloseDisplay (theDisplay);
  }

  return status;

}
