/*
 * modified:	20/03/95, change getwd() to getcwd().
 * 		 add include "unist.h",  xkZ
 */
  
 /* dl_find_find()
 * Given a filename and variable "dl_library_path",
 * dl_find_executable searches the directories listed in the variable
 * for a file with that filename.
 * A new copy of the complete path name of that file is returned.
 */

/* This file is part of DLD, a dynamic link/unlink editor for C.

   Copyright (C) 1990 by W. Wilson Ho.

   The author can be reached electronically by how@cs.ucdavis.edu or
   through physical mail at:

   W. Wilson Ho
   Division of Computer Science
   University of California at Davis
   Davis, CA 95616
 */

/* This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 1, or (at your option) any
   later version. */

#include <sys/file.h>
#include <sys/param.h>
#include <unistd.h>

#ifdef __linux__
#include <sys/stat.h>
#include <unistd.h>     /* for R_OK define */
#endif

#ifndef R_OK
#define R_OK 04
#endif


#define DEFAULT_PATH ".:~/bin:~/lib:/usr/local/bin:/usr/new:/usr/ucb:/usr/bin:/bin:/usr/hosts:/usr/local/lib:/usr/lib:/lib"

static char *
copy_of (s)
register char *s;
{
    register char *p = (char *) malloc (strlen(s)+1);

    if (!p) return 0;

    *p = 0;
    strcpy (p, s);
    return p;
}

/* ABSOLUTE_FILENAME_P (fname): True if fname is an absolute filename */
#ifdef atarist
#define ABSOLUTE_FILENAME_P(fname)	((fname[0] == '/') || \
	(fname[0] && (fname[1] == ':')))
#else
#define ABSOLUTE_FILENAME_P(fname)	(fname[0] == '/')
#endif /* atarist */

static char *
dl_find_file(file, dl_library_path)
char *file;
char *dl_library_path;
{
    register char *p;
    char name[MAXPATHLEN];

    if (dl_library_path == NULL)
    	dl_library_path = DEFAULT_PATH;
    		
    if (ABSOLUTE_FILENAME_P(file)) {
	return copy_of (file);
    }
#ifdef __linux__
    if ((file[0] == '.') && (file[1] == '/')) {
	getcwd (name, MAXPATHLEN);
	strcat (name, file+1);
	return copy_of (name);
    }
#endif

    p = dl_library_path;
    while (*p) {
	register char *next;

	next = name;
	/* copy directory name into [name] */
	while (*p && *p != ':') *next++ = *p++;
	*next = 0;
	if (*p) p++;
	if (name[0] == '.' && name[1] == 0)
	    getcwd (name, MAXPATHLEN);
	if (name[0] == '\0' )   /* bypass the null directory */
	    continue;
	if (name[0] == '~') {
	  char tname[MAXPATHLEN];
	  register char *hp=getenv("HOME");
	  strcpy(tname, hp);
	  strcat(tname, &name[1]);
	  strcpy(name, tname);
	} 
	strcat (name, "/");
	strcat (name, file);

	if (access (name, R_OK) == 0) {
/*
#ifdef __linux__
	  struct stat stat_temp;
	  if (stat(name,&stat_temp)) continue;
	  if (S_IFREG != (S_IFMT & stat_temp.st_mode)) continue;
#endif
*/ 
	  return copy_of (name);
	 }
    }
    return NULL;
}

static char *
get_word(src_pp)
char **src_pp;
{
    char *p=*src_pp;
    register char *next=p;

    if (*p == '\0')
    	return NULL;
    while (*next && *next != ' ') 
	next++;
    if (*next)
	*src_pp = next + 1;
    else
    	*src_pp = next;
    *next = '\0';
    return p;
}    

