/*
 * xoipc_stubs.c - Main routine, callbacks, and connections function stubs.
 * This file was generated by `golit' from `xoipc.G'.
 */

#include "xoipc_ui.h"
#include <assert.h>

/* In file static data */
static XtPointer currentSenderData = NULL;
/* Static file data */
static char cmdbuffer[2048];           /* Used for displaying messages */
static Widget output;
static Display *dpy;

static void pickSenderCallback ();
void olitShowString();

String fallback_resources [] = { 
		"*Background: gray",
		NULL
};

/*
 * main for application xoipc
 */
int
main(argc, argv)
	int		argc;
	char		**argv;
{
  Widget widget1;
  Widget mbutton, preview, recName;
  XtAppContext app;
  extern int olitipcInit();
 	
	
  /*
   * Initialize Toolkit
   */
	
  OlToolkitInitialize(NULL); 
  XtToolkitInitialize(); 
	
  /*
   * Create Application Context and set fallback resources 
   */
	
  app = XtCreateApplicationContext(); 
  XtAppSetFallbackResources(app, fallback_resources); 
	
  /*
   * Open Display 
   */
	
  dpy = XtOpenDisplay(app, NULL, "xoipc", "Xoipc",
		      (XrmOptionDescList) NULL, 0, &argc, argv);
	
  widget1 = GolitFetchShellHier("Xoipc_main", "Xoipc",
				Xoipc_main, dpy, NULL, NULL, NULL);
  /* Set Global */
  output = GolitNameToWidget(widget1, "Xoipc_textout");
  assert(output != NULL);
  mbutton = GolitNameToWidget(widget1, "Xoipc_sendset");
  assert(mbutton != NULL);
  preview = GolitNameToWidget(widget1, "Xoipc_sendmessage");
  assert(preview != NULL);
  recName = GolitNameToWidget(widget1, "Xoipc_receiverName");
  assert(recName != NULL);
         
  XtVaSetValues(mbutton, XtNpreviewWidget, (XtArgVal)preview, NULL);

  XtRealizeWidget(widget1);
	
  if (olitipcInit(app, argv[1]) != 0) {
    fprintf(stderr, "Could not initialize tclIPC.  Exiting...\n");
    exit(-1);
  }
  XtVaSetValues(recName, XtNstring, argv[1], NULL);
	
  /*
   * Enter event loop
   */
	
  XtAppMainLoop(app);
  exit(0);
}

static void pickSenderCallback(widget, clientData, callData)
Widget widget;
XtPointer clientData, callData;
{
  char *choice;
  extern char *olitGetLabel();
  Widget preview = GolitNameToWidget(widget, "Xoipc_sendmessage");

  assert(preview != NULL);

  choice = olitGetLabel(clientData);

  /* Set the global for "send" */
  currentSenderData = clientData;
  XtVaSetValues(preview, XtNstring, (XtArgVal)choice, NULL);
}

void
do_beep(widget, clientData, callData)
	Widget widget;
	XtPointer clientData, callData;
{
	printf("connection: do_beep\n");
}

void
screate(widget, clientData, callData)
	Widget widget;
	XtPointer clientData, callData;
{
   extern char *olitAddSender();
   Widget target = GolitNameToWidget(widget, "Xoipc_sname");
   Widget mbutton = GolitNameToWidget(widget, "Xoipc_sendset");
   Widget mpane;
   Widget new;
   Widget preview = GolitNameToWidget(widget, "Xoipc_sendmessage");
   char *str;
   char *newresult;

   XtVaGetValues(target, XtNstring, &str, NULL);

   if ((newresult = olitAddSender(str)) == NULL) {
     return;
   }
  if (mbutton != NULL) {
    XtVaGetValues(mbutton, XtNmenuPane, &mpane, NULL);
    if (mpane != NULL) {
      new = XtCreateManagedWidget(str, oblongButtonWidgetClass,
                            mpane, NULL, 0);
      /* Since I'm supposed to free str, I'll use it */
      XtAddCallback(new, XtNselect, pickSenderCallback, (XtPointer)newresult);
    }
  }
  XFlush(dpy);
  /* Set up the current sender */
  pickSenderCallback(widget, (XtPointer)newresult, (XtPointer)NULL);
}

/* Set an AsciiString */
void olitShowString(cmd, result)
char *cmd;
char *result;
{
  TextPosition cpos;

  if (cmd == NULL || result == NULL) 
    return;

  sprintf(cmdbuffer, "%s\n%s\n", cmd, result);

  OlTextEditClearBuffer(output);
  OlTextEditInsert(output, cmdbuffer, 0);
  OlTextEditSetCursorPosition(output, 0, 0, 0);
}

void
send(widget, clientData, callData)
	Widget widget;
	XtPointer clientData, callData;
{
  extern char *xoipcSend();
  Widget target = GolitNameToWidget(widget, "Xoipc_sendtext");
  char *command, *result;
  char *sendername;


  /* Set the global for "send" */
  XtVaGetValues(target, XtNstring, (XtArgVal)&command, NULL);

  result = xoipcSend(currentSenderData, command);

  olitShowString(command, result);

  /* Free as required! */
  free(command);
}

void
xoipc_sname_CB1(widget, clientData, callData)
	Widget widget;
	XtPointer clientData, callData;
{
  OlTextFieldVerify *tv = (OlTextFieldVerify *)callData;

  if (tv->reason == OlTextFieldReturn) {
    screate(widget, clientData, callData);
  }
}


void
doQuit(widget, clientData, callData)
	Widget widget;
	XtPointer clientData, callData;
{
  extern void olitDoQuit();
  /* Quit to remove connections */
  olitDoQuit();
}

void
xoipc_sendtext_CB1(widget, clientData, callData)
	Widget widget;
	XtPointer clientData, callData;
{
  OlTextFieldVerify *tv = (OlTextFieldVerify *)callData;

  if (tv->reason == OlTextFieldReturn) {
    send(widget, clientData, callData);
  }
}
