/*
 * SMPTE timing info
 */
struct SMPTE_frame {
	unsigned	char rate;
	unsigned	char hour;
	unsigned	char minute;
	unsigned	char second;
	unsigned	char frame;
	unsigned	char fraction;
	unsigned	char status;
}; 


/*
 * SMPTE status bits
 */
#define SMPTE_SYNC	(1 << 0)	/* indicates we are sync'd */
#define SMPTE_FRAMEDROP	(1 << 1)	/* this is a frame-drop format */
#define SMPTE_FIRST0xF1	(1 << 2)	/* we caught the first 1/4 frame */

/*
 * MPU401 ioctls (/dev/midi and /dev/smpte)
 */
#define MRESET	_IO('m', 0x01)
#define MDRAIN	_IO('m', 0x02)
#define MFLUSH	_IO('m', 0x03)
#define MGPLAYQ	_IOR('m', 0x04, int)
#define MGRECQ	_IOR('m', 0x05, int)
#define MSDIVISION	_IOW('m', 0x06, int)
#define MGDIVISION	_IOR('m', 0x07, int)
#define MGQAVAIL	_IOR('m', 0x08, int)
#define MASYNC	_IOW('m', 0x09, int)
#define MTHRU	_IOW('m', 0x0a, int)
#define MRECONPLAY	_IOW('m', 0x0b, int)
#define MGSMPTE	_IOR('m', 0x0c, struct SMPTE_frame)
#define MGSMFTIME	_IOR('m', 0x0d, unsigned long)
