/*-
 * Copyright (c) 1993, 1994 Michael B. Durian.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Michael B. Durian.
 * 4. The name of the the Author may be used to endorse or promote 
 *    products derived from this software without specific prior written 
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * midi port offsets
 */
#define	MIDI_DATA			0
#define	MIDI_STATUS			1
#define	MIDI_COMMAND			1


/*
 * midi data transfer status bits
 */
#define	MIDI_RDY_RCV			(1 << 6)
#define	MIDI_DATA_AVL			(1 << 7)

/*
 * midi status flags
 */
#define MIDI_UNAVAILABLE	(1 << 0) /* not in uart mode */
#define MIDI_READING		(1 << 1) /* open for reading */
#define MIDI_WRITING		(1 << 2) /* open for writing */
#define MIDI_CALLBACK_ISSUED	(1 << 3) /* waiting for a timer to expire */
#define MIDI_RD_BLOCK		(1 << 4) /* read will block */
#define MIDI_WR_BLOCK		(1 << 5) /* write will block */
#define MIDI_WR_ABORT		(1 << 6) /* write should abort */
#define MIDI_OPEN		(1 << 7) /* device is open */
#define MIDI_FLUSH_SLEEP	(1 << 8) /* blocking on flush */
#define MIDI_RD_SLEEP		(1 << 9) /* blocking on read */
#define MIDI_WR_SLEEP		(1 << 10) /* blocking on write */
#define MIDI_BUFFER_SLEEP	(1 << 11) /* blocking on buffer */
#define MIDI_NEED_ACK		(1 << 12) /* command needs and ack */
#define MIDI_ASYNC		(1 << 13) /* send sigios */
#define MIDI_SENDIO		(1 << 14) /* a sigio should be send at low h2o */
#define MIDI_THRU		(1 << 15) /* pass in port to out port? */
#define MIDI_RECONPLAY		(1 << 16) /* don't record until we start to play */
#define MIDI_EXTCLK		(1 << 17) /* use external clock */
#define MIDI_NEED_DATA		(1 << 18) /* need to read command response */
#define MIDI_FIRST_WRITE	(1 << 19) /* the next write will be the first */
#define MIDI_FIRST_SMPTE	(1 << 20) /* set if no SMPTE yet */

/*
 * These are the various input data states
 */
typedef enum {START, NEEDDATA1, NEEDDATA2, SYSEX, SYSTEM1, SYSTEM2, MTC}
    InputState;

/*
 * midi command values
 */
#define MIDI_RESET			0xff
#define MIDI_UART			0x3f
#define MIDI_ACK			0xfe
#define MIDI_VERSION			0xac
#define MIDI_REVISION			0xad
#define MIDI_TRIES			200000

/*
 * SMPTE configuration
 */
#define SMPTE_DROPCHK 10	/* check for loss of sync every 10 ticks */
#define SMPTE_DROPOUT 50	/* 50 ticks without 0xf1 ==> loss of sync */

/*
 * most events are short, so we use the static array,
 * but occationally we get a long event (sysex) and
 * we dynamically allocate that
 */
#define STYNAMIC_SIZE 4
#define STYNAMIC_ALLOC 256

struct stynamic {
	short	allocated;
	short	len;
	u_char	datas[4];
	u_char	*datad;
};

/*
 * data from the board that hasn't formed a complete event yet
 */
struct partial_event {
	struct	stynamic event;		/* the data */
	u_long	time;			/* event time */
	long	tempo;			/* tempo setting when event arrived */
	InputState	state;		/* what we are expecting next */
	u_char	rs;			/* the midi running state */
};

/*
 * keep a list of tempo changes
 */
struct tempo_change {
	u_long	time;		/* time tempo change occured in timing ticks */
	u_long	smf_time;	/* same but in SMF ticks */
	long	tempo;		/* the new tempo */
	struct	tempo_change *next;
};

/*
 * the internal representation of an event
 */
typedef enum {NORMAL, TEMPO, TIMESIG, SYSX, SMPTE, NOP} EventType;

struct event {
	u_long	time;		/* time until event in kernel clicks */
	u_long	smf_time;	/*
				 * absolute time of the event in smf ticks
				 * only used in writing
				 */
	long	tempo;		/*
				 * not used in play events, but contains
				 * the tempo setting current when the
				 * incoming event arrived.  Used for
				 * converting timing ticks to smf ticks
				 */
	EventType	type;
	struct	stynamic data;
};

/*
 * A event queue, used for both incoming and outgoing
 */
#define MIDI_Q_SIZE 150
#define MIDI_LOW_WATER 40

struct event_queue {
	int	count;
	struct	event events[MIDI_Q_SIZE];
	struct	event *end;
	struct	event *head;
	struct	event *tail;
};

/*
 * SMPTE stuff
 */
#define SMPTE_ORIGIN 3

/*
 * slop time
 * If we've fallen more than BACKLOG_TIME ticks behind, don't play
 * the events.  This is so we can "fastforward" through a song -
 * picking up important events like tempo changes, but not actually
 * playing any note on events.
 */
#define BACKLOG_TIME 5
/*
 * different MPU401 features
 */
#define SMPTE_EQUIP	(1 << 0)	/* equipped with MQ SMPTE */

