#!/usr/local/bin/g -file
# toworld.t 
# tests the g_toworld cmd
#
set doBuffering false

proc paint {w} {
    g_font futura.l; g_textsize .09 .09
    g_clipping false
    g_color white; g_clear 
}

proc motion_cmd {x y} {
  g_pushmatrix; 
    g_scale .5 .5
    g_toworld $x $y worldx worldy
    g_color white; g_clear; g_color black
    g_move -1 0; g_draw 1 0; g_move 0 -1; g_draw 0 1;
    g_centertext true
    g_move 0 -.25; g_drawstr [format "%g %g" $worldx $worldy]
    g_move $worldx $worldy; g_drawstr ".";
  g_popmatrix
}

wm minsize . 64 64 
wm maxsize . 500 800 
graphic .top -command {paint .top} \
    -font "helvetica" \
    -geometry 250x250 -bg white -doublebuffered $doBuffering \
    -relief raised -border 4
bind .top <Motion> {motion_cmd %x %y}
pack append . .top {top fill expand}
update
