/*
 * main.c --
 * 
 * A simple program to test the toolkit facilities.
 * 
 * Copyright 1990 Regents of the University of California. Permission to use,
 * copy, modify, and distribute this software and its documentation for any
 * purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies.  The University of California makes
 * no representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 */

#ifndef lint
static char     rcsid[] = "$Header: /user5/ouster/wish/RCS/main.c,v 1.52 91/04/24 14:31:20 ouster Exp $ SPRITE (Berkeley)";
#endif	/* not lint */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/file.h>
#include "tkInt.h"
#include <tcl.h>

#define TCLNEWS 0

/*
 * Declarations for library procedures:
 */

extern int      isatty();
int             tty;

extern int init_vogleCmds();
extern int init_mathCmds();
extern int init_stringCmds();
extern int init_builderCmds();
extern int init_sigHandlers();

Tk_Window       MainWindow;
Tcl_Interp     *interp;
Tcl_CmdBuf      buffer;

/*
 * Information for testing out command-line options:
 */

int             synchronize = 0;
int             dofork = 0;
char           *file = NULL;
char           *name = NULL;
char           *displayName = NULL;

Tk_ArgvInfo     argTable[] = {
	{"-fork", TK_ARGV_CONSTANT, (char *) 1, (char *) &dofork,
	"Run the program in the background"},
	{"-file", TK_ARGV_STRING, (char *) NULL, (char *) &file,
	"File from which to read commands (TK_ARGV_STRING)"},
	{"-display", TK_ARGV_STRING, (char *) NULL, (char *) &displayName,
	"Name to use for application (TK_ARGV_STRING)"},
	{"-name", TK_ARGV_STRING, (char *) NULL, (char *) &name,
	"Name to use for application (TK_ARGV_STRING)"},
	{"-sync", TK_ARGV_CONSTANT, (char *) 1, (char *) &synchronize,
	"Use synchronous mode for display server"},
	{(char *) NULL, TK_ARGV_END, (char *) NULL, (char *) NULL,
	(char *) NULL}
};

/* ARGSUSED */
void
StdinProc(clientData, mask)
	ClientData      clientData;	/* Not used. */
	int             mask;
{
	char            line[200];
	static int      gotPartial = 0;
	char           *cmd;
	int             result;

	if (mask & TK_READABLE) {
		if (fgets(line, 200, stdin) == NULL) {
			if (!gotPartial) {
				if (tty) {
					exit(0);
				} else {
					Tk_DeleteFileHandler(0);
				}
				return;
			} else {
				line[0] = 0;
			}
		}
		cmd = Tcl_AssembleCmd(buffer, line);
		if (cmd == NULL) {
			gotPartial = 1;
			return;
		}
		gotPartial = 0;
		result = Tcl_RecordAndEval(interp, cmd, 0);
		if (*interp->result != 0) {
			if ((result != TCL_OK) || (tty)) {
				printf("%s\n", interp->result);
			}
		}
		if (tty) {
			printf("wish: ");
			fflush(stdout);
		}
	}
}

/* ARGSUSED */
static void
StructureProc(clientData, eventPtr)
	ClientData      clientData;	/* Information about window. */
	XEvent         *eventPtr;	/* Information about event. */
{
	if (eventPtr->type == DestroyNotify) {
		MainWindow = NULL;
	}
};

static int 
local_vogle_init()
{
	voutput("/dev/null");
	vinit("postscript");	/* So we do not have to check that vogle is
				 * initialized at every turn */
	return 0;
}

int
main(argc, argv)
	int             argc;
	char          **argv;
{
	char           *args, *p;
	char            buf[20];
	int             result;
	Tk_3DBorder     border;

	local_vogle_init();

	interp = Tcl_CreateInterp();
	if (!interp) {
	    perror("cannot create interpeter");
	    exit(1);
	}

	if (Tk_ParseArgv(interp, (Tk_Window) NULL, &argc, argv, argTable, 0)
	    != TCL_OK) {
		fprintf(stderr, "%s\n", interp->result);
		exit(1);
	}
	if (dofork)
		background();
	if (name == NULL) {
		if (file != NULL) {
			p = file;
		} else {
			p = argv[0];
		}
		name = strrchr(p, '/');
		if (name != NULL) {
			name++;
		} else {
			name = p;
		}
	}
	/* update the DISPLAY env variable */
	if (displayName) {
	    char *d = "DISPLAY=";
	    char *envstr;
	    envstr = ckalloc(strlen(d) + strlen(displayName) + 1);
	    if (!envstr) {
		perror("ckalloc");
		exit(1);
	    } else {
		sprintf(envstr, "%s%s", d, displayName);
		putenv(envstr);
	    }
	}
	MainWindow = Tk_CreateMainWindow(interp, displayName, name);
	init_stringCmds(interp);
	init_mathCmds(interp);
	init_vogleCmds(interp);
	init_builderCmds(interp);
	init_sigHandlers(interp);
	if (MainWindow == NULL) {
		fprintf(stderr, "%s\n", interp->result);
		exit(1);
	}
	Tk_SetClass(MainWindow, "Tk");
	Tk_CreateEventHandler(MainWindow, StructureNotifyMask, StructureProc,
			      (ClientData) NULL);
	tty = isatty(0);

	args = Tcl_Merge(argc - 1, argv + 1);
	Tcl_SetVar(interp, "argv", args, TCL_GLOBAL_ONLY);
	free(args);
	sprintf(buf, "%d", argc - 1);
	Tcl_SetVar(interp, "argc", buf, TCL_GLOBAL_ONLY);

	if (synchronize) {
		XSynchronize(Tk_Display(MainWindow), True);
	}
	Tk_GeometryRequest(MainWindow, 200, 200);
	border = Tk_Get3DBorder(interp, MainWindow, None, "bisque");
	if (border == NULL) {
		Tcl_Return(interp, (char *) NULL, TCL_STATIC);
		Tk_SetWindowBackground(MainWindow, 
		    WhitePixelOfScreen(Tk_Screen(MainWindow)));
	} else {
		Tk_SetBackgroundFromBorder(MainWindow, border);
	}
	XSetForeground(Tk_Display(MainWindow), 
		DefaultGCOfScreen(Tk_Screen(MainWindow)),
		BlackPixelOfScreen(Tk_Screen(MainWindow)));
	if (file != NULL) {
		result = Tcl_VarEval(interp, "source ", file, (char *) NULL);
		if (result != TCL_OK) {
			fprintf(stderr, "%s\n", 
			    Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY));
			exit(1);
		}
		tty = 0;
	} else {
		tty = isatty(0);
		if (tty && !dofork) {
			Tk_CreateFileHandler(0, 
			    TK_READABLE | TK_EXCEPTION, StdinProc,
			    (ClientData) 0);
			printf("window is %s\n", Tk_Name(MainWindow));
			printf("wish: ");
		}
	}
	fflush(stdout);
	buffer = Tcl_CreateCmdBuf();
	(void) Tcl_Eval(interp, "update", 0, (char **) NULL);

	/*
	 * The window could have been deleted as part of the startup script.
	 * If so, don't try to map it.
	 */

	if (MainWindow != NULL) {
		Tk_MapWindow(MainWindow);
	}
	Tk_MainLoop();
	exit(0);
}
