
defwidget Text

defmethod Text new {name args} {

  args	{textfont text} {relief sunken} {width 40} {height 3} {wrap char} \
	layout {state disabled} text yscroll action max filter

  text $name \
	-font [Font slot $textfont] \
	-relief $relief -setgrid false \
	-borderwidth 2 -width $width -height $height \
	-padx 5 -pady 5 -wrap $wrap \
	-background [Color slot bg] \
	-foreground [Color slot fg] \
	-selectforeground [Color slot fg,active] \
	-selectbackground [Color slot bg,active] \
	-yscrollcommand $yscroll

  $name insert 0.0 $text
  $name mark set insert 0.0
  $name mark set anchor insert
  $name configure -state $state

  Text instantiate $name $layout [list \
	[list max $max] \
	[list action [$self buildAction $action $name]] \
	[list filter $filter] \
	]
  $name bindings

  return $name
}

defmethod Text entry {} {

  return $self
}

defmethod Text get {} {
  $self! get 0.0 end
}

defmethod Text set {text} {

  set max [$self slot max]
  if { $max != {} && [string length $text] > $max } {
    set text [string range $text 0 [expr $max-1]]
  }

  set state [lindex [$self! configure -state] 4]
  $self! configure -state normal
  $self! delete 0.0 end
  $self! insert 0.0 $text
  $self! mark set insert 0.0
  $self! mark set anchor insert
  $self! configure -state $state

  return
}

defmethod Text keypress {code} {

  if { $code == "" } {
    return
  }

  set max [$self slot max]
  set filter [$self slot filter]

  if { $filter != {} } {
    set code [eval [concat $filter [list $code]]]
    if { $code == "" } {
      return
    }
  }

  if { $code != "" } {
    if { $max == "" || [string length [$self! get 0.0 end]] < $max } {
      $self! insert insert $code
      $self! yview -pickplace insert
    }
  }
}

defmethod Text see_caret {} {
  $self! yview -pickplace insert
}

defmethod Text backspace {} {
  $self! delete insert-1c insert
  $self! yview -pickplace insert
}

defmethod Text delete {} {
  catch {$self! delete sel.first sel.last}
}

defmethod Text erase {} {
  catch	{$self! delete 0.0 end}
}

defmethod Text action {} {

  set action [$self slot action]
  if { $action == {} } then {
    $self! insert insert "\n"
    $self! yview -pickplace insert
  } {
    uplevel #0 [concat $action [list [$self! get 0.0 end]]]
  }
}

defmethod Text position {where} {
  $self! mark set insert $where
  $self! yview -pickplace insert
}

defmethod Text insert {what} {
  $self! insert insert $what
  $self! yview -pickplace insert
}

#---------------------------------------------------------------------------
#
#	Define bindings
#

defmethod Text bindings {} {

  bind $self <Any-KeyPress> [list %W keypress %A]

  bind $self <BackSpace> [list %W backspace]
  bind $self <Delete> [list %W backspace]
  bind $self <Control-h> [list %W backspace]
  bind $self <Control-d> [list %W delete]
  bind $self <Control-u> [list %W erase]

  bind $self <Control-a> [list %W position 0.0]
  bind $self <Control-e> [list %W position end]

  bind $self <Control-b> [list %W position insert-1c]
  bind $self <Control-f> [list %W position insert+1c]
  bind $self <Control-p> [list %W position insert-1l]
  bind $self <Control-n> [list %W position insert+1l]

  bind $self <Key-Return> [list %W action]

  bind $self <1> {
    set tk_priv(selectMode) char
    %W! mark set insert @%x,%y
    %W! mark set anchor insert
    if {[lindex [%W! config -state] 4] == "normal"} {
      focus %W
    }
  }

  bind $self <Double-1> {
    set tk_priv(selectMode) word
    %W! mark set insert "@%x,%y wordstart"
    %W _select insert
  }
  bind $self <Triple-1> {
    set tk_priv(selectMode) line
    %W! mark set insert "@%x,%y linestart"
    %W _select insert
  }

  bind $self <B1-Motion> {
    %W _select @%x,%y
  }

  bind $self <Shift-1> {
    %W _reanchor @%x,%y
    %W _select @%x,%y
  }

  bind $self <Shift-B1-Motion> {
    %W _select @%x,%y
  }

  bind $self <2> {
    %W! scan mark %y
  }

  bind $self <B2-Motion> {
    %W! scan dragto %y
  }

  return $self
}

defmethod Text _select {index} {
  global tk_priv

  case $tk_priv(selectMode) {
    char {
      if [$self! compare $index < anchor] {
	set first $index
	set last anchor
      } else {
	set first anchor
	set last [$self! index $index+1c]
      }
    }
    word {
      if [$self! compare $index < anchor] {
        set first [$self! index "$index wordstart"]
        set last [$self! index "anchor wordend"]
      } else {
        set first [$self! index "anchor wordstart"]
        set last [$self! index "$index wordend"]
      }
    }
    line {
      if [$self! compare $index < anchor] {
        set first [$self! index "$index linestart"]
        set last [$self! index "anchor lineend + 1c"]
      } else {
        set first [$self! index "anchor linestart"]
        set last [$self! index "$index lineend + 1c"]
      }
    }
  }
  $self! tag remove sel 0.0 $first
  $self! tag add sel $first $last
  $self! tag remove sel $last end
}

defmethod Text _reanchor {index} {
  global tk_priv

  if {[$self! tag ranges sel] == ""} {
    set tk_priv(selectMode) char
    $self! mark set anchor $index
    return
  }
  if [$self _closer $index sel.first sel.last] {
    if {$tk_priv(selectMode) == "char"} {
      $self! mark set anchor sel.last
    } else {
      $self! mark set anchor sel.last-1c
    }
  } else {
    $self! mark set anchor sel.first
  }
}

defmethod Text _closer {a b c} {

  set a [$self! index $a]
  set b [$self! index $b]
  set c [$self! index $c]
  if [$self! compare $a <= $b] {
    return 1
  }
  if [$self! compare $a >= $c] {
    return 0
  }
  scan $a "%d.%d" lineA chA
  scan $b "%d.%d" lineB chB
  scan $c "%d.%d" lineC chC
  if {$chC == 0} {
    incr lineC -1
    set chC [string length [$self! get $lineC.0 $lineC.end]]
  }
  if {$lineB != $lineC} {
    return [expr {($lineA-$lineB) < ($lineC-$lineA)}]
  }
  return [expr {($chA-$chB) < ($chC-$chA)}]
}
