#######################################################################
#
#
# Collection of procedures to create an mpeg player 'mega widgit'
# type thing ?
#
# Copyright Ian Campbell university of newcastle upon tyne
#
#######################################################################
proc player {path options} {
#
# Outer frame to hold the whole thing
#
frame $path.frame
#
#Frames for button area and menu
#
frame $path.frame.buttons
frame $path.frame.menus -relief raised
#
#Declare a few globals to handle multiple calls
#
global PLAYER_LIBRARY
global MPEGstopped
global MPEGLoop
set MPEGstopped($path) 1
set MPEGLoop($path) 0

#
#create the movie widget
#
eval movie $path.frame.movie  $options
#
# create a menu for dither options
#
menubutton $path.frame.menus.menu -text "Options" \
	-menu $path.frame.menus.menu.m
menu $path.frame.menus.menu.m
$path.frame.menus.menu.m add cascade -label "Dither" \
	-menu $path.frame.menus.menu.m.dither

menu $path.frame.menus.menu.m.dither
$path.frame.menus.menu.m.dither add command -label "ordered"\
	-command "$path.frame.movie configure -dither ordered"
$path.frame.menus.menu.m.dither add command -label "ordered2"\
	-command "$path.frame.movie configure -dither ordered2"
$path.frame.menus.menu.m.dither add command -label "mbordered"\
	-command "$path.frame.movie configure -dither mbordered"
$path.frame.menus.menu.m.dither add command -label "fs4"\
	-command "$path.frame.movie configure -dither fs4"
$path.frame.menus.menu.m.dither add command -label "fs2"\
	-command "$path.frame.movie configure -dither fs2"
$path.frame.menus.menu.m.dither add command -label "fs2fast"\
	-command "$path.frame.movie configure -dither fs2fast"
$path.frame.menus.menu.m.dither add command -label "hybrid"\
	-command "$path.frame.movie configure -dither hybrid"
$path.frame.menus.menu.m.dither add command -label "hybrid2"\
	-command "$path.frame.movie configure -dither hybrid2"
$path.frame.menus.menu.m.dither add command -label "2x2"\
	-command "$path.frame.movie configure -dither 2x2"
$path.frame.menus.menu.m.dither add command -label "gray"\
	-command "$path.frame.movie configure -dither gray"
$path.frame.menus.menu.m.dither add command -label "color"\
	-command "$path.frame.movie configure -dither color"
$path.frame.menus.menu.m.dither add command -label "none"\
	-command "$path.frame.movie configure -dither none"
$path.frame.menus.menu.m.dither add command -label "mono"\
	-command "$path.frame.movie configure -dither mono"
$path.frame.menus.menu.m.dither add command -label "threshold"\
	-command "$path.frame.movie configure -dither threshold"

$path.frame.menus.menu.m add command -label "Exit"\
        -command "playerExit $path"  

#
# create buttons
#
button $path.frame.buttons.play -bitmap "@$PLAYER_LIBRARY/play.xbm" -command \
			"if {$MPEGstopped($path) == 1} \
			{set MPEGstopped($path) 0							
			playerPlay $path}" 
			
button $path.frame.buttons.stop -bitmap "@$PLAYER_LIBRARY/stop.xbm" \
				-command "set MPEGstopped($path) 1"
button $path.frame.buttons.rewind -bitmap "@$PLAYER_LIBRARY/rewind.xbm"\
			        -command "$path.frame.movie rewind"
button $path.frame.buttons.loop -bitmap "@$PLAYER_LIBRARY/loop.xbm" \
				-command "playerLoop $path"
button $path.frame.buttons.step -bitmap "@$PLAYER_LIBRARY/step.xbm" \
				-command "playerStep $path"
			
#
# pack everything up
#

pack append $path.frame.buttons $path.frame.buttons.rewind {left expand fillx}\
				$path.frame.buttons.stop {left expand fillx}\
				$path.frame.buttons.play {left expand fillx}\
				$path.frame.buttons.step {left expand fillx}\
				$path.frame.buttons.loop {left expand fillx}

pack append $path.frame.menus $path.frame.menus.menu {left fillx}

pack append $path.frame $path.frame.menus {top expand fillx} \
			$path.frame.movie {top expand fill } \
			$path.frame.buttons {top expand fillx}


pack append $path $path.frame {top expand fill}

}

#
# places a call to play recursive ish
#

proc playerPlay path {
    global MPEGstopped

    if $MPEGstopped($path) return
	after 30 "playerPlay $path"
    
    $path.frame.movie play 1   	
}
#
# sets and configures loop option,
# I'm sure there is a neater way of doing this
#
proc playerLoop path {
global MPEGLoop 
if $MPEGLoop($path) {
set MPEGLoop($path) 0
$path.frame.movie configure -loop false
} else {
set MPEGLoop($path) 1
$path.frame.movie configure -loop true
} 
}
#
# trys to clean up
# can't clean MPEGstopped($path)
# cos there may be some calls to playerPlay hanging
# around which needs it
# could do with something to flush the calls set off by after ?
# I think this is possible with tk4.?

proc playerExit path {
global MPEGLoop
global MPEGstopped
set MPEGstopped($path) 1
unset MPEGLoop($path)
destroy $path
}

#
# Stops if playing and go's forward one frame
#

proc playerStep path {
global MPEGstopped

set MPEGstopped($path) 1
$path.frame.movie play 1
}
