/* ------------------------------------------------------------------------
@NAME       : mpeg.h
@INPUT      : 
@OUTPUT     : 
@RETURNS    : 
@DESCRIPTION: Types and function prototypes needed for applications to
              use the Berkely MPEG decoding engine via the tkMovie front
              end.
@METHOD     : 
@GLOBALS    : Types defined:
                 ImageDesc  - structure giving height, width, etc.
                 DitherEnum - the different dither types supported by
                              the decoding engine
@CALLS      : vidstream.h via an include
@CREATED    : Ian Campbell 1/3/95
@MODIFIED   : original by Greg Ward, 94/9/16 but I've made so many changes
	      considering video.h and vidstream.h that I'm claiming created
	      here.
---------------------------------------------------------------------------- */

#ifndef __MPEG_H
#define __MPEG_H

#include <stdio.h>
/* Xinclude files added */
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "vidstream.h"

/* An attempt at a portable and integrable boolean type... */

#if (!defined(TRUE) || !defined(FALSE))
# define TRUE 1
# define FALSE 0
#endif

#if (!defined (BOOLEAN_TYPE_EXISTS))
typedef unsigned int Boolean;
#endif

typedef enum 
{
   HYBRID_DITHER,
   HYBRID2_DITHER,
   FS4_DITHER,
   FS2_DITHER,
   FS2FAST_DITHER,
   Twox2_DITHER,
   GRAY_DITHER,
   FULL_COLOR_DITHER,
   NO_DITHER,
   ORDERED_DITHER,
   MONO_DITHER,
   MONO_THRESHOLD,
   ORDERED2_DITHER,
   MBORDERED_DITHER
} DitherEnum;


typedef struct
{
   int	Height,			/* in pixels */
        Width,
        Depth,			/* image depth (bits) */
        PixelSize,              /* bits actually stored per pixel */
        Size,			/* bytes for whole image */
        BitmapPad;              /* "quantum" of a scanline -- each scanline */
				/* starts on an even interval of this */
                                /* many bits */
	VidStream *theStream;   /* pointer to the mpeg stream details */
	FILE *input;		/* pointer to input file */
	Boolean EOF_flag ;	/* end of file flag */
	int totNumFrames ;	/* holds current frame number */
	DitherEnum ditherType ; /* holds the dither type used for instance */

} ImageDesc;



typedef enum
{
   MPEG_DITHER,
   MPEG_QUIET,
   MPEG_LUM_RANGE,
   MPEG_CR_RANGE,
   MPEG_CB_RANGE
} MPEGOptionEnum;

/* Kludge so we can compile under ANSI or K&R */

#undef PROTO
#if __STDC__
#define PROTO(formal_parameters) formal_parameters
#else
#define const
#define PROTO(formal_parameters) ()
#endif

/* Function prototypes (all are defined in wrapper.c) */

extern Boolean OpenMPEG PROTO((Display *display, Window window, FILE *MPEGfile, ImageDesc *ImgInfo));
void   CloseMPEG PROTO(( ImageDesc *ImgInfo));
void   RewindMPEG PROTO((ImageDesc *Image));
void   SetMPEGDither PROTO((Display *display, Window window, ImageDesc *Image, DitherEnum value));
extern Boolean GetMPEGFrame PROTO(( ImageDesc *ImgInfo, char *Frame));

#endif   /* __MPEG_H */
