 #########################################################################
 #                                                                       #
 # Copyright (C) 1993 by General Electric company.  All rights reserved. #
 #                                                                       #
 # Permission to use, copy, modify, and distribute this                  #
 # software and its documentation for any purpose and without            #
 # fee is hereby granted, provided that the above copyright              #
 # notice appear in all copies and that both that copyright              #
 # notice and this permission notice appear in supporting                #
 # documentation, and that the name of General Electric not be used in   #
 # advertising or publicity pertaining to distribution of the            #
 # software without specific, written prior permission.                  #
 #                                                                       #
 # General Electric makes no representations about the suitability of    #
 # this software for any purpose.  It is provided ``as is''              #
 # without express or implied warranty.                                  #
 #                                                                       #
 # This work was supported in part by the DARPA Initiative in Concurrent #
 # Engineering (DICE) through DARPA Contracts MDA972-88-C-0047 and       #
 # MDA972-92-C-0027.                                                     #
 #                                                                       #
 # This work was supported in part by the Tri-Services Microwave and     #
 # Millimeter-Wave Advanced Computational Environment (MMACE) program    #
 # under Naval Research Laboratory contract N00014-92-C-2044.            #
 #                                                                       #
 #########################################################################


# File: modal.tcl

# Description:
#	Procedures for operating modal dialog boxes.

 # $Id: modal.tcl,v 1.13 1994/10/27 18:29:42 kennykb Exp $
 # $Source: /tmp_mnt/projects/cliff/iam/all/src/tkauxlib/RCS/modal.tcl,v $
 # $Log: modal.tcl,v $
 # Revision 1.13  1994/10/27  18:29:42  kennykb
 # Release 2.0 -- 10-27-94.  To be uploaded to archive sites.
 #
 # Revision 1.12  1993/11/01  18:20:46  kennykb
 # Beta release to be announced on comp.lang.tcl
 #
 # Revision 1.11  1993/10/27  15:52:49  kennykb
 # Package for alpha release to the Net, and for MMACE 931101 release.
 #
 # Revision 1.10  1993/10/20  19:10:47  kennykb
 # Alpha release #1 was thawed for bug fixes in tk 3.3.  Now frozen again at this
 # point.
 #
 # Revision 1.9  1993/10/20  19:02:14  kennykb
 # Changed so that modalDialog doesn't wait for window visibility.  NOTE:
 # It won't work if the window isn't visible, but since the usual usage is
 # `modalDialog transient' and transient must wait for the visibility,
 # this should be OK.
 #
 # Revision 1.8  1993/10/14  18:15:42  kennykb
 # Cleaned up alignment of log messages, to avoid problems extracting
 # structured commentary.
 #
 # Revision 1.7  1993/10/14  18:06:59  kennykb
 # Added GE legal notice to head of file in preparation for release.
 #
 # Revision 1.6  1993/10/14  14:02:02  kennykb
 # Alpha release #1 frozen at this point.
 #
 # Revision 1.5  1993/10/14  13:41:14  kennykb
 # Changed to use widget_checkAndDestroy to avoid repeated destruction of the
 # same widget.
 #
 # Revision 1.4  1993/07/21  19:44:36  kennykb
 # Finished cleaning up structured commentary.
 #
 # Revision 1.3  1993/07/20  19:17:12  kennykb
 # Improved structured comments.
 # Changed modules through `g' in the alphabet to follow `:' and `_' naming
 # conventions.
 #
 # Revision 1.2  1993/07/19  18:49:24  kennykb
 # Renamed all button_ commands to either button. or button:, in
 # conformance with new module naming conventions.
 #
 # Revision 1.1  1993/06/03  15:30:35  kennykb
 # Initial revision
 #

# Procedure:	modalDialog
#
# Synopsis:
#	Make a widget operate as a modal dialog.
#
# Usage:
#c	modalDialog command args...
#
# Parameters:
#	A command that creates a widget.
#
# Return value:
#	The name of the widget.
#
# Description:
#	modalDialog modifies the behavior of another widget creation command
#	so that it operates as a modal dialog box.  The focus is saved and
#	set to the widget's default focus; the widget is grabbed; the
#	widget's default button is set.
#
# See also:
#	modalDialog.end is used to release a modal dialog.
#
# Example:
#
#c	proc getanswer {} {

#c		global getanswer_priv

#c		modalDialog transient choicebox .query \

#c			-text "Are you sure?" \

#c			-buttons {Yes No} \

#c			-icon think \

#c			-textvariable getanswer_priv

#c		widget_waitVariable getanswer_priv

#c		set result $getanswer_priv

#c		modalDialog.end .query

#c		unset getanswer_priv

#c		return $result

#c	}

proc modalDialog {args} {
	global modal_priv
	set focus [focus_findCurrent]
	focus none
	set w [uplevel 1 $args]
	set modal_priv(focus,$w) $focus
	set modal_priv(grab,$w) [grab current $w]
	grab set $w
	
	button_setDefault $w

	focus_goToFirst $w
	return $w
}

# Procedure:	modalDialog.end
#
# Synopsis:
#	Release a modal dialog.
#
# Usage:
#c	modalDialog.end pathName
#
# Parameters:
#c	pathName
#		Name of a widget that has been made modal via modalDialog
#
# Return value:
#	None.
#
# Description:
#	modalDialog.end ends a modal dialog.  It releases a grab on the
#	specified widget, directs the focus to where it was before the
#	modal dialog began, and destroys the widget.
#
# Bugs:
#	Widget destruction should be orthogonal to the modal dialog. (?)

proc modalDialog.end w {
	global modal_priv
	grab release $w
	if {$modal_priv(grab,$w) != ""} {
		grab set $modal_priv(grab,$w)
	}
	unset modal_priv(grab,$w)
	after 1 "
		catch \"focus_goTo $modal_priv(focus,$w) -force\" 
		after 1 widget_checkAndDestroy $w
	"
	unset modal_priv(focus,$w)
}
