'\"
'\" Copyright (c) 1993, 1994 Eric Schenk.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE ERIC SCHENK BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF ERIC SCHENK
'\" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" ERIC SCHENK SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND ERIC SCHENK HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\"
.de EX          \"Begin example
.ne 5
.if n .sp 1
.if t .sp .5
.nf
.in +.5i
..
.de EE
.fi
.in -.5i
.if n .sp 1
.if t .sp .5
..
.ta .3i .6i .9i 1.2i 1.5i 1.8i
.TH STKWM 1 "12 June 1994"
.SH NAME
stkwm  \- Sample Tkwm based window manager
.SH SYNOPSIS
.B stkwm
.I ?options?
.SH DESCRIPTION
.LP
.I Stkwm
is a window manager for the X Window System.
It is written using the tkwm window manager shell,
which is in turn based on the Tcl command language and the Tk toolkit.
.I Stkwm
provides titlebars, icon management, rooms,
and user configurable key and button bindings. As with
other Tcl based tools the window manager can be extended
using the Tcl scripting language.
.I Stkwm
is patterned loosly after Mwm, but it should not be mistaken for an
Mwm emulation.
.LP
.I Stkwm
should usually be started by the user's session manager
or startup script.
When used from \fIxdm\fR(1) or \fIxinit\fR(1) without a session manager,
it is common practice to execute the window manager in the foreground
as the last client. This allows the users session to be terminated
by quitting the window manager.
.SH OPTIONS
.LP
.I Stkwm
accepts the following command line options:
.IP "\fB\-display \fIdisplay\fR" 15
Display (and screen) to manage.
.SH "DEFAULT APPEARANCE AND OPERATION"
The window manager provides the user with controls to manipulate
the size and position of application windows.
This is done by decorating application windows with control and
information widgets, as well as widgets that serve only asthetic
purposes.
The windows owned by applications are referred to as the
.I clients
of the window manager.
.SS "Client Decorations"
.LP
By default, client windows are surrounded by a ``frame''
with a titlebar above the window and a beveled border
surrounding both the client window and the titlebar.
The titlebar contains the name of the client and several
buttons that control window manager functions.
.LP
The titlebar contains 3 control buttons and
the application title.
From left to right these are the menu button,
the application title, the iconify button,
and the maximize button.
Pressing Button1 over the menu button
calls up the client menu, which is detailed below.
Pressing and releasing Button1 over the iconify button
will iconify the window.
Pressing and releasing mouse Button1 over the maximize button
will expand the window to its largest possible size.
.LP
Some client windows are marked by the application that
owns them as ``transient''. Transient windows are usually
used for dialogs and other interactions that are only temporary.
By default, transient windows are decorated only with a beveled
border.
.SS "Icon Decorations"
.LP
By default, iconified application windows are represented by a small
beveled window containing a 64x64 pixel graphical icon above a text field
displaying the icon title of the application window.
Pressing Button1 over the icon window will deiconify the application.
.SS "Keyboard Focus"
.LP
The client currently under the mouse pointer is always given the keyboard
focus, i.e. any keystrokes that are type are sent to the client under
the mouse.
To distinguish the client with the keyboard focus the color
of a clients frame changes when it has the focus.
.SS "Moving Windows"
.LP
Pressing Button2 over any part of the border or titlebar attached
to a window starts a move operation. The move operation continues
until Button2 is release. While Button2 is depressed the window will
move tracking the position of the mouse pointer.
A move operation can also be started from the Client Menu, in which
case the operation terminates when Button1 is pressed and then released.
The user can selectively constrain some are all windows so that they
cannot be moved off the screen. By default the user can move windows
past the edges of the screen.
.SS "Resizing Windows"
.LP
Pressing Button3 over any part of the border or titlebar attached
to a window starts a resize operation. The resize operation continues
until Button2 is release. While Button2 is depressed the window size
will change in response to movements of the mouse pointer.
A resize operation can also be started from the Client Menu, in which
case the operation terminates when Button1 is pressed and then released.
.SS "New Windows"
.LP
When new windows are created,
.I stkwm
will place them at the size and position specified by the user
either through command line arguments or resource files.
If no position is specified then
.I stkwm
will display an outline of the new window with its default size.
This outline can then be dragged about by the mouse.
When the outline is in the location the user wishes the window to
appear, clicking Button1 will cause the window to be placed.
.SS "Window Menu"
.LP
By default, holding down Button1 anywhere over the root window
will bring up the
.I window
menu.
If Button1 is release when an entry of the menu is highlighted,
then that entry will be executed.
By default the window menu contains two entries. The first
causes a 80x24 xterm application to be started.
The second causes a 80x40 xterm application to be started.
This menu is usually customized by the user to start up the
tools they most commonly use.
.SS "Root Menu"
.LP
By default, holding down Button3 anywhere over the root window
will bring up the
.I root
menu.
If Button1 is release when an entry of the menu is highlighted,
then that entry will be executed.
.SS "Client Menu"
.LP
Pressing Button1 over the menu button in a titlebar brings
up the
.I client
menu.
If Button1 is release when an entry of the menu is highlighted,
then that entry will be executed.
This menu allows access to various client specific window manager
operations.
.SH "X RESOURCES"
.LP
Many aspects of \fIstkwm\fR's behavior are controlled by X Resources.
User customizations to the default X Resources
are read from the files ~/.tkwm_mono.appdefs and ~/.tkwm_color.appdefs,
depending on whether the screen being managed is monochrome or color.
The preferences editor available from the root and 
the client menus can be used to edit the X resources
contained in these files. Alternatively, users may wish to edit
these files directly with a text editor.
.LP
.SS Menus
.LP
Global menu resources are of the form
.LP
\fBTk.Menu\fR*\fIresource_name\fR: value
.LP
Menu specific resources are of the form
.LP
\fBTk\fR.\fImenu_name.resource_name\fR: value
.LP
Only global resources can be edited by the preferences editor.
The following resources are available for menus:
.IP \fBfont\fR: 24
The font used for the menu.
.IP \fBcursor\fR: 24
The cursor used when the mouse pointer is over the menu.
.IP \fBborderWidth\fR: 24
The width of the raised border surrounding the menu.
.IP \fBactiveBorderWidth\fR: 24
The width of the raised border surrounding the current menu selection.
.IP \fBbackground\fR: 24
The background color of the menu.
.IP \fBforeground\fR: 24
The foreground color of the menu.
.IP \fBdisabledForeground\fR: 24
The foreground color of a disabled menu item. The title is usually
the only disabled menu item.
.IP \fBactiveBackground\fR: 24
The background color of the currently selected menu item.
.IP \fBactiveForeground\fR: 24
The foreground color of the currently selected menu item.
.SS Application Window Managment
.LP
There are several resources that control the way client windows
are managed. 
Global client resources are of the form
.LP
\fBTk.Client\fR*\fIresource_name\fR: value
.LP
Client specific resources are of the form
.LP
\fBTk.Client\fR.\fIclient_name.resource_name\fR: value
.LP
or
.LP
\fBTk.Client\fR.\fIclient_class.resource_name\fR: value
.LP
All three types of resources can be edited by the preferences editor.
The following resources are available to customize client
window managment:
.IP \fBopaqueMove\fR: 20
If this resource is set to 1 then move operations will drag
the entire window in response to the mouse.
Otherwise window move operations will drag an outline of the window.
Opaque moves are very CPU intensive.
.IP \fBopaqueResize\fR: 20
If this resource is set to 1 then resize operations will resize
the entire window in response to the mouse.
Otherwise window resize operations will resize an outline of the window.
Opaque resizes are even more CPU intensive than opaque moves.
.IP \fBconstrained\fR: 20
If this resource is set to 1 then move operations will not be
allowed to move the edges of the window off the edge of the screen.
Otherwise the user may move windows past the edge of the screen if
they desire to.
.IP \fBuse_WM_STATE\fR: 20
If this resource is set to 1 then when
.I stkwm
is restarted it will attempt to recover the state (iconified,
withdrawn or normal) of the window from the WM_STATE resource.
Otherwise when 
.I stkwm
is restarted it will choose the state of the window based upon
its window hints for startup.
.IP \fBmanager\fR: 20
This resource allows the user to specify which geometry
manager should manage the client window. See the section
on geometry managers below for a description of geometry managers.
.SS Icon Management
.LP
There are several resources that control the way icon windows
are managed. 
Global icon resources are of the form
.LP
\fBTk.Client\fR*\fBIcon\fR.\fIresource_name\fR: value
.LP
Client specific icon resources are of the form
.LP
\fBTk.Client\fR.\fIclient_name\fR.\fBIcon\fR.\fIresource_name\fR: value
.LP
or
.LP
\fBTk.Client\fR.\fIclient_class\fR.\fBIcon\fR.\fIresource_name\fR: value
.LP
All three types of resources can be edited by the preferences editor.
The following resources are available to customize icon
window managment:
.IP \fBopaqueMove\fR: 20
If this resource is set to 1 then move operations will drag
the entire icon window in response to the mouse.
Otherwise window move operations will drag an outline of the icon window.
.IP \fBopaqueResize\fR: 20
If this resource is set to 1 then resize operations will resize
the entire icon window in response to the mouse.
Otherwise icon window resize operations will resize an outline of the icon
window.
Note that normally icons cannot be resized. However, if the user
chooses to allow icon resizing this resource will be applied.
.IP \fBconstrained\fR: 20
If this resource is set to 1 then move operations will not be
allowed to move the edges of the icon window off the edge of the screen.
Otherwise the user may move icon windows past the edge of the screen if
they desire to.
.IP \fBmanager\fR: 20
This resource allows the user to specify which geometry
manager should manage the client window. See the section
on geometry managers below for a description of geometry managers.
.IP \fBwidth\fR: 20
This resource specifies the width of the region used to display the
bitmap associated with an icon.
.IP \fBheight\fR: 20
This resource specifies the height of the region used to display the
bitmap associated with an icon.
.IP \fBbitmap\fR: 20
This resource specifies the pathname of an XBM file that contains
a bitmap to be used for the icon.
WARNING: If the global bitmap resource is set (as opposed to a client
specific resource), then the bitmaps provided internally by clients
will be overridden by the global resource. It is very unlikely that
you will want to set the global bitmap resource.
.SS Application Window Decorations
.LP
There are several resources that control the appearence of the decorations
on client windows.
Global client decoration resources are of the form
.LP
\fBTk.Client\fR*\fBTkwmClientFrame\fR.\fIresource_name\fR: value
.LP
Client specific resources are of the form
.LP
\fBTk.Client\fR.\fIclient_name\fR.\fBTkwmClientFrame\fR.\fIresource_name\fR: value
.LP
or
.LP
\fBTk.Client\fR.\fIclient_class\fR.\fBTkwmClientFrame\fR.\fIresource_name\fR: value
.LP
All three types of resources can be edited by the preferences editor.
The following resources are available to customize client
decorations:
.IP \fBtitlebar\fR: 20
If this resource is set to 1 the client will have a titlebar,
otherwise no titlebar will be displayed.
.IP \fBborderWidth\fR: 20
The width of the border surrounding the client window and titlebar.
.IP \fBleftButtons\fR: 20
A list of the buttons that appear on the left side of the title
field in the titlebar. The buttons available by default are:
\fBmenu\fR, \fBzoom\fR, and \fBiconify\fR.
By default, the leftButton resource is set to: "menu".
The buttons given in the list will appear from the left to
the right.
.IP \fBrightButtons\fR: 20
A list of the buttons that appear on the right side of the title
field in the titlebar. The buttons available by default are:
\fBmenu\fR, \fBzoom\fR, and \fBiconify\fR.
By default the rightButton resource is set to: "zoom iconify".
The buttons given in the list will appear from the right to the left.
.IP \fBfont\fR: 20
The font that the title in the titlebar should be displayed in.
.IP \fBcursor\fR: 20
The cursor that should be used when the mouse pointer is over
the frame of the client.
.IP \fBbackground\fR: 20
The background color of the frame when the client does not have the keyboard focus.
.IP \fBforeground\fR: 20
The foreground color of the frame when the client does not have the keyboard focus.
.IP \fBactiveBackground\fR: 20
The background color of the frame when the client has the keyboard focus.
.IP \fBactiveForeground\fR: 20
The foreground color of the frame when the client has the keyboard focus.
.SS Transient Window Decorations
.LP
The resources that control the appearance of decorations on regular client
windows can also control the appearance of resources on transient client
windows.
Global transient client decoration resources are of the form
.LP
\fBTk.Client\fR*\fBtransient-decoration\fR.\fIresource_name\fR: value
.LP
Client specific resources are of the form
.LP
\fBTk.Client\fR.\fIclient_name\fR.\fBtransient-decoration\fR.\fIresource_name\fR: value
.LP
or
.LP
\fBTk.Client\fR.\fIclient_class\fR.\fBtransient-decoration\fR.\fIresource_name\fR: value
.LP
All three types of resources can be edited by the preferences editor.
.SS "Icon Decorations"
.LP
There are several resources that control the appearence of the decorations
on client windows.
Global icon decoration resources are of the form
.LP
\fBTk.Client\fR*\fBIcon.TkwmClientFrame\fR.\fIresource_name\fR: value
.LP
Client specific resources are of the form
.LP
\fBTk.Client\fR.\fIclient_name\fR.\fBIcon.TkwmClientFrame\fR.\fIresource_name\fR: value
.LP
or
.LP
\fBTk.Client\fR.\fIclient_class\fR.\fBIcon.TkwmClientFrame\fR.\fIresource_name\fR: value
.LP
All three types of resources can be edited by the preferences editor.
The following resources are available to customize icon
decorations:
.IP \fBtitlebar\fR: 20
If this resource is set to 1 the icon will have a titlebar
below the bitmap image, otherwise no titlebar will be displayed.
.IP \fBfont\fR: 20
The font that the title in the titlebar should be displayed in.
.IP \fBcursor\fR: 20
The cursor that should be used when the mouse pointer is over
the icon.
.IP \fBbackground\fR: 20
The background color of the frame when the icon does not have the keyboard focus.
.IP \fBforeground\fR: 20
The foreground color of the frame when the icon does not have the keyboard focus.
.IP \fBactiveBackground\fR: 20
The background color of the frame when the icon has the keyboard focus.
.IP \fBactiveForeground\fR: 20
The foreground color of the frame when the icon has the keyboard focus.
.LP
.SH "TCL BASED CUSTOMIZATION"
.LP
Since \fIstkwm\fR is written entirely in TCL users can customize its
behavior by writing their own TCL routines to replace and augment
the default routines used in \fIstkwm\fR.
To effect these customizations \fIstkwm\fR loads the file ~/.stkwmrc
at startup and whenever the window manager is restarted.
Thus the user can place any customizations they want into their
~/.stkwmrc file.
.LP
It is beyond the scope of this document to describe how to program in TCL,
or to describe the implementation of
.I stkwm
in complete detail.
However, there are several straightforward ways in which
.I stkwm
can
be modified and these are described here. Users wishing to make
extensive modifications will want to read the
.I tkwm(1)
manual page as well as the source for
.I stkwm
itself.
It will be helpful if the user is at least a little familiar
with Tcl and Tk programming.
.SS "Menus"
.PP
Most users will want to customize at least the window menu.
The default menus are defined in the file \fB/usr/local/lib/tkwm/custom.tcl\fR.
There are three menus defined by default:
\fB.windows_menu\fR, \fB.root_menu\fR, and \fB.client_menu\fR.
The basic format of a menu declaration is:
.EX 0
tkwm_menu \fImenu_name\fR {
    \fImenu_entry\fR
    .
    .
    .
    \fImenu_entry\fR 
}
.EE
Each menu entry is a TCL list of the form:
.EX 0
{ \fBentry_type\fR \fIargs\fR }
.EE
There are four types of menu entries:
.B title,
.B separator,
.B cascade
and
.B command.
.LP
As an example, the default windows menu is defined as follows:
.EX 0
tkwm_menu .windows_menu {
  {title  "Windows Menu"}
  {separator}
  {command  "Tiny XTerm"  "exec xterm &"}
  {command  "XTerm"  "exec xterm -geometry 80x40 &"}
}
.EE
As a further example, a simple cascaded menu can be defined as follows:
.EX 0
tkwm_menu .windows_menu {
  {title  "Windows Menu"}
  {separator}
  {cascade  "Tools"  .windows_menu.tools}
  {command  "XTerm"  "exec xterm -geometry 80x40 &"}
}

tkwm_menu .windows_menu.tools {
  {command "Emacs" "exec emacs &"}
  {command "Ghostview" "exec ghostview &"} 
}
.EE
Note that the cascaded menu must be a child of the menu it cascades from.
.SS "Convenience Functions"
.LP
Many useful functions are defined in the file
\fB/usr/local/lib/tkwm/functions.tcl\fR.
In this section we describe the functions that are intented for
casual customization. Users wishing to make radical changes in
the behavior of
.I stkwm
are urged to look at the source code.

'\" FINISH ME
.IP "\fBtitlebar\fR:" 20
HI
.IP "\fBrefresh\fR:" 20
HI
.IP "\fBwrefresh\fR \fIwin\fR:" 20
HI
.IP "\fBraise_lower\fR \fIwin\fR:" 20
HI
.IP "\fBraise\fR \fIwin\fR:" 20
HI
.IP "\fBlower\fR \fIwin\fR:" 20
HI
.IP "\fBclient_menu\fR \fIclient\fR:" 20
HI
.IP "\fBpopup_client_menu\fR \fIclient x y\fR:" 20
HI
.IP "\fBzoom\fR \fIwin\fR:" 20
HI
.IP "\fBvzoom\fR \fIwin\fR:" 20
HI
.IP "\fBhzoom\fR \fIwin\fR:" 20
HI
.IP "\fBdeiconify\fR \fIwin\fR:" 20
HI
.IP "\fBiconify\fR \fIwin\fR:" 20
HI
.IP "\fBclient_root\fR:" 20
HI
.IP "\fBgrabevents\fR \fIwin event1 event2 ...\fR:" 20
HI
.IP "\fBungrabevents\fR \fIwin event1 event2 ...\fR:" 20
HI
.IP "\fBtree-bind\fR \fIwin event command\fR:" 20
HI
.IP "\fBhandleError\fR \fIcommand errorHandler\fR:" 20
HI
.IP "\fBunwindProtect\fR \fIcommand postCommands\fR:" 20
HI
.IP "\fBnoisyCatch\fR \fIcommand\fR:" 20
HI
.IP "\fBtkwm_restart\fR:" 20
HI
.IP "\fBusePackage\fR \fIpackage:" 20
load a package installed in the library directory.
.IP "\fBexit\fR:" 20
HI

.SS "Bindings"
.LP
The default bindings are defined in the file
\fB/usr/local/lib/tkwm/custom.tcl\fR.
Most of the default bindings are provided by class bindings to the
classes \fBClient\fR and \fBIcon\fR.
The default client bindings are:
.EX 0
bind Client <L7> {iconify %W}
bind Client <L5> {raise_lower %W}
bind Client <Shift-L5> {lower %W}
bind Client <L9> {wrefresh %W}
bind Client <Meta-F1> {raise %W}
bind Client <Meta-F3> {lower %W}
bind Client <Meta-F7> {move %W <Any-ButtonRelease-1>}
bind Client <Meta-F8> {resize %W <Any-ButtonRelease-1>}
bind Client <Meta-F9> {iconify %W}
bind Client <Meta-F10> {zoom %W}
bind Client <Meta-F11> {vzoom %W}
bind Client <Meta-F12> {hzoom %W}
bind Client <Shift-Escape> {client_menu %W}
.EE
The default icon bindings are:
.EX 0
bind Icon <L7> {deiconify [client_root %W]}
bind Icon <L5> {raise_lower %W}
bind Icon <Meta-F1> {raise %W}
bind Icon <Meta-F3> {lower %W}
bind Icon <Meta-F7> {move %W <Any-ButtonRelease-1>}
bind Icon <Meta-F9> {deiconify [client_root %W]}
bind Icon <Meta-F10> { zoom [client_root %W]; \\
		       deiconify [client_root %W]}
.EE
.LP
In addition there are two procedures,
.B frame_bindings
and \fBicon_bindings\fR, that define bindings that must
be made when a new client frame or icon window is created.
The default code for these procedues is

.EX 0
proc frame_bindings {frame} {
    grabevents $frame <Meta-F1> <Meta-F3> <Meta-F7> \\
	<Meta-F8> <Meta-F9> <Meta-F10> <Meta-F11> \\
	<Meta-F12> <L7> <L5> <Shift-L5> \\
	<L9> <Shift-Escape>

    tree-bind $frame <ButtonPress-2> \\
	"move $frame <Any-ButtonRelease-2>"
    tree-bind $frame <ButtonPress-3> \\
	"resize $frame <Any-ButtonRelease-3>"
    tree-bind $frame <ButtonPress-1> \\
	"popup_client_menu $frame %X %Y"
}

proc icon_bindings {iconwin} {
    grabevents $iconwin <Button-1> <Button-2> <L5> \\
	<L7> <Meta-F1> <Meta-F3> <Meta-F5> <Meta-F7>

    tree-bind $iconwin <ButtonPress-2> \\
	[list move $iconwin <Any-ButtonRelease-2>]
    tree-bind $iconwin <ButtonRelease-1> \\
	"deiconify \\[client_root \\"$iconwin\\"\\]"
}
.EE
Note that if you wish to bind a keyboard event, either within these
procedures, or with a global bind command, the keyboard event
must be declared in the list of passed to the grabevents procedure
in the first line of each of these procedures. If this is not
done then the keyboard bindings will not be effective over the actual
client window, but only when the mouse is over the frame attached
to the window.
.SS "Geometry Managers"
.LP
In
.I stkwm
each window has an associated
.I geometry manager
that is responsible for the placement policy governing
the window's location on the screen.
The default geometry managers are defined in the file
\fB/usr/local/lib/tkwm/custom.tcl\fR.
There are two basic types of geometry managers defined in
\fIstkwm\fR: \fBsimpleManager\fR, and fBpackingManager\fR.
Sophisticated users may wish to write their own types of geometry managers
as well, but that is beyond the scope of this document.
To declare an instance of a simpleManager the user simple places
a line like:
.EX 0
simpleManager \fImanager-name\fR
.EE
into their ~/.stkwmrc file.
The name \fImanager-name\fR can then be specified as the geometry
manager of choice under the preferences editor, or by directly editing
the X resources files.
Simple managers are exactly that. They do nothing to affect the
placement of the windows they manage, they only keep track of which
windows are under their management.
The packingManager type of geometry manager is more sophisticated.
An instance of a packingManager is specified with a line of code like:
.EX 0
packingManager \fImanager-name\fR 200x600-0-0 5 5 south east
.EE
This specifies a new packing manager that will control
a region 200 pixels wide by 600 pixels high, located in the south east
corner of the screen. As new windows controled by the
packing manager are placed onto the screen, they will be placed into
the specified region with a spacing of 5 pixels on all sides,
and starting in the south east corner, moving south to north first,
and then east to west as the south to north columns fill.
Furthermore, as windows cease to exist, the remaining windows will be
repacked into the designated region.
The most common application of a packing manager is to place icons into
a tightly packed tiling along some edge of the screen.

Note that there can be more than one instance of any type of manager.
The default managers are defined by:
.EX 0
simpleManager tkwmDefaultSimpleManager
packingManager tkwmDefaultIconManager 200x600-0-0 \\
	5 5 south east
.EE
.SS "Titlebar Buttons"
.LP
'\" FINISH ME
Stuff
.SS Rooms
.LP
'\" FINISH ME
Stuff
.SS "The Window heirarchy"
.LP
'\" FINISH ME
Stuff
.SS "Variables"
.LP
Users wishing to customize
.I stkwm
should be aware of the following variables maintained by
.I stkwm.
Note that this is not a complete list of the variables used
.I stkwm,
but rather a list of those variables that users a likely to need
access to.

'\" FINISH ME
tkwm(maintainer)
tkwm(version)
tkwm_priv(managers)
tkwm_priv(*) - other private variables. Don't use this unless you
are sure you know what you are doing!
tkwm_resource
tkwm_libpath
window_list
menu_list
current_client

'\" FINISH ME
.win_number(root)
.win_number(decoration)
.win_number(state)
.win_number(root-plug)
.win_number(res_name)
.SS "Hooks"
.LP
'\" FINISH ME
Stuff
	tkwm_restart.hook
	resource_name.hook

	Resource value hooks:

	client hooks:
        hook.use_WM_STATE
        hook.opaqueMove
        hook.constrained
        hook.opaqueResize

        icon hooks:
        hook.icon.bitmap
        hook.icon.width
        hook.icon.height
        hook.icon.opaqueMove
        hook.icon.constrained
        hook.icon.opaqueResize
.SH "FILES"
.LP
The following files in the users home directory are used:
.PD 0
.TP 25
.B ~/.stkwmrc
TCL code read at the beginning of execution, and
whenever the window manager is restarted.
.TP
.B ~/.tkwm_mono.appdefs
Users X Resources for monochrom monitors.
.TP
.B ~/.tkwm_color.appdefs
Users X Resources for color monitors.
.PD
.LP
The following files are the TCL source for
.I stkwm.
They are usually located in the directory
.B /usr/local/lib/tkwm.
.PD 0
.TP 25
.B *.xbm
Bitmaps used in the preferences editor.
.TP
.B widget.appdefs
Default X Resources for widgets written in Tcl.
.TP
.B tkwm_mono.appdefs
Default X Resources for monochrome monitors.
.TP
.B tkwm_color.appdefs
Default X Resources for color monitors.
.TP
.B custom.tcl
Definitions for the default keyboard and mouse bindings,
for the default menus, and for the default managers.
Users wishing to customize
.I stkwm
might use this as a starting point for their ~/.stkwmrc file.
.TP
.B decos.tcl
Default decoration widgets for clients and icons.
.TP
.B error.tcl
Error handling dialogs.
.TP
.B focus.tcl
Focus handling code.
.TP
.B frames.tcl
Code to handle placing of frames on new clients.
.TP
.B functions.tcl
Basic functions used throughout the window manager.
.TP
.B icons.tcl
Icon handling code.
.TP
.B iframes.tcl
Code to handle placing of frames on clients internal
to the window manager.
.TP
.B managers.tcl
Code for the two built in geometry managers:
.I simpleManager
and
.I packingManager.
.TP
.B mbuttons.tcl
Code for MWM style titlebar buttons.
.TP
.B menus.tcl
Code for popup menus.
.TP
.B move.tcl
Window movement code.
.TP
.B prefdialogs.tcl
Preference editor dialog code.
.TP
.B preferences.tcl
Window manager preference reading code.
.TP
.B prefwidgets.tcl
Widgets used in the perference editor.
.TP
.B resize.tcl
Window resizing code.
.TP
.B simple_rooms.tcl
Simple menu driven rooms code.
.TP
.B stkwm.tcl
Main source file for
.I stkwm.
.TP
.B stkwm_prefs.tcl
Main source file for
.I stkwm_prefs,
the
.I stkwm
preferences editor.
.TP
.B widgets.tcl
Support code for writing TK builtin style widgets.
.PD
.SH "ENVIRONMENT VARIABLES"
.LP
.IP DISPLAY 10
The display to manage if not specified by the command line.
.IP HOME 10
The location of the users home directory.
.SH "BUGS"
.LP
.I Stkwm
does not obey aspect ratio restrictions as declared by
applications.
.SH "SEE ALSO"
.LP
.BR stkwm_prefs(1), 
.BR tcl(1),
.BR tkwm(1),
.BR tk(1).
.SH "AUTHOR"
.LP
Eric Schenk, Department of Computer Science, University of Toronto.
