#
# Copyright (c) 1993 Eric Schenk.
# All rights reserved.
#
# Permission is hereby granted, without written agreement and without
# license or royalty fees, to use, copy, modify, and distribute this
# software and its documentation for any purpose, provided that the
# above copyright notice and the following two paragraphs appear in
# all copies of this software.
# 
# IN NO EVENT SHALL ERIC SCHENK BE LIABLE TO ANY PARTY FOR
# DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
# OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF ERIC
# SCHENK HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# ERIC SCHENK SPECIFICALLY DISCLAIMS ANY WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND ERIC SCHENK HAS NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

# A simple implementation of rooms.
# This is just intended as a simple demonstration of possiblities.

set tkwm_priv(currentroom) global

tkwm_menu .room_menu {
    {title "Rooms"}
    {separator}
    {command "Global" "goto_room global"}
}

proc add_room {name} {
    .room_menu add command -label $name -command "goto_room $name"
}

proc goto_room {name} {
    global tkwm_priv
    if {$tkwm_priv(currentroom) != $name} {
	if {$tkwm_priv(currentroom) != "global"} {
	    withdraw_room $tkwm_priv(currentroom)
	}
	set tkwm_priv(currentroom) $name
	if {$name != "global"} {
	    display_room $name
	}
    }
}

bind . <ButtonPress-2> {tkwm_postmenu .room_menu %X %Y}
