.\" @(#) TopLevel.n 1.1 30 Sep 1994 (C) SNI AG; MR STO SI 134, MR OI 2
.\" Author: Allan Brighton.
.so man.macros
.HS TopLevelWidget itcl
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
TopLevelWidget \- An [incr Tcl] Base Class for Widgets with their own Top Level Window
.SH SYNOPSIS
.nf
itcl_class \fIMyWidget\fR {
    inherit \fBTopLevelWidget\fR
    constructor {config} {
        \fBTopLevelWidget\fR::constructor \fI?-option arg?...\fR
        ...
    }
}

\fIMyWidget\fR \fB:: start\fB
\fR
.fi
.ta 4c
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
\fB\-center\fR \fIboolean\fB
.fi
.IP
If \fIboolean\fR is 1, the window will be centered on the screen.
.LP
.nf
\fB\-withdraw\fR \fIboolean\fB
.fi
.IP
If withdraw is 1, the window will be withdrawn immediately and can de displayed
later with \fIwm deiconify ...\fR.
.LP
.nf
\fB\-transient\fR \fIboolean\fB
.fi
.IP
If transient is true and this is the child of another toplevel 
widget, make the popup window transient, 
so that it will open and close with its parent (default: true).
.LP
.nf
\fB\-standalone\fR \fIboolean\fB
.fi
.IP
If standalone is 1, the \fIquit\fR method will call \fIexit\fR to end the application,
otherwise it only unmaps the top level window.
.BE
.SH DESCRIPTION
.PP
The \fBTopLevelWidget\fR itcl class creates a top level window with the same name as
the class object (\fIthis\fR) and sets up the necessary bindings, so that the Itcl
object and any descending objects are destroyed if the toplevel widget is destroyed. 
In addition, a number of useful \fImethods\fR are defined, for use by the derived classes. 
.SH "METHODS"
.PP
The following operations are defined in the \fBTopLevelWidget\fR class for use by 
derived classes:
.TP
\fBconfig\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Modify the configuration options of the widget.
\fIOption\fR may have any of the values accepted by the \fBTopLevelWidget\fR
constructor. This method is inherited by derived classes, so you can use \fBconfig\fR
on a derived object and specify options for that object as well.
.TP
\fIclassName \fB :: start\fR 
The \fBstart\fR member proc is used to start up an \fIapplication class\fR, that is, the main
class in the program. \fIclassName\fR is the name of a class derived from TopLevelWidget.
\fBstart\fI unmaps the Tk toplevel window \fB"."\fR, and replaces it with a new toplevel
window and Itcl object called \fI.classname\fR (i.e.: the name of the class in lower case with a "."
prepended).
\fBstart\fI then \fIwaits\fR for the new toplevel window to be destroyed and then exits.
The command line arguments (argv) are passed to \fIclassName\fB unchanged, so that any 
public variables in \fIclassName\fB will be allowed as options to the program. If any
unrecognized options are found, an informative error message is printed out, indicating 
which option was not recognized and what the available options are. The Itcl \fBinfo\fR
command is used here to print out a list of the public member variables.
.TP
\fBquit\fR
If \fIstandalone\fR is set to 1, this exits the program, otherwise
it only unmaps the toplevel window for this object.
.TP
\fBbusy \fI{ commands... }\fR
This command displays the \fIblt\fR busy cursor while evaluating
the given commands within the scope of the calling class method.
Nested calls to \fBbusy\fR are allowed and errors are propagated to
the caller.
.TP
\fBadd_menubar\fR
Adds a menu bar to the top of the toplevel window. 
\fINote: the menu operations probably should be in a Menubar class, but since usually only 
top level windows have menu bars, it seemed practical to put these methods here.\fR
.TP
\fBadd_menubutton \fIlabel ?side?\fR
Add a menubutton with the given label to the menu bar and return the name of
the menubutton, which is generated from the label name. The label should not
contain any spaces or periods in this case. Typical labels are \fIFile, View, Edit, Help\fR.
\fIside\fR may be \fBleft\fR or \fBright\fR to indicate what side of the menubar to pack it on.
The default is \fBleft\fR.
.TP
\fBsetup_menubar_traversal\fR
Calls \fBtk_menuBar\fR to setup menu bar traversal.
.TP
\fBcenter_window\fR
Centers the toplevel window in the screen.

.SH AUTHOR
.TP 0
Allan Brighton - Free-lance Software Engineer (near Munich)
.sp 0
E-mail: allan@piano.sta.sub.org
.sp 0
Snail-Mail: Zaissing 3, 85643 Steinhoering, Germany
.SH SEE ALSO
FrameWidget
.SH KEYWORDS
TopLevelWidget, widget
