#ifndef _TreePolyline_h_
#define _TreePolyline_h_

/*
 * TreePolyline.h - definition of class TreePolyline
 *
 * -----------------------------------------------------------------------------
 * Copyright 1994 Allan Brighton.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies.  
 * Allan Brighton make no representations about the suitability of this 
 * software for any purpose. It is provided "as is" without express or 
 * implied warranty.
 * -----------------------------------------------------------------------------
 */

#include "config.h"
#include "Point.h"


class _EXPORT TreePolyline {
public:
    TreePoint p;
    TreePolyline *link;
    
    TreePolyline() : link(NULL) {}
    TreePolyline(int x, int y, TreePolyline* pl = 0) : p(x, y), link(pl) {}
};


// These classes defines a simple linked list of polyline pointers
// used for garbage collection.

class _EXPORT TreePListNode {
private:
    TreePolyline* p_;
    TreePListNode* next_;
public:
    TreePListNode(TreePolyline* p) : p_(p), next_(NULL) {}
    ~TreePListNode() {delete p_; p_ = NULL; delete next_;}
    TreePListNode* append(TreePListNode* n) {return (next_ = n);}
    TreePListNode* next() {return next_;}
};

class _EXPORT TreePList {
private:
    TreePListNode* first_;
    TreePListNode* last_;
public:
    TreePList() : first_(NULL), last_(NULL) {}
    ~TreePList() {delete first_;}
    TreePListNode* first() {return first_;}
    TreePListNode* last() {return last_;}
    void append(TreePolyline* p) {
	if (last_) 
	    last_ = last_->append(new TreePListNode(p));
	 else 
	    first_ = last_ = new TreePListNode(p);
    }
};


#endif /* _TreePolyline_h_ */
