#ifndef _TkWidget_H_
#define _TkWidget_H_
/* 
 * TkWidget.h - base class for Tk widgets implemented in C++.
 * 
 * This class adds some features to the TclCommand class for 
 * implementing Tk widgets.
 *
 * -----------------------------------------------------------------------------
 * Copyright 1994 Allan Brighton.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies.  
 * Allan Brighton make no representations about the suitability of this 
 * software for any purpose. It is provided "as is" without express or 
 * implied warranty.
 * -----------------------------------------------------------------------------
 *
 */

#ifdef	TCL_MSDOS_PORT
#include <tkInt.h>
#else
#include <tk.h>
#endif

#include <tk.h>
#include <tcl.h>
#include "TclCommand.h"

/* 
 * A struct derived from this one is used to hold the values
 * modified by the configure widget command
 */
class TkWidgetOptions {};


/* 
 * This is the base class for classes defining tk widgets from
 * C++ classes
 */
class _EXPORT TkWidget : public TclCommand {
protected:
    Tk_Window tkwin_;			// widget's Tk window
    char* pname_;			// name of parent window
    char* wclass_;                      // this widget's class

    Tk_ConfigSpec* configSpecsPtr_;     // ptr to widget's config struct
    TkWidgetOptions* optionsPtr_;       // ptr to struct holding option values

    // do first time widget configuration 
    int initWidget(int argc, char* argv[]);

    // configure the widget with cmd line options.
    int configureWidget(int argc, char* argv[], int flags = 0);
    
public:

    // constructor: pclass is the expected parent window class type,
    // the specs and options args are used to process the command line
    // args and for the configure widget command.
    TkWidget(Tcl_Interp*, const char* pclass, 
	     Tk_ConfigSpec* specs, TkWidgetOptions& options,
	     int argc, char* argv[]);

    // destructor
    virtual ~TkWidget();

    // call a member function by name
    virtual int call(const char* name, int argc, char* argv[]);

    // called for the configure widget command
    int configure_(int argc, char* argv[]);
};


#endif /* _TkWidget_H_ */


