/************************************************************************
 ** Copyright (c) 1994, Aaron Jackson
 ** All rights reserved
 **
 ** Permission to use, copy, modify, and distribute this software and
 ** its documentation for any purpose and without fee is hereby granted,
 ** provided that the above copyright notice appear in all copies and
 ** that both that copyright notice and this permission notice appear in
 ** supporting documentation.
 **
 ** In no event shall the author(s) be liable to any party for direct,
 ** indirect, special, incidental, or consequential damages arising out
 ** of the use of this software and its documentation, even if the
 ** authors(s) have been advised of the possibility of such damage.
 **
 ** The authors(s) specifically disclaim any warranties, including but
 ** not limited to, the implied warranties of merchantability and
 ** fitness for a particular purpose.  The software provided hereunder
 ** is on an "as is" basis, and the author(s) have no obligation to
 ** provide maintenance, support, updates, enhancements, or modifications
 ************************************************************************/


static char rcsid[] = "$Header: /home/edsdev/cvstree/tcldev/vwtable/vwBits.c,v 1.3 1994/11/11 22:35:42 aajackso Exp $" ;

/**
 ** $Log: vwBits.c,v $
 * Revision 1.3  1994/11/11  22:35:42  aajackso
 * *** empty log message ***
 *
 * Revision 1.2  1994/11/11  21:36:27  aajackso
 * *** empty log message ***
 *
 * Revision 1.1.1.1  1994/10/21  13:35:28  aajackso
 * Table Widget
 *
 * Revision 1.1  1994/08/24  00:55:59  aaron
 * Initial revision
 *
 **/

#include <stddef.h>
#include <malloc.h>
#include <vwBits.h>

/************************************************************************
 ** void
 ** VWBitset_Shift( VWBitset*        bitset,
 **                 int              offset,
 **                 int              positions )
 **
 ** Shifts the bits in a bitset.  Bits from <offset> on are shifted
 ** by <positions> bits
 ************************************************************************/

#ifdef __STDC__
void
VWBitset_Shift( VWBitset*          bitset,
                int                offset,
                int                positions )
#else /** __STDC__ **/
void
VWBitset_Shift( bitset, offset, positions )
    VWBitset*          bitset ;
    int                offset ;
    int                positions ;
#endif /** __STDC__ **/
{
  if ((! bitset) || (! positions))
    return ;

  /**
   ** Left shifts and right shifts operate differently
   **/

  if (positions > 0)        /** Right shifts **/
    {
      int l_bit = bitset->nbytes * VWNBITSPER - positions - 1 ;
      int r_bit = bitset->nbytes * VWNBITSPER - 1 ;

      /** Copy from r_bit to l_bit **/

      int bits[2] ;
      unsigned char* addr[2] ;

      addr[0] = bitset->bits + (l_bit / VWNBITSPER) ; bits[0] = l_bit % VWNBITSPER ;
      addr[1] = bitset->bits + (r_bit / VWNBITSPER) ; bits[1] = r_bit % VWNBITSPER ;

      while (l_bit >= offset)
	{
#if 0
	  printf("Shift: %8x (%1d) (%2d) (%1d) --> %8x (%1d) (%2d)\n",
		 addr[0], bits[0], l_bit, ((addr[0][0] & (1 << bits[0])) ? 1 : 0),
		 addr[1], bits[1], r_bit) ;
#endif

	  addr[1][0] &= ~(1 << bits[1]) ;
	  addr[1][0] |= ((addr[0][0] & (1 << bits[0])) ? (1 << bits[1]) : 0) ;

	  /** Roll the bits **/

	  if (! bits[0]--)
	    {
	      addr[0]-- ;
	      bits[0] = VWNBITSPER - 1 ;
	    }

	  if (! bits[1]--)
	    {
	      addr[1]-- ;
	      bits[1] = VWNBITSPER - 1 ;
	    }

	  l_bit-- ;
	  r_bit-- ;
	}

      while (r_bit >= offset)
	{
#if 0
	  printf("r_bit: (%2d) (%2d) (%4x) (%1d) (%4x) (%1d)\n",
		 r_bit, offset, addr[0], bits[0], addr[1], bits[1]) ;
#endif

	  addr[1][0] &= ~(1 << bits[1]) ;
	  if (! bits[1]--)
	    {
	      addr[1]-- ;
	      bits[1] = VWNBITSPER - 1 ;
	    }

	  r_bit-- ;
	}
    }
  else                      /** Left shifts **/
    {
      int l_bit = offset + positions ;
      int r_bit = offset ;

      /** Copy from left to right **/

      int            nbits ;
      int            bits[2] ;
      unsigned char* addr[2] ;

      if (l_bit < 0)
	{
	  r_bit -= l_bit ;
	  l_bit  = 0 ;
	}

      nbits = bitset->nbytes * VWNBITSPER ;

      addr[0] = bitset->bits + (l_bit / VWNBITSPER) ; bits[0] = l_bit % VWNBITSPER ;
      addr[1] = bitset->bits + (r_bit / VWNBITSPER) ; bits[1] = r_bit % VWNBITSPER ;

      while (r_bit <= nbits)
	{
#if 0
	  printf("Shift: %8x (%1d) (%2d) (%1d) --> %8x (%1d) (%2d)\n",
		 addr[1], bits[1], r_bit, ((addr[1][0] & (1 << bits[1])) ? 1 : 0),
		 addr[0], bits[0], l_bit) ;
#endif

	  addr[0][0] &= ~(1 << bits[0]) ;
	  addr[0][0] |= ((addr[1][0] & (1 << bits[1])) ? (1 << bits[0]) : 0) ;

	  /** Roll the bits **/

	  if ((VWNBITSPER - 1) == bits[0]++)
	    {
	      addr[0]++ ;
	      bits[0] = 0 ;
	    }

	  if ((VWNBITSPER - 1) == bits[1]++)
	    {
	      addr[1]++ ;
	      bits[1] = 0 ;
	    }

	  l_bit++ ;
	  r_bit++ ;
	}

      while (l_bit <= nbits)
	{
#if 0
	  printf("r_bit: (%2d) (%2d) (%4x) (%1d) (%4x) (%1d)\n",
		 r_bit, offset, addr[0], bits[0], addr[1], bits[1]) ;
#endif

	  addr[0][0] &= ~(1 << bits[0]) ;
	  if ((VWNBITSPER - 1) == bits[0]++)
	    {
	      addr[0]++ ;
	      bits[0] = 0 ;
	    }

	  l_bit++ ;
	}
    }
}

/************************************************************************
 ** void
 ** VWBitset_Free( VWBitset* bitset )
 **
 ** Deallocates memory associated with this bitset
 ************************************************************************/

#ifdef __STDC__
void
VWBitset_Free( VWBitset*    bitset )
#else /** __STDC__ **/
void
VWBitset_Free( bitset )
    VWBitset*    bitset ;
#endif /** __STDC__ **/
{
  if (bitset->bits)
    free((char *) bitset->bits) ;
}

/************************************************************************
 ** VWBitset*
 ** VWBitset_Alloc( VWBitset*      bitset,
 **                 unsigned long  n_bits )
 **
 ** Allocates and/or reallocates a bitset for n_bits
 ************************************************************************/

#ifdef __STDC__
VWBitset*
VWBitset_Alloc( VWBitset*        bitset,
                unsigned long    n_bits )
#else /** __STDC__ **/
VWBitset*
VWBitset_Alloc( bitset, n_bits )
    VWBitset*        bitset ;
    unsigned long    n_bits ;
#endif /** __STDC__ **/
{
  if (bitset == NULL)
    return NULL ;

  {
    unsigned long bytes_required = (n_bits / 8) + ((n_bits % 8) != 0) ;

    if (bitset->nbytes == bytes_required)
      return bitset ;

    if (bitset->bits)
      {
	bitset->bits = (unsigned char *) realloc(bitset->bits, bytes_required) ;
	if (bitset->nbytes < bytes_required)
	  memset(bitset->bits + bitset->nbytes, 0x0, bytes_required - bitset->nbytes) ;
      }
    else
      {
	bitset->bits = (unsigned char *) malloc(bytes_required) ;
	memset(bitset->bits, 0x0, bytes_required) ;
      }

    bitset->nbytes = bytes_required ;
  }

  return bitset ;
}
