#ifndef VWBits_H
#define VWBits_H

#include <memory.h>
#include <ansi_args.h>

#define VWNBITSPER    (8)

#define VWBit_Clr(bitset, bit)    ((bitset)->bits[(bit)/VWNBITSPER] &= ~(1 << ((bit) % VWNBITSPER)))
#define VWBit_Set(bitset, bit)    ((bitset)->bits[(bit)/VWNBITSPER] |= (1 << ((bit) % VWNBITSPER)))
#define VWBit_IsSet(bitset, bit)  ((bitset)->bits[(bit)/VWNBITSPER] & (1 << ((bit) % VWNBITSPER)))
#define VWBitset_Zero(bitset)     memset((char *) ((bitset)->bits), 0x0, (bitset)->nbytes)

typedef struct VWBitset VWBitset ;
struct         VWBitset
{
  unsigned char*    bits ;
  unsigned long     nbytes ;         /** Allocated space **/
};

EXTERN void      VWBitset_Free  _ANSI_ARGS_((VWBitset*)) ;
EXTERN VWBitset* VWBitset_Alloc _ANSI_ARGS_((VWBitset*, unsigned long)) ;
EXTERN void      VWBitset_Shift _ANSI_ARGS_((VWBitset*, int, int)) ;

#endif /** VWBits_H **/
