#ifndef VWMatrix_H
#define VWMatrix_H

#include <ansi_args.h>

#define VWMatrixIndex(matrix, type, x, y, z) \
    ((type *) ((matrix).memory + (z) * (matrix).z_block_size + (y) * (matrix).y_block_size + (x) * (matrix).size))

typedef struct VWMatrix VWMatrix ;
struct         VWMatrix
{
  unsigned int           width ;
  unsigned int           height ;
  unsigned int           depth ;

  unsigned long          allocated_memory ;
  unsigned int           size ;

  unsigned long          z_block_size ;
  unsigned long          y_block_size ;

  char*                  memory ;
};

EXTERN void VWMatrix_Free   _ANSI_ARGS_((VWMatrix*)) ;
EXTERN int  VWMatrix_Alloc  _ANSI_ARGS_((VWMatrix*, unsigned int, unsigned int, unsigned int)) ;
EXTERN void VWMatrix_ShiftX _ANSI_ARGS_((VWMatrix*, int, int)) ;
EXTERN void VWMatrix_ShiftY _ANSI_ARGS_((VWMatrix*, int, int)) ;

#endif /** VWMatrix_H **/

