/************************************************************************
 ** Copyright (c) 1994, Aaron Jackson
 **
 ** Permission to use, copy, modify, and distribute this software and
 ** its documentation for any purpose and without fee is hereby granted,
 ** provided that the above copyright notice appear in all copies and
 ** that both that copyright notice and this permission notice appear in
 ** supporting documentation.
 **
 ** In no event shall the author(s) be liable to any party for direct,
 ** indirect, special, incidental, or consequential damages arising out
 ** of the use of this software and its documentation, even if the
 ** authors(s) have been advised of the possibility of such damage.
 **
 ** The authors(s) specifically disclaim any warranties, including but
 ** not limited to, the implied warranties of merchantability and
 ** fitness for a particular purpose.  The software provided hereunder
 ** is on an "as is" basis, and the author(s) have no obligation to
 ** provide maintenance, support, updates, enhancements, or modifications
 ************************************************************************/

static char rcsid[] = "$Header: /home/edsdev/cvstree/tcldev/vwtable/vwTable.c,v 1.2 1994/11/11 21:36:38 aajackso Exp $" ;

/**
 ** $Log: vwTable.c,v $
 * Revision 1.2  1994/11/11  21:36:38  aajackso
 * *** empty log message ***
 *
 * Revision 1.1.1.1  1994/10/21  13:35:24  aajackso
 * Table Widget
 *
 * Revision 1.1  1994/08/24  00:55:59  aaron
 * *** empty log message ***
 *
 * Revision 1.0  1994/08/17  23:54:06  aaron
 * Initial revision
 **/

#include <malloc.h>
#include <values.h>

#include <tk.h>
#include <tcl.h>

#include <vwTable.h>
#include <vwTableCell.h>
#include <vwTableDefs.h>

#define Cast(xx, yy) ((yy) (xx))

/************************************************************************
 ** void VWT_ResetColumns( VWTable    *vwptr,
 **                        int         oldColumns,
 **                        int         newColumns )
 **
 ** Resets number of columns available.
 ************************************************************************/

#ifdef __STDC__
void
VWT_ResetColumns( VWTable*          vwptr,
                  int               oldColumns,
                  int               newColumns )
#else /** __STDC__ **/
void
VWT_ResetColumns( vwptr, oldColumns, newColumns )
    VWTable*          vwptr ;
    int               oldColumns ;
    int               newColumns ;
#endif /** __STDC__ **/
{
  /**
   ** This implementation is rather ugly.  In a smart world, I would
   ** have kept in touch with how much memory I have allocated so that
   ** I don't stupidly deallocate and reallocate memory.  Changes in
   ** future revisions.
   **/

  register int *newColumnWidth ;
  register int  i ;

  if (newColumns == oldColumns)
    return ;

  newColumnWidth = (int *) malloc(newColumns * sizeof(int));
  memcpy((char *) newColumnWidth, 
	 (char *) vwptr->columnWidth,
	 oldColumns * sizeof(int));

  for ( i = oldColumns ;
        i < newColumns ;
        i++ )
    {
      newColumnWidth[i] = DEF_VW_TABLE_COLUMN_WIDTH ;
    }
  
  if (vwptr->columnWidth)
     free((char *) vwptr->columnWidth);

  vwptr->columnWidth = newColumnWidth ;
}

/************************************************************************
 ** void VWT_ResetRows( VWTable    *vwptr,
 **                     int         oldRows,
 **                     int         newRows )
 **
 ** Resets number of columns available.
 ************************************************************************/

#ifdef __STDC__
void
VWT_ResetRows( VWTable*          vwptr,
               int               oldRows,
               int               newRows )
#else /** __STDC__ **/
void
VWT_ResetRows( vwptr, oldRows, newRows )
    VWTable*          vwptr ;
    int               oldRows ;
    int               newRows ;
#endif /** __STDC__ **/
{
  /**
   ** This implementation is rather ugly.  In a smart world, I would
   ** have kept in touch with how much memory I have allocated so that
   ** I don't stupidly deallocate and reallocate memory.  Changes in
   ** future revisions.
   **/

  register int *newRowHeight ;
  register int  i ;

  if (oldRows == newRows)
    return ;

  newRowHeight = (int *) malloc(newRows * sizeof(int));
  memcpy((char *) newRowHeight,
	 (char *) vwptr->rowHeight,
	 oldRows * sizeof(int));

  for ( i = oldRows ;
        i < newRows ;
        i++ )
    {
      newRowHeight[i] = DEF_VW_TABLE_ROW_HEIGHT ;
    }
  
  if (vwptr->rowHeight) 
    free((char *) vwptr->rowHeight) ;
  vwptr->rowHeight = newRowHeight ;
}
 

/************************************************************************
 ** int VWT_Create( ClientData     clientData,
 **                 Tcl_Interp    *interp,
 **                 int            argc,
 **                 char          *argv[] )
 **
 ** Create a VWTable, initialize the structure and setup callbacks
 ************************************************************************/

#ifdef __STDC__
int
VWT_Create( ClientData             clientData,
            Tcl_Interp*            interp,
            int                    argc,
            char*                  argv[] )
#else /** __STDC__ **/
int
VWT_Create( clientData, interp, argc, argv )
    ClientData             clientData ;
    Tcl_Interp*            interp ;
    int                    argc ;
    char*                  argv[] ;
#endif /** __STDC__ **/
{
  Tk_Window              main  = (Tk_Window) clientData ;
  Tk_Window              tkWin ;
  VWTable               *vwptr ;
  XSetWindowAttributes   attrs ;

  if ( argc < 2 )
    {
      Tcl_AppendResult(interp,
		       "wrong # args: should be \"",
		       argv[0],
		       " pathName ?options?\"",
		       NULL);

      return TCL_ERROR ;
    }

  /** Create the Tk_Window **/

  tkWin = Tk_CreateWindowFromPath(interp, main, argv[1], NULL);
  if (tkWin == NULL)
    return TCL_ERROR ;

  attrs.backing_store = Always ;
  Tk_ChangeWindowAttributes(tkWin, CWBackingStore, &attrs) ;

  /** Set the class for this window **/

  Tk_SetClass( tkWin, "VWTable" );

  /** Initialize the data structures required for this object **/

  vwptr                    = (VWTable *) calloc(1, sizeof(VWTable));
  vwptr->tkWin             = tkWin ;
  vwptr->display           = Tk_Display( tkWin ) ;
  vwptr->interp            = interp ;
  vwptr->gc                = None ;
  vwptr->bgBorder          = NULL ;
  vwptr->fgBorder          = NULL ;
  vwptr->updatePending     = 0 ;
  vwptr->vrow              = 0 ;
  vwptr->vcolumn           = 0 ;
  vwptr->rows              = 0 ;
  vwptr->columns           = 0 ;
  vwptr->rowHeight         = NULL ;
  vwptr->columnWidth       = NULL ;
  vwptr->xScrollCmd        = NULL ;
  vwptr->yScrollCmd        = NULL ;
  vwptr->fontPtr           = NULL ;
  vwptr->redrawBackground  = TRUE ;
  vwptr->scrollOccurred    = TRUE ;
  vwptr->varName           = NULL ;
  vwptr->cursor            = None ;

  vwptr->image.pixmap      = VWT_NullPixmap ;
  vwptr->image.width       = 0 ;
  vwptr->image.height      = 0 ;
  vwptr->image.elements[0] = NULL ;
  vwptr->image.elements[1] = NULL ;

  vwptr->image.posts[0].bits   = 0 ;
  vwptr->image.posts[0].nbytes = 0 ;
  vwptr->image.posts[1].bits   = 0 ;
  vwptr->image.posts[1].nbytes = 0 ;

  vwptr->matrix.size = sizeof(VWTableCell*) ;

  vwptr->focus.row          = -1 ;
  vwptr->focus.col          = -1 ;
  vwptr->focus.vpos         = 0 ;
  vwptr->focus.curp         = 0 ;
  vwptr->focus.onTime       = 0 ;
  vwptr->focus.offTime      = 0 ;
  vwptr->focus.width        = 0 ;
  vwptr->focus.borderWidth  = 0 ;
  vwptr->focus.focusing     = 0 ;
  vwptr->focus.data         = NULL ;
  vwptr->focus.len          = 0 ;
  vwptr->focus.alloc        = 0 ;
  vwptr->focus.selTo        = -1 ;
  vwptr->focus.selFrom      = -1 ;
  vwptr->focus.export       = 0 ;
  vwptr->focus.blinkHandler = (Tk_TimerToken) NULL ;

  Tk_CreateEventHandler( tkWin,
			 ExposureMask|StructureNotifyMask|FocusChangeMask,
			 VWT_HandleEvent,
			 Cast( vwptr, ClientData )) ;

  Tcl_CreateCommand( interp,
		     Tk_PathName( tkWin ),
		     VWT_HandleCommand,
		     Cast( vwptr, ClientData ),
		     NULL );

  if (VWT_Configure( interp,
		     vwptr,
		     argc - 2,
		     argv + 2,
		     0 ) != TCL_OK )
    {
      Tk_DestroyWindow( vwptr->tkWin );
      return TCL_ERROR ;
    }

  interp->result = Tk_PathName( tkWin );
  return TCL_OK ;
}
