/************************************************************************
 ** Copyright (c) 1994, Aaron Jackson
 **
 ** Permission to use, copy, modify, and distribute this software and
 ** its documentation for any purpose and without fee is hereby granted,
 ** provided that the above copyright notice appear in all copies and
 ** that both that copyright notice and this permission notice appear in
 ** supporting documentation.
 **
 ** In no event shall the author(s) be liable to any party for direct,
 ** indirect, special, incidental, or consequential damages arising out
 ** of the use of this software and its documentation, even if the
 ** authors(s) have been advised of the possibility of such damage.
 **
 ** The authors(s) specifically disclaim any warranties, including but
 ** not limited to, the implied warranties of merchantability and
 ** fitness for a particular purpose.  The software provided hereunder
 ** is on an "as is" basis, and the author(s) have no obligation to
 ** provide maintenance, support, updates, enhancements, or modifications
 ************************************************************************/

static char rcsid[] = "$Header: /home/edsdev/cvstree/tcldev/vwtable/vwTableBitmap.c,v 1.1.1.1 1994/10/21 13:35:22 aajackso Exp $" ;

/**
 ** $Log: vwTableBitmap.c,v $
 * Revision 1.1.1.1  1994/10/21  13:35:22  aajackso
 * Table Widget
 *
 * Revision 1.1  1994/08/24  00:55:59  aaron
 * *** empty log message ***
 *
 * Revision 1.0.0.1  1994/08/18  00:05:48  aaron
 * *** empty log message ***
 *
 * Revision 1.0  1994/08/17  23:54:06  aaron
 * Initial revision
 *
 * Revision 1.1  1994/08/11  00:01:02  shadow
 * Initial revision
 *
 **/

#include <stdlib.h>
#include <memory.h>

#include <tk.h>
#include <tcl.h>
#include <vwRefer.h>
#include <vwTable.h>

static VWAddrTable bitmapTable ;

/************************************************************************
 ** void
 ** VWT_InitBitmaps( )
 **
 ** Doesn't do a damn thing except initialize the reference table
 ** which keeps track of all the colors this thread is using
 ************************************************************************/

#ifdef __STDC__
int
VWT_InitBitmaps( )
#else /** __STDC__ **/
int
VWT_InitBitmaps(  )
#endif /** __STDC__ **/
{
  return(VWRefer_Initialize(&bitmapTable, 387)) ;
}

/************************************************************************
 ** int
 ** VWT_FreeBitmap( Pixmap bitmap )
 **
 ** Please refer to comments in VWT_FreeColor for more information
 ** regarding this convoluted function.
 **
 ** This function will need more information such as information to use
 ** when destroying the bitmap.  This will be done in future releases
 ** as we only consider bitmaps via Tk's interface useable
 ************************************************************************/

#ifdef __STDC__
int
VWT_FreeBitmap( Display*       display,
                Pixmap         bitmap )
#else /** __STDC__ **/
int
VWT_FreeBitmap( display, bitmap )
    Display*       display ;
    Pixmap         bitmap ;
#endif /** __STDC__ **/
{
  VWAddr *ptr ;

  if ((bitmap == VWT_BadPixmap) || (bitmap == VWT_NullPixmap))
    return FALSE ;

  ptr = VWRefer_GetAddr(&bitmapTable, (void *) bitmap) ;
  ptr->refs-- ;

  if (ptr->refs != 0)
    return FALSE ;

  Tk_FreeBitmap(display, bitmap) ;
  return TRUE ;
}

/************************************************************************
 ** Pixmap
 ** VWT_GetBitmap( Tcl_Interp*     interp,
 **                Tk_Window       tkWin,
 **                char*           bitmapName,
 **                VWAddr**        reference,
 **                unsigned int*   width,
 **                unsigned int*   height )
 **
 ** Please refer to comments in VWT_GetColor for more information
 ** regarding this convoluted function.
 ************************************************************************/

#ifdef __STDC__
Pixmap
VWT_GetBitmap( Tcl_Interp*                   interp,
               Tk_Window                     tkWin,
               char*                         bitmapName,
               VWAddr**                      reference,
               unsigned int*                 width,
               unsigned int*                 height )
#else /** __STDC__ **/
Pixmap
VWT_GetBitmap( interp, tkWin, bitmapName, reference, width, height )
    Tcl_Interp*                   interp ;
    Tk_Window                     tkWin ;
    char*                         bitmapName ;
    VWAddr**                      reference ;
    unsigned int*                 width ;
    unsigned int*                 height ;
#endif /** __STDC__ **/
{
  Pixmap bitmap ;
  
  if (strcmp(bitmapName, "") == 0)
    {
      *reference = NULL ;
      return VWT_NullPixmap ;
    }

  bitmap = Tk_GetBitmap(interp, tkWin, Tk_GetUid(bitmapName)) ;
  if (bitmap == (Pixmap) 0)
    {
      *reference = NULL ;
      return VWT_BadPixmap ;
    }

  *reference = VWRefer_GetAddr(&bitmapTable, (void *) bitmap) ;
  if ((*reference)->refs != 0)
    Tk_FreeBitmap(Tk_Display(tkWin), bitmap) ;

  Tk_SizeOfBitmap(Tk_Display(tkWin), bitmap, width, height);
  return bitmap ;
}
