#ifndef VWTableCell_H
#define VWTableCell_H

#include <tk.h>
#include <ansi_args.h>

#include <vwStack.h>

enum
{
  VWTableTextType = 1,
  VWTableBitmapType
};

typedef struct VWTableTextCell VWTableTextCell ;
struct         VWTableTextCell
{
  char          *data ;
  int            datalen ;
  int            anchor ;
};

typedef struct VWTableBitmapCell VWTableBitmapCell ;
struct         VWTableBitmapCell
{
  Pixmap         data ;
  unsigned int   width ;
  unsigned int   height ;
  char          *name ;
  int            namelen ;
  int            anchor ;
};

typedef struct VWTableCell VWTableCell ;
struct         VWTableCell
{
  int            changed ;
  VWStack        colors ;
  VWStack        fonts ;
  XFontStruct   *fontPtr ;
  int            fontHeight ;
  int            fontNameLen ;
  char          *fontName ;

  int            dataType ;
  union
    {
      VWTableTextCell            text ;
      VWTableBitmapCell          bitmap ;
    }
  data ;
};

#endif /** VWTableCell_H **/
