/************************************************************************
 ** Copyright (c) 1994, Aaron Jackson
 ** All rights reserved
 **
 ** Permission to use, copy, modify, and distribute this software and
 ** its documentation for any purpose and without fee is hereby granted,
 ** provided that the above copyright notice appear in all copies and
 ** that both that copyright notice and this permission notice appear in
 ** supporting documentation.
 **
 ** In no event shall the author(s) be liable to any party for direct,
 ** indirect, special, incidental, or consequential damages arising out
 ** of the use of this software and its documentation, even if the
 ** authors(s) have been advised of the possibility of such damage.
 **
 ** The authors(s) specifically disclaim any warranties, including but
 ** not limited to, the implied warranties of merchantability and
 ** fitness for a particular purpose.  The software provided hereunder
 ** is on an "as is" basis, and the author(s) have no obligation to
 ** provide maintenance, support, updates, enhancements, or modifications
 ************************************************************************/

static char rcsid[] = "$Header: /home/edsdev/cvstree/tcldev/vwtable/vwTableCommand.c,v 1.2 1994/11/11 21:36:49 aajackso Exp $" ;

/**
 ** $Log: vwTableCommand.c,v $
 * Revision 1.2  1994/11/11  21:36:49  aajackso
 * *** empty log message ***
 *
 * Revision 1.1.1.1  1994/10/21  13:35:26  aajackso
 * Table Widget
 *
 * Revision 1.1  1994/08/24  00:55:59  aaron
 * *** empty log message ***
 *
 * Revision 1.0.0.1  1994/08/18  00:05:48  aaron
 * *** empty log message ***
 *
 * Revision 1.0  1994/08/17  23:54:06  aaron
 * Initial revision
 *
 **/

#include <stdlib.h>

#include <tk.h>
#include <tcl.h>
#include <vwTable.h>

typedef struct CommandArg CommandArg ;
struct         CommandArg
{
  char          *arg ;
  int          (*func) _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
  CommandArg    *subargs ;
  int            n_args ;
};

/************************************************************************
 ** static int
 ** VWT_ParseCommand( VWTable      *table,
 **                   Tcl_Interp   *interp,
 **                   int           argc,
 **                   char         *argv[],
 **                   CommandArg   *cArgs,
 **                   int           nArgs
 **                   int           cArgc )
 **
 **
 ************************************************************************/

#ifdef __STDC__
static int
VWT_ParseCommand( VWTable*                     vwptr,
                  Tcl_Interp*                  interp,
                  int                          argc,
                  char*                        argv[],
                  CommandArg*                  cArgs,
                  int                          nArgs,
                  int                          cArgc )
#else /** __STDC__ **/
static int
VWT_ParseCommand( vwptr, interp, argc, argv, cArgs, nArgs, cArgc )
    VWTable*                     vwptr ;
    Tcl_Interp*                  interp ;
    int                          argc ;
    char*                        argv[] ;
    CommandArg*                  cArgs ;
    int                          nArgs ;
    int                          cArgc ;
#endif /** __STDC__ **/
{
  register int i ;

  for ( i = 0 ; i < nArgs ; i++, cArgs++ )
    {
      if (! strcmp(argv[cArgc], cArgs[0].arg))
	{
	  if (cArgs[0].func == NULL)
	    return VWT_ParseCommand(vwptr, interp, argc, argv,
				    cArgs[0].subargs, cArgs[0].n_args,
				    ++cArgc) ;

	  return cArgs[0].func(vwptr, interp, argc, argv) ;
	}
    }

  Tcl_AppendResult(interp, "Error unable to process option", NULL) ;
  for ( i = 1 ; i < cArgc ; i++ )
    Tcl_AppendResult(interp, " ", argv[i], NULL) ;

  return TCL_ERROR ;
}

/************************************************************************
 ** int
 ** VWT_HandleCommand( ClientData   clientData,
 **                    Tcl_Interp  *interp,
 **                    int          argc,
 **                    char        *argv[] )
 **
 ** Handle commands passed to the widget
 ************************************************************************/

#ifdef __STDC__
int
VWT_HandleCommand( ClientData             clientData,
                   Tcl_Interp*            interp,
                   int                    argc,
                   char*                  argv[] )
#else /** __STDC__ **/
int
VWT_HandleCommand( clientData, interp, argc, argv )
    ClientData             clientData ;
    Tcl_Interp*            interp ;
    int                    argc ;
    char*                  argv[] ;
#endif /** __STDC__ **/
{
  int                result = TCL_OK ;
  VWTable*           vwptr = (VWTable *) clientData ;

#define SubArgs(xx)      NULL, (xx), sizeof(xx)/sizeof(xx[0])

  static CommandArg  popArgs[] =
    { 
      { "color",     VWT_HandlePopColor, },
      { "font",      VWT_HandlePopFont,  },
    };

  static CommandArg  pushArgs[] =
    { 
      { "color",     VWT_HandlePushColor, },
      { "font",      VWT_HandlePushFont,  },
    };

  static CommandArg  clearArgs[] =
    { 
      { "color",     VWT_HandleClearColor, },
      { "font",      VWT_HandleClearFont,  },
    };

  static CommandArg  postArgs[] =
    {
      { "row",       VWT_HandlePostRow },
      { "column",    VWT_HandlePostColumn },
    };

  static CommandArg  hideArgs[] =
    {
      { "row",       VWT_HandleHideRow },
      { "column",    VWT_HandleHideColumn },
    };

  static CommandArg  deleteArgs[] =
    {
      {	"row",       VWT_HandleDeleteRow },
      { "column",    VWT_HandleDeleteColumn },
    };

  static CommandArg  insertArgs[] =
    {
      {	"row",       VWT_HandleInsertRow },
      { "column",    VWT_HandleInsertColumn },
    };

  static CommandArg  focusScanArgs[] =
    {
      { "mark",      VWT_HandleFocusScanMark },
      { "dragto",    VWT_HandleFocusScanDrag },
    };

  static CommandArg  focusSelectArgs[] =
    {
      { "clear",     VWT_HandleFocusSelClear },
      { "from",      VWT_HandleFocusSelFrom },
      { "to",        VWT_HandleFocusSelTo },
    };

  static CommandArg  focusArgs[] =
    {
      { "set",       VWT_HandleFocusSet },
      { "view",      VWT_HandleFocusView },
      { "icursor",   VWT_HandleFocusIcursor },
      { "index",     VWT_HandleFocusIndex },
      { "insert",    VWT_HandleFocusInsert },
      { "delete",    VWT_HandleFocusDelete },
      { "scan",      SubArgs(focusScanArgs) },
      { "select",    SubArgs(focusSelectArgs) },
      { "where",     VWT_HandleFocusWhere },
    };

  static CommandArg  allArgs[] =
    {
      { "info",          VWT_HandleInfo },
      { "focus",         SubArgs(focusArgs) },
      { "pop",           SubArgs(popArgs) },
      { "push",          SubArgs(pushArgs) },
      { "clear",         SubArgs(clearArgs) },
      { "get",           VWT_HandleGet },
      { "set",           VWT_HandleSet },
      { "where",         VWT_HandleWhere },
      { "xview",         VWT_HandleXView },
      { "yview",         VWT_HandleYView },
      { "size",          VWT_HandleSize },
      { "configure",     VWT_HandleConfig },
      { "bind",          VWT_HandleBind },
      { "post",          SubArgs(postArgs) },
      { "hide",          SubArgs(hideArgs) },
      { "delete",        SubArgs(deleteArgs) },
      { "insert",        SubArgs(insertArgs) },
    };

  if ( argc < 2 )
    {
      Tcl_AppendResult(interp,
		       "wrong # args: should be \"",
		       argv[0],
		       " options ? arg arg ...?\"",
		       NULL);

      return TCL_ERROR ;
    }

  Tk_Preserve((ClientData) vwptr);

  result = VWT_ParseCommand(vwptr, interp, argc, argv,
			    allArgs, sizeof(allArgs) / sizeof(allArgs[0]),
			    1) ;

  if (! vwptr->updatePending)
    {
      Tk_DoWhenIdle(VWT_Display, (ClientData) vwptr);
      vwptr->updatePending = 1 ;
    }

  Tk_Release((ClientData) vwptr);
  return result ;
}






