#ifndef VWTableFocus_H
#define VWTableFocus_H

typedef struct VWTableFocus VWTableFocus ;
struct         VWTableFocus
{
  /** State variables **/

  unsigned char        focusing ;       /** Currently focused? **/

  /** Position variables **/

  unsigned int         row ;            /** Row in focus **/
  unsigned int         col ;            /** Column in focus **/
  unsigned int         vpos ;           /** Visible position **/
  unsigned int         curp ;           /** Cursor position **/

  /** Tk variables **/

  Tk_TimerToken        blinkHandler ;   /** Timer handler used to blink **/
                                        /** cursor on and off **/
  int                  onTime ;         /** Number of milliseconds cursor **/
				        /** should spend in "on" state for **/
                                        /** each blink **/
  int                  offTime ;        /** Number of milliseconds cursor **/
				        /** should spend in "off" state for **/
                                        /** each blink **/
  int                  width ;          /** Total width of insert cursor **/
  int                  borderWidth ;    /** Width of 3-D border around
				        /** insert cursor **/
  Tk_3DBorder          background ;     /** Background of the cursor **/
  Tk_3DBorder          selBorder ;      /** Border and background for selections **/
  int                  selBorderWidth ; /** Width of border around selection **/
  XColor              *selFg ;          /** Foreground color for selected text **/

  /** Selection variables **/

  int                  selFrom ;        /** Index of first selected character (-1 means nothing) **/
  int                  selTo ;          /** Index of last selected character (-1 means nothing) **/
  int                  export ;         /** Non-zero means tie internal entry selection to X selection **/

  /** Scan variables **/

  int                  scanMark ;       /** X-position at which scan started */
  int                  scanIndex ;      /** Index of character that was at the left **/
  int                  avgWidth ;       /** Average width of character **/

  /** Allocation variables **/

  char                *data ;           /** Displayed text while in focus mode **/
  int                  len ;            /** Length of data **/
  int                  alloc ;          /** Amount of memory allocated for data **/
};

#endif /** VWTableFocus_H **/
