/************************************************************************
 ** Copyright (c) 1994, Aaron Jackson
 ** All rights reserved
 **
 ** Permission to use, copy, modify, and distribute this software and
 ** its documentation for any purpose and without fee is hereby granted,
 ** provided that the above copyright notice appear in all copies and
 ** that both that copyright notice and this permission notice appear in
 ** supporting documentation.
 **
 ** In no event shall the author(s) be liable to any party for direct,
 ** indirect, special, incidental, or consequential damages arising out
 ** of the use of this software and its documentation, even if the
 ** authors(s) have been advised of the possibility of such damage.
 **
 ** The authors(s) specifically disclaim any warranties, including but
 ** not limited to, the implied warranties of merchantability and
 ** fitness for a particular purpose.  The software provided hereunder
 ** is on an "as is" basis, and the author(s) have no obligation to
 ** provide maintenance, support, updates, enhancements, or modifications
 ************************************************************************/

static char rcsid[] = "$Header: /home/edsdev/cvstree/tcldev/vwtable/vwTableFont.c,v 1.3 1994/11/11 22:35:50 aajackso Exp $" ;

/**
 ** $Log: vwTableFont.c,v $
 * Revision 1.3  1994/11/11  22:35:50  aajackso
 * *** empty log message ***
 *
 * Revision 1.2  1994/11/11  21:36:57  aajackso
 * *** empty log message ***
 *
 * Revision 1.1.1.1  1994/10/21  13:35:28  aajackso
 * Table Widget
 *
 * Revision 1.1  1994/08/24  00:55:59  aaron
 * *** empty log message ***
 *
 * Revision 1.0.0.1  1994/08/18  00:05:48  aaron
 * *** empty log message ***
 *
 * Revision 1.0  1994/08/17  23:54:06  aaron
 * Initial revision
 *
 **/

#include <stdlib.h>
#include <memory.h>

#include <tk.h>
#include <tcl.h>
#include <vwTable.h>
#include <vwTableCell.h>
#include <vwTableFont.h>
#include <vwTableMap.h>

#define VWT_PushFont(vwptr, vwcell, vwfont)   VWStack_Push(&((vwcell)->fonts), vwfont)
#define Allocate_Cell(xx) \
   if ((xx)[0] == NULL) (xx)[0] = (VWTableCell *) calloc(1, sizeof(VWTableCell))

static unsigned long mapping_size = sizeof(Display*) + sizeof(char*) ;

/************************************************************************
 ** VWTableFont*
 ** VWT_GetFont( VWTable       *vwptr,
 **              Tcl_Interp    *interp,
 **              char          *name )
 **
 ** Returns a reference to a structure containing the font information
 ************************************************************************/

#define GetFont(interp, vwptr, name) \
  (((name)[0] == 0x0) ? (NULL) : (Tk_GetFontStruct(interp, (vwptr)->tkWin, (name))))

#ifdef __STDC__
VWTableFont*
VWT_GetFont( VWTable*          vwptr,
             Tcl_Interp*       interp,
             char*             name )
#else /** __STDC__ **/
VWTableFont*
VWT_GetFont( vwptr, interp, name )
    VWTable*          vwptr ;
    Tcl_Interp*       interp ;
    char*             name ;
#endif /** __STDC__ **/
{
  VWTableFont  look ;
  VWTableFont* font ;
  XFontStruct* xfont ;
  Tk_Uid       uid ;

  uid = Tk_GetUid(name) ;
  look.dpy = vwptr->display ;
  look.name = (char *) uid ;

  if (! VWT_FindMapping(&look, mapping_size, (void **) &font))
    {
      if ((xfont = GetFont(interp, vwptr, uid)) == NULL)
	{
	  Tk_FreeFontStruct(xfont) ;
	  return NULL ;
	}

      font = (VWTableFont *) malloc(sizeof(VWTableFont)) ;
      font->dpy = vwptr->display ;
      font->name = (char *) uid ;
      font->namelen = strlen(font->name) ;
      font->references = 0 ;
      font->font = xfont ;
      font->height = (xfont->ascent + xfont->descent) / 2 ;

      VWT_InsertMapping(font, mapping_size, font) ;
    }

  return font ;
}

/************************************************************************
 ** int
 ** VWT_HandlePushFont( VWTable      *vwptr,
 **                     Tcl_Interp   *interp,
 **                      int          argc,
 **                      char        *argv[] )
 **
 ** Pushes a color onto the color stack of cell(s)
 ************************************************************************/

#ifdef __STDC__
int
VWT_HandlePushFont( VWTable*             vwptr,
                    Tcl_Interp*          interp,
                    int                  argc,
                    char*                argv[] )
#else /** __STDC__ **/
int
VWT_HandlePushFont( vwptr, interp, argc, argv )
    VWTable*             vwptr ;
    Tcl_Interp*          interp ;
    int                  argc ;
    char*                argv[] ;
#endif /** __STDC__ **/
{
  int  x, x1, x2 ;
  int  y, y1, y2 ;

  VWTableCell **vwcell ;
  VWTableFont  *vwfont ;

  if (( argc < 6 ) || ( argc == 7 ))
    {
      Tcl_AppendResult(interp, "wrong # args: should be \"",
		       argv[0], " ", argv[1], " ", argv[2],
		       " x1 y1 ? x2 y2 ? font\"",
		       NULL);
      return TCL_ERROR ;
    }

  if (argc == 6)
    {
      if ((VWT_GetBoundingPoint(interp, argv[3], &x, vwptr->columns, TRUE) != TCL_OK) ||
	  (VWT_GetBoundingPoint(interp, argv[4], &y, vwptr->rows, TRUE) != TCL_OK))
	return TCL_ERROR ;

      /** If no cell exists... make one **/

      vwcell = VWMatrixIndex(vwptr->matrix, VWTableCell*, x, y, 0) ;
      Allocate_Cell(vwcell) ;

      vwfont = VWT_GetFont(vwptr, interp, argv[5]) ;
      if (vwfont == NULL)
	return TCL_ERROR ;

      vwfont->references++ ;
      VWT_PushFont(vwptr, vwcell[0], vwfont) ;
      vwcell[0]->changed = TRUE ;
      return TCL_OK ;
    }

  /**
   ** Get the bounding region (x1, y1, x2, y2) to
   ** apply the highlight to
   **/

  if (VWT_GetBoundingBox( interp,
			  vwptr,
			  &x1, &y1,
			  &x2, &y2,
			  &argv[3],
			  TRUE ) != TCL_OK )
    {
      return TCL_ERROR ;
    }

  if (x1 > x2) { int swap ; swap = x1 ; x1 = x2 ; x2 = swap ; }
  if (y1 > y2) { int swap ; swap = y1 ; y1 = y2 ; y2 = swap ; }

  vwfont = VWT_GetFont(vwptr, interp, argv[7]) ;
  if (vwfont == NULL)
    return TCL_ERROR ;

  vwfont->references += (x2 - x1 + 1) * (y2 - y1 + 1) ;

  for ( y = y1 ; y <= y2 ; y++ )
    for ( x = x1 ; x <= x2 ; x++ )
      {
	vwcell = VWMatrixIndex(vwptr->matrix, VWTableCell*, x, y, 0) ;
	Allocate_Cell(vwcell) ;

	VWT_PushFont(vwptr, vwcell[0], vwfont) ;
	vwcell[0]->changed = TRUE ;
      }

  return TCL_OK ;
}

/************************************************************************
 ** int
 ** VWT_PopFont( VWTableCell* vwcell )
 **
 ** Pops a font off the stack.  If the font has no more references
 ** it is freed.  This function returns 1 if a font was popped or
 ** 0 when there is nothing left on the stack
 ************************************************************************/

#ifdef __STDC__
int
VWT_PopFont( VWTableCell*    vwcell )
#else /** __STDC__ **/
int
VWT_PopFont( vwcell )
    VWTableCell*    vwcell ;
#endif /** __STDC__ **/
{
  VWTableFont  *vwfont ;

  if (vwcell == NULL)
    return 0 ;

  vwfont = (VWTableFont *) VWStack_Pop(&(vwcell->fonts)) ;
  if (vwfont == NULL)
    return TCL_OK ;
      
  vwfont->references-- ;
  if (! vwfont->references)
    {
      VWT_RemoveMapping(vwfont, mapping_size, NULL) ;
      Tk_FreeFontStruct(vwfont->font) ;
      free((char *) vwfont) ;
    }

  vwcell->changed = TRUE ;
  return 1 ;
}

/************************************************************************
 ** int
 ** VWT_HandlePopFont( VWTable     *vwptr,
 **                     Tcl_Interp  *interp,
 **                     int          argc,
 **                     char        *argv[] )
 **
 ** Pops a font off of the font stack of cell(s)
 ************************************************************************/

#ifdef __STDC__
int
VWT_HandlePopFont( VWTable*             vwptr,
                   Tcl_Interp*          interp,
                   int                  argc,
                   char*                argv[] )
#else /** __STDC__ **/
int
VWT_HandlePopFont( vwptr, interp, argc, argv )
    VWTable*             vwptr ;
    Tcl_Interp*          interp ;
    int                  argc ;
    char*                argv[] ;
#endif /** __STDC__ **/
{
  int  x, x1, x2 ;
  int  y, y1, y2 ;

  if (( argc < 5 ) || ( argc == 6 ))
    {
      Tcl_AppendResult(interp, "wrong # args: should be \"",
		       argv[0], " ", argv[1], " ", argv[2],
		       " x1 y1 ? x2 y2 ?\"",
		       NULL);
      return TCL_ERROR ;
    }

  if (argc == 5)
    {
      if ((VWT_GetBoundingPoint(interp, argv[3], &x, vwptr->columns, TRUE) != TCL_OK) ||
	  (VWT_GetBoundingPoint(interp, argv[4], &y, vwptr->rows, TRUE) != TCL_OK))
	return TCL_ERROR ;
      
      VWT_PopFont(*VWMatrixIndex(vwptr->matrix, VWTableCell*, x, y, 0)) ;
      return TCL_OK ;
    }

  /**
   ** Get the bounding region (x1, y1, x2, y2) to
   ** apply the highlight to
   **/

  if (VWT_GetBoundingBox( interp,
			  vwptr,
			  &x1, &y1,
			  &x2, &y2,
			  &argv[3],
			  TRUE ) != TCL_OK )
    {
      return TCL_ERROR ;
    }

  if (x1 > x2) { int swap ; swap = x1 ; x1 = x2 ; x2 = swap ; }
  if (y1 > y2) { int swap ; swap = y1 ; y1 = y2 ; y2 = swap ; }

  for ( y = y1 ; y <= y2 ; y++ )
    for ( x = x1 ; x <= x2 ; x++ )
      {
	VWT_PopFont(*VWMatrixIndex(vwptr->matrix, VWTableCell*, x, y, 0)) ;
      }

  return TCL_OK ;
}

/************************************************************************
 ** int
 ** VWT_HandleClearFont( VWTable     *vwptr,
 **                       Tcl_Interp  *interp,
 **                       int          argc,
 **                       char        *argv[] )
 **
 ** The font is GONE!
 ************************************************************************/

#ifdef __STDC__
int
VWT_HandleClearFont( VWTable*             vwptr,
                     Tcl_Interp*          interp,
                     int                  argc,
                     char*                argv[] )
#else /** __STDC__ **/
int
VWT_HandleClearFont( vwptr, interp, argc, argv )
    VWTable*             vwptr ;
    Tcl_Interp*          interp ;
    int                  argc ;
    char*                argv[] ;
#endif /** __STDC__ **/
{
  int  x, x1, x2 ;
  int  y, y1, y2 ;

  VWTableCell *vwcell ;

  if (( argc < 5 ) || ( argc == 6 ))
    {
      Tcl_AppendResult(interp, "wrong # args: should be \"",
		       argv[0], " ", argv[1], " ", argv[2],
		       " x1 y1 ? x2 y2 ?\"",
		       NULL);
      return TCL_ERROR ;
    }

  if ( argc == 5 )
    {
      if ((VWT_GetBoundingPoint(interp, argv[3], &x, vwptr->columns, TRUE) != TCL_OK) ||
	  (VWT_GetBoundingPoint(interp, argv[4], &y, vwptr->rows, TRUE) != TCL_OK))
	return TCL_ERROR ;
      
      vwcell = *VWMatrixIndex(vwptr->matrix, VWTableCell*, x, y, 0) ;
      while (VWT_PopFont(vwcell)) ;
      return TCL_OK ;
    }

  /**
   ** Get the bounding region (x1, y1, x2, y2) to
   ** apply the highlight to
   **/

  if (VWT_GetBoundingBox( interp,
			  vwptr,
			  &x1, &y1,
			  &x2, &y2,
			  &argv[3],
			  TRUE ) != TCL_OK )
    {
      return TCL_ERROR ;
    }

  if (x1 > x2) { int swap ; swap = x1 ; x1 = x2 ; x2 = swap ; }
  if (y1 > y2) { int swap ; swap = y1 ; y1 = y2 ; y2 = swap ; }

  for ( y = y1 ; y <= y2 ; y++ )
    for ( x = x1 ; x <= x2 ; x++ )
      {
	vwcell = *VWMatrixIndex(vwptr->matrix, VWTableCell*, x, y, 0) ;
	while (VWT_PopFont(vwcell)) ;
      }

  return TCL_OK ;
}

