/************************************************************************
 ** Copyright (c) 1994, Aaron Jackson
 ** All rights reserved
 **
 ** Permission to use, copy, modify, and distribute this software and
 ** its documentation for any purpose and without fee is hereby granted,
 ** provided that the above copyright notice appear in all copies and
 ** that both that copyright notice and this permission notice appear in
 ** supporting documentation.
 **
 ** In no event shall the author(s) be liable to any party for direct,
 ** indirect, special, incidental, or consequential damages arising out
 ** of the use of this software and its documentation, even if the
 ** authors(s) have been advised of the possibility of such damage.
 **
 ** The authors(s) specifically disclaim any warranties, including but
 ** not limited to, the implied warranties of merchantability and
 ** fitness for a particular purpose.  The software provided hereunder
 ** is on an "as is" basis, and the author(s) have no obligation to
 ** provide maintenance, support, updates, enhancements, or modifications
 ************************************************************************/

static char rcsid[] = "$Header: /home/edsdev/cvstree/tcldev/vwtable/vwTableHide.c,v 1.2 1994/10/25 21:10:05 aajackso Exp $" ;

/**
 ** $Log: vwTableHide.c,v $
 * Revision 1.2  1994/10/25  21:10:05  aajackso
 * Oops, added __STDC__ code for most source code and changed the Makefile
 * so that it was consistent w/ the new files
 *
 * Revision 1.1.1.1  1994/10/21  13:35:22  aajackso
 * Table Widget
 *
 **/

#include <vwTable.h>
#include <vwTableImage.h>

/************************************************************************
 ** int
 ** VWT_HandleHideRow( VWTable     *vwptr,
 **                    Tcl_Interp  *interp,
 **                    int          argc,
 **                    char        *argv[] )
 **
 ** Hide a row on screen
 ************************************************************************/

#ifdef __STDC__
int
VWT_HandleHideRow( VWTable*             vwptr,
                   Tcl_Interp*          interp,
                   int                  argc,
                   char*                argv[] )
#else /** __STDC__ **/
int
VWT_HandleHideRow( vwptr, interp, argc, argv )
    VWTable*             vwptr ;
    Tcl_Interp*          interp ;
    int                  argc ;
    char*                argv[] ;
#endif /** __STDC__ **/
{
  VWTableImageElement *element ;

  int          error ;
  int          row ;
  int          bool ;

  if (argc != 5)
    {
      Tcl_AppendResult(interp, "wrong # args: should be \"",
		       argv[0], " ", argv[1], " ", argv[2],
		       " row boolean\"",
		       NULL);
      return TCL_ERROR ;
    }

  if (((error = Tcl_GetInt(interp, argv[3], &row)) != TCL_OK) ||
      ((error = Tcl_GetBoolean(interp, argv[4], &bool)) != TCL_OK))
    return error ;

  if (bool)
    {
      element = VWT_FindElementByPosition(vwptr->image.elements[VWT_Vertical], row) ;
      if (element && element->posted)
	element->posted = FALSE ;

      VWBit_Set(&vwptr->hide[VWT_Vertical], row) ;
      VWBit_Clr(&vwptr->image.posts[VWT_Vertical], row) ;
    }
  else
    {
      VWBit_Clr(&vwptr->hide[VWT_Vertical], row) ;
    }

  return TCL_OK ;
}

/************************************************************************
 ** int
 ** VWT_HandleHideColumn( VWTable     *vwptr,
 **                       Tcl_Interp  *interp,
 **                       int          argc,
 **                       char        *argv[] )
 **
 ** Hide a column on screen
 ************************************************************************/

#ifdef __STDC__
int
VWT_HandleHideColumn( VWTable*             vwptr,
                      Tcl_Interp*          interp,
                      int                  argc,
                      char*                argv[] )
#else /** __STDC__ **/
int
VWT_HandleHideColumn( vwptr, interp, argc, argv )
    VWTable*             vwptr ;
    Tcl_Interp*          interp ;
    int                  argc ;
    char*                argv[] ;
#endif /** __STDC__ **/
{
  VWTableImageElement *element ;

  int          error ;
  int          col ;
  int          bool ;

  if (argc != 5)
    {
      Tcl_AppendResult(interp, "wrong # args: should be \"",
		       argv[0], " ", argv[1], " ", argv[2],
		       " col boolean\"",
		       NULL);
      return TCL_ERROR ;
    }

  if (((error = Tcl_GetInt(interp, argv[3], &col)) != TCL_OK) ||
      ((error = Tcl_GetBoolean(interp, argv[4], &bool)) != TCL_OK))
    return error ;

  if (bool)
    {
      element = VWT_FindElementByPosition(vwptr->image.elements[VWT_Horizontal], col) ;
      if (element && element->posted)
	element->posted = FALSE ;

      VWBit_Set(&vwptr->hide[VWT_Horizontal], col) ;
      VWBit_Clr(&vwptr->image.posts[VWT_Horizontal], col) ;
    }
  else
    {
      VWBit_Clr(&vwptr->hide[VWT_Horizontal], col) ;
    }

  return TCL_OK ;
}
