#ifndef VWTableImage_H
#define VWTableImage_H

#include <vwBits.h>
#include <vwTableImageElem.h>

typedef struct VWTableImage VWTableImage ;
struct         VWTableImage
{
  Pixmap               pixmap ;
  unsigned int         width ;
  unsigned int         height ;

  VWBitset             posts[2] ;       /* Indicator if row is posted (minimum of 1 post) */
  VWTableImageElement *elements[2] ;
};

EXTERN VWTableImageElement* VWT_AllocElement          _ANSI_ARGS_(()) ;
EXTERN VWTableImageElement* VWT_FindElementAtPixel    _ANSI_ARGS_((VWTableImageElement*, int)) ;
EXTERN VWTableImageElement* VWT_FindElementByPixel    _ANSI_ARGS_((VWTableImageElement*, int)) ;
EXTERN VWTableImageElement* VWT_FindElementByPosition _ANSI_ARGS_((VWTableImageElement*, int)) ;

EXTERN void VWT_FreeElement        _ANSI_ARGS_((VWTableImageElement*)) ;
EXTERN void VWT_InsertElement      _ANSI_ARGS_((VWTableImageElement**, VWTableImageElement*, int)) ;
EXTERN void VWT_RemoveElement      _ANSI_ARGS_((VWTableImageElement**, VWTableImageElement*)) ;
EXTERN void VWT_CalibrateDimension _ANSI_ARGS_((VWTableImageElement**, VWBitset*, VWBitset*, int, int, int*, int, int)) ;
EXTERN void VWT_CalibrateImage     _ANSI_ARGS_((VWTable*, VWTableImage*)) ;
EXTERN void VWT_FreeElementList    _ANSI_ARGS_((VWTableImageElement*)) ;

EXTERN void VWT_FlushImage _ANSI_ARGS_((VWTableImage*)) ;
EXTERN void VWT_CopyImage  _ANSI_ARGS_((VWTableImage*, VWTableImage*)) ;

#endif /** VWTableImage_H **/
