/************************************************************************
 ** Copyright (c) 1994, Aaron Jackson
 ** All rights reserved
 **
 ** Permission to use, copy, modify, and distribute this software and
 ** its documentation for any purpose and without fee is hereby granted,
 ** provided that the above copyright notice appear in all copies and
 ** that both that copyright notice and this permission notice appear in
 ** supporting documentation.
 **
 ** In no event shall the author(s) be liable to any party for direct,
 ** indirect, special, incidental, or consequential damages arising out
 ** of the use of this software and its documentation, even if the
 ** authors(s) have been advised of the possibility of such damage.
 **
 ** The authors(s) specifically disclaim any warranties, including but
 ** not limited to, the implied warranties of merchantability and
 ** fitness for a particular purpose.  The software provided hereunder
 ** is on an "as is" basis, and the author(s) have no obligation to
 ** provide maintenance, support, updates, enhancements, or modifications
 ************************************************************************/

static char rcsid[] = "$Header: /home/edsdev/cvstree/tcldev/vwtable/vwTableVisible.c,v 1.1.1.1 1994/10/21 13:35:24 aajackso Exp $" ;

/**
 ** $Log: vwTableVisible.c,v $
 * Revision 1.1.1.1  1994/10/21  13:35:24  aajackso
 * Table Widget
 *
 * Revision 1.1  1994/08/24  00:55:59  aaron
 * *** empty log message ***
 *
 * Revision 1.0  1994/08/17  23:54:06  aaron
 * Initial revision
 *
 **/

#include <tk.h>
#include <tcl.h>

#include <vwTable.h>

/************************************************************************
 ** int
 ** VWT_VisibleRows( VWTable *vwptr )
 **
 ** Determines the number of visible rows
 ************************************************************************/

#ifdef __STDC__
int
VWT_VisibleRows( VWTable*    vwptr )
#else /** __STDC__ **/
int
VWT_VisibleRows( vwptr )
    VWTable*    vwptr ;
#endif /** __STDC__ **/
{
  register int i ;
  register int rows ;
  register int height ;
  register int yposition ;

  rows = 0 ;
  height = Tk_Height( vwptr->tkWin ) - vwptr->borderWidth ;
  yposition = vwptr->borderWidth ;

  for ( i = vwptr->vrow ;
        i < vwptr->rows ;
        i++ )
    {
      if (yposition > height)
	break ;

      rows++ ;
      yposition += vwptr->rowHeight[i] ;
    }

  return( rows ) ;
}

/************************************************************************
 ** int
 ** VWT_VisibleColumns( VWTable*  vwptr )
 **
 ** Determines the number of visible columns
 ************************************************************************/

#ifdef __STDC__
int 
VWT_VisibleColumns( VWTable*    vwptr )
#else /** __STDC__ **/
int 
VWT_VisibleColumns( vwptr )
    VWTable*    vwptr ;
#endif /** __STDC__ **/
{
  register int i ;
  register int cols ;
  register int width ;
  register int xposition ;

  cols = 0 ;
  width = Tk_Width( vwptr->tkWin ) - vwptr->borderWidth ;
  xposition = vwptr->borderWidth ;

  for ( i = vwptr->vcolumn ;
        i < vwptr->columns ;
        i++ )
    {
      if (xposition > width)
	break ;

      cols++ ;
      xposition += vwptr->columnWidth[i] ;
    }

  return( cols );
}
