'\"
'\"Copyright (c) 1994, Aaron Jackson
'\"All rights reserved
'\"
'\"Permission to use, copy, modify, and distribute this software and
'\"its documentation for any purpose and without fee is hereby granted,
'\"provided that the above copyright notice appear in all copies and
'\"that both that copyright notice and this permission notice appear in
'\"supporting documentation.
'\"
'\"In no event shall the author(s) be liable to any party for direct,
'\"indirect, special, incidental, or consequential damages arising out
'\"of the use of this software and its documentation, even if the
'\"authors(s) have been advised of the possibility of such damage.
'\"
'\"The authors(s) specifically disclaim any warranties, including but
'\"not limited to, the implied warranties of merchantability and
'\"fitness for a particular purpose.  The software provided hereunder
'\"is on an "as is" basis, and the author(s) have no obligation to
'\"provide maintenance, support, updates, enhancements, or modifications
'/" 
.so man.macros
.HS vwtable tk
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
vwtable \- Create and manipulate vwtable widgets
.SH SYNOPSIS
\fBvwtable\fI \fIpathName \fR?\fIoptions\fR?
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.VS
\fBbackground\fR	\fBforeground\fR	\fBselectBackground\fR	\fBxScrollCommand\fR
\fBborderWidth\fR	\fBfont\fR	\fBselectBorderWidth\fR	\fByScrollCommand\fR
\fBcursor\fR	\fBgeometry\fR	\fBselectForeground\fR
\fBexportSelection\fR	\fBrelief\fR
.VE
.fi
.LP
See the ``options'' manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.ta 4c
.LP
None.
.BE

.SH DESCRIPTION
.PP
The \fBvwtable\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a vwtable widget.
Additional
options, described above, may be specified on the command line
or in the option database
to configure aspects of the vwtable such as its colors, font,
text, and relief.  The \fBvwtable\fR command returns its
\fIpathName\fR argument.  At the time this command is invoked,
there must not exist a window named \fIpathName\fR, but
\fIpathName\fR's parent must exist.
.PP
A vwtable is a widget that displays a matrix of strings, bitmaps,
etc.  When first created, a new vwtable has no cells filled.
Cells may be set using the widget commands described below.  In
addition, regions of cells may be specified as described below.
.PP
At any given time only a viewport is available for view.  The
view may be changed using the commands described below.  Vwtable
allow scrolling in both directions using the standard \fBxScrollCommand\fR
and \fByScrollCommand\fR options.

.SH "WIDGET COMMAND"
.PP
The \fBvwtable\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for vwtable widgets:
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBvwtable\fR
command.
.TP
\fIpathName \fBbind\fR ?\fIvarName\fR?
Binds varName to the data in the widget.  The caller can use array
indexing to access specific cells of the widget.  e.g. foo(\fI0,1\fR).
If no varName is given the varName currently bound is returned.
.TP
\fIpathName \fBdelete\fR \fIaxis index elements\fR
Deletes <elements> rows/columns from the appropriate axis \fBat\fR
\fIindex\fR.  The appropriate xScrollCmd and yScrollCmd are called if
available.
.TP
\fIpathName \fBinsert \fIaxis index elements\fR
Inserts <elements> rows/columns onto the appropriate axis \fBbefore\fR
\fIindex\fR.  The appropriate xScrollCmd and yScrollCmd are called if
available.
.TP
\fIpathName \fBhide \fIaxis \fIindex boolean\fR
Hides or unhides the row/column indicated by \fIindex\fB.
.TP
\fIpathName \fBfocus \fIoption ? arg ... ?\fR
This command is used to change the characteristics of cell focus.
.RS
.TP
\fIpathName \fBfocus set ? \fIx y\fR ?
This command, when used with \fIx\fR and \fIy\fR, will change the
focus to the cell identified by \fIx\fR and \fIy\fR.  If no cell is
specified, focus is remove.
.TP
\fIpathName \fBfocus delete \fIfirst \fR?\fIlast\fR?
Delete one or more elements of the cell.  \fIFirst\fR and \fIlast\fR
are indices of of the first and last characters in the range to
be deleted.   If \fIlast\fR isn't specified it defaults to
\fIfirst\fR, i.e. a single character is deleted.  This command
returns an empty string.
.TP
\fIpathName \fBfocus get\fR
Returns the cell's string.
.TP
\fIpathName \fBfocus icursor \fIindex\fR
Arrange for the insertion cursor to be displayed just before the
character given by \fIindex\fR.  Returns an empty string.
.TP
\fIpathName \fBfocus index \fIindex\fR
Returns the numerical index corresponding to \fIindex\fR.
.TP
\fIpathName \fBfocus insert \fIindex string\fR
Insert the characters of \fIstring\fR just before the character
indicated by \fIindex\fR.  Returns an empty string.
.TP
\fIpathName \fBfocus scan\fR \fIoption args\fR
This command is used to implement scanning on entries.  It has
two forms, depending on \fIoption\fR:
.RS
.TP
\fIpathName \fBfocus scan mark \fIx\fR
Records \fIx\fR and the current view in the cell window;  used in
conjunction with later \fBscan dragto\fR commands.  Typically this
command is associated with a mouse button press in the widget.  It
returns an empty string.
.TP
\fIpathName \fBfocus scan dragto \fIx\fR
This command computes the difference between its \fIx\fR argument
and the \fIx\fR argument to the last \fBscan mark\fR command for
the widget.  It then adjusts the view left or right by 10 times the
difference in x-coordinates.  This command is typically associated
with mouse motion events in the widget, to produce the effect of
dragging the cell at high speed through the window.  The return
value is an empty string.
.RE
.TP
\fIpathName \fBfocus select \fIoption arg\fR
This command is used to adjust the selection within an cell.  It
has several forms, depending on \fIoption\fR:
.RS
.TP
\fIpathName \fBfocus select clear\fR
Clear the selection if it is currently in this widget.  If the
selection isn't in this widget then the command has no effect.
Returns an empty string.
.TP
\fIpathName \fBfocus select from \fIindex\fR
Set the selection anchor point to just before the character
given by \fIindex\fR.  Doesn't change the selection.
Returns an empty string.
.TP
\fIpathName \fBfocus select to \fIindex\fR
Set the selection to consist of the elements from the anchor
point to element \fIindex\fR, inclusive.  The anchor point is
determined by the most recent \fBselect from\fR or \fBselect adjust\fR
command in this widget.  If the selection isn't in this widget
then a new selection is created using the most recent anchor point
specified for the widget.  Returns an empty string.
.RE
.TP
\fIpathName \fBfocus view \fIindex\fR
Adjust the view in the cell so that element \fIindex\fR is
at the left edge of the window.  Returns an empty string.
.RE
.TP
\fIpathName \fBpost \fIaxis \fIindex pixel\fR
Posts the row/column indicated by \fIindex\fB at \fIpixel\fB.  This is
useful for headers.  Presently, negative numbers are not allowed but
future releases will allow them for trailers.
.TP
\fIpathName \fBpop \fIstack x1 y1 ? x2 y2 ?\fR
This command is used to pop information off of the cell stacks.  The
valid stacks for this command are color and font.
.TP
\fIpathName \fBclear \fIstack x1 y1 ? x2 y2 ?\fR
This command is used to clear information off of the cell stacks.  The
valid stacks for this command are color and font.
.TP
\fIpathName \fBpush \fIstack x1 y1 ? x2 y2 args args ... ? \fR
This command is used to push information onto the cell stacks.  The
valid stacks for this command are color and font.  A color stack
requires a foreground and a background color.  A font stack requires a
valid font.  An exception occurs if the requested operation cannot be
performed.
.RS
.TP
\fIpathName \fBpush \fIcolor x1 y1 ? x2 y2 ? foreground background\fR
.TP
\fIpathName \fBpush \fIfont x1 y1 ? x2 y2 ? fontname\fR
.RE
.TP
\fIpathName \fBget \fIx1 y1 ? x2 y2 ?\fR 
Returns the contents of the \fBregion\fR requested by \fIx1 y1 ? x2 y2
?\fR.  If one cell is requested (i.e. only \fIx1\fR and \fIx2\fR are
specified) then only one cell specification shall be returned.  If a
\fBregion\fR is requested then a list of cell specifications shall be
returned.
.TP
\fIpathName \fBset \fIx1 y1 ? x2 y2 ? specification\fR 
Changes the contents of a \fBregion\fR requested by \fIx1 y1 ? x2 y2
?\fR.  If one cell is requested (i.e. only \fIx1\fR and \fIx2\fR are
specified) then only one cell specification is required.  If a
\fBregion\fR is requested then a list of cell specifications is
required.
.sp1
A cell specification is one of the following forms:
.sp1
{ TEXT <anchor> "data" }
.sp 0
{ BITMAP <anchor> "data" }
.sp1
A list of specifications is actually a list of lists.  The outer lists represent rows in the region while the inner lists represent the columns of the matrix.  An example without real specifications would look as follows:
.sp1
{
.sp0
{{ TEXT n "a" } { TEXT center "b" } {}}
.sp0
{{ TEXT s "1" } { BITMAP nw "@ab" } { TEXT e "test }}
.sp0
{{ TEXT w "2" } { BITMAP sw "@bc" } {}}
.sp0
}
.VE
.TP
\fIpathName \fBxview \fIindex\fR
Adjust the view in the vwtable so that column \fIindex\fR is displayed
at the left edge of the widget.  If \fIindex\fR is specified as
\fB@end\fR it indicates the last column of the vwtable.  Returns an
empty string.
.TP
\fIpathName \fByview \fIindex\fR
Adjust the view in the vwtable so that row \fIindex\fR is displayed at
the top of the widget.  If \fIindex\fR is specified as \fB@end\fR it
indicates the last row of the vwtable.  Returns an empty string.
.TP
\fIpathName \fBwhere \fIx y\fR
Informs the users about the cell at x y.  It returns a list containing
column, row, column pixel, row pixel, column width, row height.  If
the row or column are invalid the row and/or column are returned as
-1.  Likewise the corresponding pixel is returned as -1.
.sp 1
\fIHint\fR: This is useful for people who want to resize columns and rows.
It first gives the user the column and row and then allows the user to
know how far from the leading edge they were.
.TP
\fIpathName \fBinfo \fIx y\fR
This function returns information about the position \fIx y\fR.  The
return will be one of the following:
.RS
.RS
.sp 1
none
.sp 0
space
.sp 0
focus
.sp 0
bd-left
.sp 0
bd-right
.sp 0
bd-right-left
.sp 0
bd-top
.sp 0
bd-top-left
.sp 0
bd-top-right
.sp 0
bd-top-right-left
.sp 0
bd-bottom
.sp 0
bd-bottom-left
.sp 0
bd-bottom-right
.sp 0
bd-bottom-right-left
.sp 0
bd-bottom-top
.sp 0
bd-bottom-top-left
.sp 0
bd-bottom-top-right
.sp 0
bd-bottom-top-right-left
.RE
.RE
.TP
\fipathName \fBsize \fIx y ? width height ?\fR
Changes the size of a cell.  Changes to a cell's size will affect the
cell's column and row size.  If no \fIwidth\fR or \fIheight\fR are
specified they are returned.  The \fIwidth\fR and \fIheight\fR should
be specified in pixels.  If \fIwidth\fR or \fIheight\fR are specified
as \fB@current\fR the size will remain unchanged.  If the cell size is
changed, nothing is returned.
.SH KEYWORDS
vwtable, widget











