'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994-1995 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) expr.n 1.9 95/02/22 14:37:23
'\" 
.so man.macros
.HS expr tcl 7.4
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
expr \- Evaluate an expression
.SH SYNOPSIS
\fBexpr \fIarg \fR?\fIarg arg ...\fR?
.BE

.SH DESCRIPTION
.PP
.VS
Concatenates \fIarg\fR's (adding separator spaces between them),
evaluates the result as a Tcl expression, and returns the value.
.VE
The operators permitted in Tcl expressions are a subset of
the operators permitted in C expressions, and they have the
same meaning and precedence as the corresponding C operators.
Expressions almost always yield numeric results
(integer or floating-point values).
For example, the expression
.DS
\fBexpr 8.2 + 6\fR
.DE
evaluates to 14.2.
Tcl expressions differ from C expressions in the way that
operands are specified.  Also, Tcl expressions support
non-numeric operands and string comparisons.
.SH OPERANDS
.PP
A Tcl expression consists of a combination of operands, operators,
and parentheses.
White space may be used between the operands and operators and
parentheses; it is ignored by the expression processor.
Where possible, operands are interpreted as integer values.
Integer values may be specified in decimal (the normal case), in octal (if the
first character of the operand is \fB0\fR), or in hexadecimal (if the first
two characters of the operand are \fB0x\fR).
If an operand does not have one of the integer formats given
above, then it is treated as a floating-point number if that is
possible.  Floating-point numbers may be specified in any of the
ways accepted by an ANSI-compliant C compiler (except that the
``f'', ``F'', ``l'', and ``L'' suffixes will not be permitted in
most installations).  For example, all of the
following are valid floating-point numbers:  2.1, 3., 6e4, 7.91e+16.
If no numeric interpretation is possible, then an operand is left
as a string (and only a limited set of operators may be applied to
it).
.PP
Operands may be specified in any of the following ways:
.IP [1]
As an numeric value, either integer or floating-point.
.IP [2]
As a Tcl variable, using standard \fB$\fR notation.
The variable's value will be used as the operand.
.IP [3]
As a string enclosed in double-quotes.
The expression parser will perform backslash, variable, and
command substitutions on the information between the quotes,
and use the resulting value as the operand
.IP [4]
As a string enclosed in braces.
The characters between the open brace and matching close brace
will be used as the operand without any substitutions.
.IP [5]
As a Tcl command enclosed in brackets.
The command will be executed and its result will be used as
the operand.
.IP [6]
.VS
As a mathematical function whose arguments have any of the above
forms for operands, such as ``\fBsin($x)\fR''.  See below for a list of defined
functions.
.VE
.LP
Where substitutions occur above (e.g. inside quoted strings), they
are performed by the expression processor.
However, an additional layer of substitution may already have
been performed by the command parser before the expression
processor was called.
As discussed below, it is usually best to enclose expressions
in braces to prevent the command parser from performing substitutions
on the contents.
.PP
For some examples of simple expressions, suppose the variable
\fBa\fR has the value 3 and
the variable \fBb\fR has the value 6.
Then the command on the left side of each of the lines below
will produce the value on the right side of the line:
.DS
.ta 6c
\fBexpr 3.1 + $a	6.1
expr 2 + "$a.$b"	5.6
expr 4*[llength "6 2"]	8
expr {{word one} < "word $a"}	0\fR
.DE
.SH OPERATORS
.PP
The valid operators are listed below, grouped in decreasing order
of precedence:
.TP 20
\fB\-\0\0+\0\0~\0\0!\fR
.VS
Unary minus, unary plus, bit-wise NOT, logical NOT.  None of these operands
.VE
may be applied to string operands, and bit-wise NOT may be
applied only to integers.
.TP 20
\fB*\0\0/\0\0%\fR
Multiply, divide, remainder.  None of these operands may be
applied to string operands, and remainder may be applied only
to integers.
.VS
The remainder will always have the same sign as the divisor and
an absolute value smaller than the divisor.
.VE
.TP 20
\fB+\0\0\-\fR
Add and subtract.  Valid for any numeric operands.
.TP 20
\fB<<\0\0>>\fR
Left and right shift.  Valid for integer operands only.
.TP 20
\fB<\0\0>\0\0<=\0\0>=\fR
Boolean less, greater, less than or equal, and greater than or equal.
Each operator produces 1 if the condition is true, 0 otherwise.
These operators may be applied to strings as well as numeric operands,
in which case string comparison is used.
.TP 20
\fB==\0\0!=\fR
Boolean equal and not equal.  Each operator produces a zero/one result.
Valid for all operand types.
.TP 20
\fB&\fR
Bit-wise AND.  Valid for integer operands only.
.TP 20
\fB^\fR
Bit-wise exclusive OR.  Valid for integer operands only.
.TP 20
\fB|\fR
Bit-wise OR.  Valid for integer operands only.
.TP 20
\fB&&\fR
Logical AND.  Produces a 1 result if both operands are non-zero, 0 otherwise.
Valid for numeric operands only (integers or floating-point).
.TP 20
\fB||\fR
Logical OR.  Produces a 0 result if both operands are zero, 1 otherwise.
Valid for numeric operands only (integers or floating-point).
.TP 20
\fIx\fB?\fIy\fB:\fIz\fR
If-then-else, as in C.  If \fIx\fR
evaluates to non-zero, then the result is the value of \fIy\fR.
Otherwise the result is the value of \fIz\fR.
The \fIx\fR operand must have a numeric value.
.LP
See the C manual for more details on the results
produced by each operator.
All of the binary operators group left-to-right within the same
precedence level.  For example, the command
.DS
\fBexpr 4*2 < 7\fR
.DE
returns 0.
.PP
The \fB&&\fP, \fB||\fP, and \fB?:\fP operators have ``lazy
evaluation'', just as in C, 
which means that operands are not evaluated if they are
not needed to determine the outcome.  For example, in the command
.DS
\fBexpr {$v ? [a] : [b]}\fR
.DE
only one of \fB[a]\fR or \fB[b]\fR will actually be evaluated,
depending on the value of \fB$v\fP.  Note, however, that this is
only true if the entire expression is enclosed in braces;  otherwise
the Tcl parser will evaluate both \fB[a]\fR and \fB[b]\fR before
invoking the \fBexpr\fR command.
.SH "MATH FUNCTIONS"
.PP
.VS
Tcl supports the following mathematical functions in expressions:
.DS
.ta 3c 6c 9c
\fBacos\fR	\fBcos\fR	\fBhypot\fR	\fBsinh\fR
\fBasin\fR	\fBcosh\fR	\fBlog\fR	\fBsqrt\fR
\fBatan\fR	\fBexp\fR	\fBlog10\fR	\fBtan\fR
\fBatan2\fR	\fBfloor\fR	\fBpow\fR	\fBtanh\fR
\fBceil\fR	\fBfmod\fR	\fBsin\fR
.DE
Each of these functions invokes the math library function of the same
name;  see the manual entries for the library functions for details
on what they do.  Tcl also implements the following functions for
conversion between integers and floating-point numbers:
.TP
\fBabs(\fIarg\fB)\fI
Returns the absolute value of \fIarg\fR.  \fIArg\fR may be either
integer or floating-point, and the result is returned in the same form.
.TP
\fBdouble(\fIarg\fB)\fR
If \fIarg\fR is a floating value, returns \fIarg\fR, otherwise converts
\fIarg\fR to floating and returns the converted value.
.TP
\fBint(\fIarg\fB)\fR
If \fIarg\fR is an integer value, returns \fIarg\fR, otherwise converts
\fIarg\fR to integer by truncation and returns the converted value.
.TP
\fBround(\fIarg\fB)\fR
If \fIarg\fR is an integer value, returns \fIarg\fR, otherwise converts
\fIarg\fR to integer by rounding and returns the converted value.
.PP
In addition to these predefined functions, applications may
define additional functions using \fBTcl_CreateMathFunc\fR().
.VE
.SH "TYPES, OVERFLOW, AND PRECISION"
.PP
All internal computations involving integers are done with the C type
\fIlong\fP, and all internal computations involving floating-point are
done with the C type \fIdouble\fP.
When converting a string to floating-point, exponent overflow is
detected and results in a Tcl error.
For conversion to integer from string, detection of overflow depends
on the behavior of some routines in the local C library, so it should
be regarded as unreliable.
In any case, integer overflow and underflow are generally not detected
reliably for intermediate results.  Floating-point overflow and underflow
are detected to the degree supported by the hardware, which is generally
pretty reliable.
.PP
Conversion among internal representations for integer, floating-point,
and string operands is done automatically as needed.
For arithmetic computations, integers are used until some
floating-point number is introduced, after which floating-point is used.
For example,
.DS
\fBexpr 5 / 4\fR
.DE
returns 1, while
.DS
\fBexpr 5 / 4.0\fR
\fBexpr 5 / ( [string length "abcd"] + 0.0 )
.DE
both return 1.25.
.VS
Floating-point values are always returned with a ``.''
or an ``e'' so that they will not look like integer values.  For
example,
.DS
\fBexpr 20.0/5.0\fR
.DE
returns ``4.0'', not ``4''.  The global variable \fBtcl_precision\fR
determines the the number of significant digits that are retained
when floating values are converted to strings (except that trailing
zeroes are omitted).  If \fBtcl_precision\fR
is unset then 6 digits of precision are used.
To retain all of the significant bits of an IEEE floating-point
number set \fBtcl_precision\fR to 17;  if a value is converted to
string with 17 digits of precision and then converted back to binary
for some later calculation, the resulting binary value is guaranteed
to be identical to the original one.
.VE

.SH "STRING OPERATIONS"
.PP
String values may be used as operands of the comparison operators,
although the expression evaluator tries to do comparisons as integer
or floating-point when it can.
If one of the operands of a comparison is a string and the other
has a numeric value, the numeric operand is converted back to
a string using the C \fIsprintf\fP format specifier
\fB%d\fR for integers and \fB%g\fR for floating-point values.
For example, the commands
.DS
\fBexpr {"0x03" > "2"}\fR
\fBexpr {"0y" < "0x12"}\fR
.DE
both return 1.  The first comparison is done using integer
comparison, and the second is done using string comparison after
the second operand is converted to the string ``18''.
.VS
Because of Tcl's tendency to treat values as numbers whenever
possible, it isn't generally a good idea to operators like \fB==\fR
when you really want string comparison and the values of the
operands could be arbitrary;  it's better in these cases to use the
\fBstring compare\fR command instead.
.VE

.SH KEYWORDS
arithmetic, boolean, compare, expression
