'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) tclvars.n 1.3 95/02/22 14:27:30
'\" 
.so man.macros
.HS tclvars tcl
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
tclvars \- Variables used by Tcl
.BE

.SH DESCRIPTION
.PP
The following global variables are created and managed automatically
by the Tcl library.  Except where noted below, these variables should
normally be treated as read-only by application-specific code and by users.
.TP
\fBenv\fR
.br
This variable is maintained by Tcl as an array
whose elements are the environment variables for the process.
Reading an element will return the value of the corresponding
environment variable.
Setting an element of the array will modify the corresponding
environment variable or create a new one if it doesn't already
exist.
Unsetting an element of \fBenv\fR will remove the corresponding
environment variable.
Changes to the \fBenv\fR array will affect the environment
passed to children by commands like \fBexec\fR.
If the entire \fBenv\fR array is unset then Tcl will stop
monitoring \fBenv\fR accesses and will not update environment
variables.
.TP
\fBerrorCode\fR
After an error has occurred, this variable will be set to hold
additional information about the error in a form that is easy
to process with programs.
\fBerrorCode\fR consists of a Tcl list with one or more elements.
The first element of the list identifies a general class of
errors, and determines the format of the rest of the list.
The following formats for \fBerrorCode\fR are used by the
Tcl core; individual applications may define additional formats.
.RS
.TP
\fBARITH\fI code msg\fR
.VS
This format is used when an arithmetic error occurs (e.g. an attempt
to divide by zero in the \fBexpr\fR command).
\fICode\fR identifies the precise error and \fImsg\fR provides a
human-readable description of the error.  \fICode\fR will be either
DIVZERO (for an attempt to divide by zero),
DOMAIN (if an argument is outside the domain of a function, such as acos(\-3)),
IOVERFLOW (for integer overflow),
OVERFLOW (for a floating-point overflow),
or UNKNOWN (if the cause of the error cannot be determined).
.VE
.TP
\fBCHILDKILLED\fI pid sigName msg\fR
This format is used when a child process has been killed because of
a signal.  The second element of \fBerrorCode\fR will be the
process's identifier (in decimal).
The third element will be the symbolic name of the signal that caused
the process to terminate; it will be one of the names from the
include file signal.h, such as \fBSIGPIPE\fR.
The fourth element will be a short human-readable message
describing the signal, such as ``write on pipe with no readers''
for \fBSIGPIPE\fR.
.TP
\fBCHILDSTATUS\fI pid code\fR
This format is used when a child process has exited with a non-zero
exit status.  The second element of \fBerrorCode\fR will be the
process's identifier (in decimal) and the third element will be the exit
code returned by the process (also in decimal).
.TP
\fBCHILDSUSP\fI pid sigName msg\fR
This format is used when a child process has been suspended because
of a signal.
The second element of \fBerrorCode\fR will be the process's identifier,
in decimal.
The third element will be the symbolic name of the signal that caused
the process to suspend; this will be one of the names from the
include file signal.h, such as \fBSIGTTIN\fR.
The fourth element will be a short human-readable message
describing the signal, such as ``background tty read''
for \fBSIGTTIN\fR.
.TP
\fBNONE\fR
.br
This format is used for errors where no additional information is
available for an error besides the message returned with the
error.  In these cases \fBerrorCode\fR will consist of a list
containing a single element whose contents are \fBNONE\fR.
.TP
\fBPOSIX \fIerrName msg\fR
.VS
If the first element of \fBerrorCode\fR is \fBPOSIX\fR, then
the error occurred during a POSIX kernel call.
.VE
The second element of the list will contain the symbolic name
of the error that occurred, such as \fBENOENT\fR; this will
be one of the values defined in the include file errno.h.
The third element of the list will be a human-readable
message corresponding to \fIerrName\fR, such as
``no such file or directory'' for the \fBENOENT\fR case.
.PP
To set \fBerrorCode\fR, applications should use library
procedures such as \fBTcl_SetErrorCode\fR and
.VS
\fBTcl_PosixError\fR,
.VE
or they may invoke the \fBerror\fR command.
If one of these methods hasn't been used, then the Tcl
interpreter will reset the variable to \fBNONE\fR after
the next error.
.RE
.TP
\fBerrorInfo\fR
After an error has occurred, this string will contain one or more lines
identifying the Tcl commands and procedures that were being executed
when the most recent error occurred.
Its contents take the form of a stack trace showing the various
nested Tcl commands that had been invoked at the time of the error.
.TP
\fBtcl_precision\fR
.VS
If this variable is set, it must contain a decimal number giving the
number of significant digits to include when converting floating-point
values to strings.
If this variable is not set then 6 digits are included.
17 digits is ``perfect'' for IEEE floating-point in that it allows
double-precision values to be converted to strings and back to
binary with no loss of precision.
.VE

.SH KEYWORDS
arithmetic, error, environment, POSIX, precision, subprocess, variables
