'\"
'\" Copyright (c) 1994 The Regents of the University of California.
'\" Copyright (c) 1994 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) focusNext.n 1.3 94/12/17 16:04:38
'/" 
.so man.macros
.HS tk_focusNext tk 4.0
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
tk_focusNext, tk_focusPrev, tk_focusFollowsMouse \- Utility procedures for managing the input focus.
.SH SYNOPSIS
\fBtk_focusNext \fIwindow\fR
.br
\fBtk_focusPrev \fIwindow\fR
.br
\fBtk_focusContinue \fIwindow\fR
.br
\fBtk_focusFollowsMouse\fR
.BE

.SH DESCRIPTION
.PP
\fBtk_focusNext\fR is a utility procedure used for keyboard traversal.
It finds the ``next'' window after \fIwindow\fR in focus order and sets
the input focus to that window.  The focus order is determined by
the stacking order of windows and the structure of the window hierarchy.
Among siblings, the focus order is the same as the stacking order, with the
lowest window being first.
Frames do not receive the focus at all,  but if a frame has children,
then its children appear in the frame's place in the focus order.
Top-level windows are skipped, so \fBtk_focusNext\fR will never move
the focus from one top-level to another.
If the last of all descendants of a top-level
is reached, the focus rotates circularly back to the first descendant.
If \fIwindow\fR's top-level has no descendants that are capable of receiving the
focus, then \fBtk_focusNext\fR has no effect.
.PP
\fBtk_focusPrev\fR is similar to \fBtk_focusNext\fR except that it
moves the focus to the window just before \fIwindow\fR in the focus
order.
.PP
\fBtk_focusContinue\fR is typically invoked by windows that don't
have any use for the input focus.  When they receive the focus, they
call \fBtk_focusContinue\fR with their window name.
\fBtk_focusContinue\fR then calls either \fBtk_focusNext\fR or
\fBtk_focusPrev\fR (whichever was called last) to pass the focus
on to either the next or previous window, effectively skipping this
window in the traversal order.
.PP
\fBtk_focusFollowsMouse\fR changes the focus model for the application
to an implicit one where the window under the mouse gets the focus.
After this procedure is called, whenever the mouse enters a window
Tk will automatically give it the input focus.
The \fBfocus\fR command may be used to move the focus to a window
other than the one under the mouse, but as soon as the mouse moves
into a new window the focus will jump to that window.
Note: at present there is no built-in support for returning the
application to an explicit focus model;  to do this you'll have
to write a script that deletes the bindings created by
\fBtk_focusFollowsMouse\fR.

.SH KEYWORDS
focus, keyboard traversal, top-level
