'\"
'\" Copyright (c) 1992 The Regents of the University of California.
'\" Copyright (c) 1994 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) tk.n 1.5 94/12/17 16:05:08
'/" 
.so man.macros
.HS tk tk 4.0
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
tk \- Manipulate Tk internal state
.SH SYNOPSIS
\fBtk\fR \fIoption \fR?\fIarg arg ...\fR?
.BE

.SH DESCRIPTION
.PP
The \fBtk\fR command provides access to miscellaneous
elements of Tk's internal state.
Most of the information manipulated by this command pertains to the
application as a whole, or to a screen or display, rather than to a
particular window.
The command can take any of a number of different forms
depending on the \fIoption\fR argument.  The legal forms are:
.TP
\fBtk appname ?\fInewName\fR?
.VS
If \fInewName\fR isn't specified, this command returns the name
of the application (the name that may be used in \fBsend\fR
commands to communicate with the application).
If \fInewName\fR is specified, then the name of the application
is changed to \fInewName\fR.
If the given name is already in use, then a suffix of the form
``\fB #2\fR'' or ``\fB #3\fR'' is appended in order to make the name unique.
The command's result is the name actually chosen.
If sends have been disabled by deleting the \fBsend\fR command,
this command will reenable them and recreate the \fBsend\fR
command.
.VE
.TP
\fBtk colormodel \fIwindow\fR ?\fInewValue\fR?
If \fInewValue\fR isn't specified, this command returns the current
color model in use for \fIwindow\fR's screen, which will be either
\fBcolor\fR or \fBmonochrome\fR.
If \fInewValue\fR is specified, then it must be either \fBcolor\fR
or \fBmonochrome\fR or an abbreviation of one of them;
the color model for \fIwindow\fR's screen is set to this value.
.RS
.LP
The color model is used by Tk and its widgets to determine whether
it should display in black and white only or use colors.
A single color model is shared by all of the windows managed by one
process on a given screen.
The color model for a screen is set initially by Tk to \fBmonochrome\fR
if the display has four or fewer bit planes and to \fBcolor\fR otherwise.
The color model will automatically be changed from \fBcolor\fR to
\fBmonochrome\fR if Tk fails to allocate a color because all entries
in the colormap were in use.
An application can change its own color model at any time (e.g. it
might change the model to \fBmonochrome\fR in order to conserve
colormap entries, or it might set the model to \fBcolor\fR
to use color on a four-bit display in special circumstances), but
an application is not allowed to change the color model to \fBcolor\fR
unless the screen has at least two bit planes.
.RE

.SH KEYWORDS
application name, color model, internal state, send
