# mkTextWind w
#
# Create a top-level window with a text widget that demonstrates the
# use of embedded windows in texts.
#
# Arguments:
#    w -	Name to use for new top-level window.
#
# @(#) mkTextWind.tcl 1.2 94/12/23 15:52:17

proc mkTextWind {{w .emb}} {
    catch {destroy $w}
    toplevel $w
    dpos $w
    wm title $w "Text Demonstration - Embedded Windows"
    wm iconname $w "Embedded Windows"

    button $w.ok -text OK -command "destroy $w" -width 8
    text $w.t -yscrollcommand "$w.s set" -setgrid true -width 70 \
	    -height 35 -wrap word
    scrollbar $w.s -command "$w.t yview"
    pack $w.ok -side bottom
    pack $w.s -side right -fill y
    pack $w.t -expand yes -fill both
    $w.t tag configure bold -font -Adobe-Courier-Bold-O-Normal--*-120-*-*-*-*-*-*
    $w.t tag configure center -justify center -spacing1 5m -spacing3 5m
    $w.t tag configure buttons -lmargin1 1c -lmargin2 1c -rmargin 1c \
	    -spacing1 3m -spacing2 0 -spacing3 0

    button $w.t.on -text "Turn On" -command "textWindOn $w" \
	    -cursor top_left_arrow
    button $w.t.off -text "Turn Off" -command "textWindOff $w" \
	    -cursor top_left_arrow
    button $w.t.click -text "Click Here" -command "textWindPlot $w" \
	    -cursor top_left_arrow
    button $w.t.delete -text "Delete" -command "textWindDel $w" \
	    -cursor top_left_arrow

    $w.t insert end "A text widget can contain other widgets embedded "
    $w.t insert end "it.  These are called "
    $w.t insert end "embedded windows" bold
    $w.t insert end ", and they can consist of arbitrary widgets.  "
    $w.t insert end "For example, here are two embedded button "
    $w.t insert end "widgets.  You can click on the first button to "
    $w.t window create end -window $w.t.on
    $w.t insert end " horizontal scrolling, which also turns off "
    $w.t insert end "word wrapping.  Or, you can click on the second "
    $w.t insert end "button to\n"
    $w.t window create end -window $w.t.off
    $w.t insert end " horizontal scrolling and turn back on word wrapping.\n\n"

    $w.t insert end "Or, here is another example.  If you "
    $w.t window create end -window $w.t.click
    $w.t insert end " a canvas displaying an x-y plot will appear right here."
    $w.t mark set plot insert
    $w.t mark gravity plot left
    $w.t insert end "  You can drag the data points around with the mouse, "
    $w.t insert end "or you can click here to "
    $w.t window create end -window $w.t.delete
    $w.t insert end " the plot again.\n\n"

    $w.t insert end "You may also find it useful to put embedded windows in "
    $w.t insert end "a text without any actual text.  In this case the "
    $w.t insert end "text widget acts like a geometry manager.  For "
    $w.t insert end "example, here is a collection of buttons laid out "
    $w.t insert end "neatly into rows by the text widget.  These buttons "
    $w.t insert end "can be used to change the background color of the "
    $w.t insert end "text widget (\"Default\" restores the color to "
    $w.t insert end "its default).  If you click on the button labeled "
    $w.t insert end "\"Short\", it changes to a longer string so that "
    $w.t insert end "you can see how the text widget automatically "
    $w.t insert end "changes the layout.  Click on the button again "
    $w.t insert end "to restore the short string.\n"

    button $w.t.default -text Default -command "embDefBg $w.t" \
	    -cursor top_left_arrow
    $w.t window create end -window $w.t.default -padx 3
    global embToggle
    set embToggle Short
    checkbutton $w.t.toggle -textvariable embToggle -indicatoron 0 \
	    -variable embToggle -onvalue "A much longer string" \
	    -offvalue "Short" -cursor top_left_arrow
    $w.t window create end -window $w.t.toggle -padx 3 -pady 2
    set i 1
    foreach color {AntiqueWhite3 Bisque1 Bisque2 Bisque3 Bisque4
	    SlateBlue3 RoyalBlue1 SteelBlue2 DeepSkyBlue3 LightBlue1
	    DarkSlateGray1 Aquamarine2 DarkSeaGreen2 SeaGreen1
	    Yellow1 IndianRed1 IndianRed2 Tan1 Tan4} {
	button $w.t.color$i -text $color -cursor top_left_arrow -command \
		"$w.t configure -bg $color"
	$w.t window create end -window $w.t.color$i -padx 3 -pady 2
	incr i
    }
    $w.t tag add buttons $w.t.default end
}

proc textWindOn w {
    catch {destroy $w.s2}
    scrollbar $w.s2 -orient horizontal -command "$w.t xview"
    pack $w.s2 -after $w.ok -side bottom -fill x
    $w.t configure -xscrollcommand "$w.s2 set" -wrap none
}

proc textWindOff w {
    catch {destroy $w.s2}
    $w.t configure -xscrollcommand {} -wrap word
}

proc textWindPlot w {
    set c $w.t.c
    canvas $c -relief sunken -width 450 -height 300 -cursor top_left_arrow

    set font -Adobe-Helvetica-Medium-R-Normal--*-180-*-*-*-*-*-*

    $c create line 100 250 400 250 -width 2
    $c create line 100 250 100 50 -width 2
    $c create text 225 20 -text "A Simple Plot" -font $font -fill brown
    
    for {set i 0} {$i <= 10} {incr i} {
	set x [expr {100 + ($i*30)}]
	$c create line $x 250 $x 245 -width 2
	$c create text $x 254 -text [expr 10*$i] -anchor n -font $font
    }
    for {set i 0} {$i <= 5} {incr i} {
	set y [expr {250 - ($i*40)}]
	$c create line 100 $y 105 $y -width 2
	$c create text 96 $y -text [expr $i*50].0 -anchor e -font $font
    }
    
    foreach point {{12 56} {20 94} {33 98} {32 120} {61 180}
	    {75 160} {98 223}} {
	set x [expr {100 + (3*[lindex $point 0])}]
	set y [expr {250 - (4*[lindex $point 1])/5}]
	set item [$c create oval [expr $x-6] [expr $y-6] \
		[expr $x+6] [expr $y+6] -width 1 -outline black \
		-fill SkyBlue2]
	$c addtag point withtag $item
    }

    $c bind point <Any-Enter> "$c itemconfig current -fill red"
    $c bind point <Any-Leave> "$c itemconfig current -fill SkyBlue2"
    $c bind point <1> "embPlotDown $c %x %y"
    $c bind point <ButtonRelease-1> "$c dtag selected"
    bind $c <B1-Motion> "embPlotMove $c %x %y"
    $w.t delete plot {plot+2c}
    $w.t insert plot "\n"
    $w.t window create plot -window $c
    $w.t tag add center plot
    $w.t insert plot "\n"
}

set embPlot(lastX) 0
set embPlot(lastY) 0

proc embPlotDown {w x y} {
    global embPlot
    $w dtag selected
    $w addtag selected withtag current
    $w raise current
    set embPlot(lastX) $x
    set embPlot(lastY) $y
}

proc embPlotMove {w x y} {
    global embPlot
    $w move selected [expr $x-$embPlot(lastX)] [expr $y-$embPlot(lastY)]
    set embPlot(lastX) $x
    set embPlot(lastY) $y
}

proc textWindDel w {
    if [winfo exists $w.t.c] {
	$w.t delete plot {plot + 3 char}
	$w.t insert plot "  "
    }
}

proc embDefBg t {
    $t configure -background [lindex [$t configure -background] 3]
}
