'\"
'\" Copyright (c) 1990-1994 The Regents of the University of California.
'\" Copyright (c) 1994 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) focus.n 1.13 94/12/17 16:04:37
'/" 
.so man.macros
.HS focus tk 4.0
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
focus \- Manage the input focus
.SH SYNOPSIS
\fBfocus\fR
.br
\fBfocus \fIwindow\fR
.br
\fBfocus \fIoption\fR ?\fIarg arg ...\fR?
.BE

.SH DESCRIPTION
.PP
The \fBfocus\fR command is used to manage the Tk input focus.
.VS
At any given time, one window on each display is designated as
the \fIfocus window\fR;  any key press or key release events for the
display are sent to that window.
It is up to the window manager to redirect the focus among the
top-level windows of a display.  For example, some window managers
automatically set the input focus to a top-level window whenever
the mouse enters it;  others redirect the input focus only when
the user clicks on a window.
Usually the window manager will set the focus
only to top-level windows, leaving it up to the application to
redirect the focus among the children of the top-level.
.PP
Tk remembers one focus window for each top-level (the most recent
descendant of that top-level to receive the focus);  when the window
manager gives the focus
to a top-level, Tk automatically redirects it to the remembered
window.  Within a top-level Tk uses an \fIexplicit\fR focus model
by default.  Moving the mouse within a top-level does not normally
change the focus;  the focus changes only when a widget
decides explicitly to claim the focus (e.g., because of a button
click), or when the user types a key such as Tab that moves the
focus.
.PP
The Tcl procedure \fBtk_focusFollowsMouse\fR may be invoked to
create an \fIimplicit\fR focus model:  it reconfigures Tk so that
the focus is set to a window whenever the mouse enters it.
The Tcl procedures \fBtk_focusNext\fR and \fBtk_focusPrev\fR
implement a focus order among the windows of a top-level;  they
are used in the default bindings for Tab and Shift-Tab, among other
things.
.PP
The \fBfocus\fR command can take any of the following forms:
.TP
\fBfocus\fR
Returns the path name of the focus window on the display containing
the application's main window,  or an empty string if no window in
this application has the focus on that display.   Note:  it is
better to specify the display explicitly using \fB\-displayof\fR
(see below) so that the code will work in applications using multiple
displays.
.TP
\fBfocus \fIwindow\fR
Sets the input focus for \fIwindow\fR's display to \fIwindow\fR and
returns an empty string.  If \fIwindow\fR isn't viewable at the
time this command is invoked, X will refuse to actually set the focus;
nonetheless, \fIwindow\fR will be marked by Tk as the focus window
for its display.
.TP
\fBfocus \fB\-displayof\fR \fIwindow\fR
Returns the name of the focus window on the display containing \fIwindow\fR.
If the focus window for \fIwindow\fR's display isn't in this
application, the return value is an empty string.
.TP
\fBfocus \fB\-lastfor\fR \fIwindow\fR
Returns the name of the most recent window to have the input focus
among all the windows in the same top-level as \fIwindow\fR.
If no window in that top-level has ever had the input focus, or
if the most recent focus window has been deleted, then the name
of the top-level is returned.  The return value is the window that
will receive the input focus the next time the window manager gives
the focus to the top-level.

.SH "BUGS"
.PP
When Tk redirects the input focus, either because of a \fBfocus\fR
command or because the window manager set the focus to a top-level
and Tk is redirecting it to an internal window in the top-level,
there may already be keyboard events queued.  If this happens,
the FocusIn and FocusOut events for the focus change will not be
received until after the keyboard events;  however, the keyboard
events will be directed to the new focus window.  This means that
a window can receive keyboard events before receiving a FocusIn
event.
.VE

.SH KEYWORDS
events, focus, keyboard, top-level, window manager
