'\"
'\" Copyright (c) 1990-1994 The Regents of the University of California.
'\" Copyright (c) 1994-1995 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) after.n 1.15 95/01/27 16:45:56
'\" 
.so man.macros
.HS after tk 4.0
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
after \- Execute a command after a time delay
.SH SYNOPSIS
\fBafter \fIms\fR
.br
\fBafter \fIms \fR?\fIscript script script ...\fR?
.br
.VS
\fBafter cancel \fIid\fR
.br
\fBafter cancel \fIcommand\fR
.br
\fBafter idle \fR?\fIscript script script ...\fR?
.VE
.BE

.SH DESCRIPTION
.PP
This command is used to delay execution of the program or to execute
a command in background after a delay.  It has several forms,
depending on the first argument to the command:
.TP
\fBafter \fIms\fR
\fIMs\fR must be an integer giving a time in milliseconds.
The command sleeps for \fIms\fR milliseconds and then returns.
While the command is sleeping the application does not respond to
X events or any other events.
.TP
\fBafter \fIms \fR?\fIscript script script ...\fR?
In this form the command returns immediately, but it arranges
for a Tcl command to be executed \fIms\fR milliseconds later as a
background event handler.
The delayed command is formed by concatenating all the \fIscript\fR
arguments in the same fashion as the \fBconcat\fR command.
The command will be executed at global level (outside the context
of any Tcl procedure).
If an error occurs while executing the delayed command then the
\fBtkerror\fR mechanism is used to report the error.
The \fBafter\fR command returns an identifier that can be used
to cancel the delayed command using \fBafter cancel\fR.
.TP
\fBafter cancel \fIid\fR
.VS
Cancels the execution of a delayed command that
was previously scheduled.
\fIId\fR indicates which command should be canceled;  it must have
been the return value from a previous \fBafter\fR command.
If the command given by \fIid\fR has already been executed then
the \fBafter cancel\fR command has no effect.
.TP
\fBafter cancel \fIcommand\fR
This command also cancels the execution of a delayed command.
The \fIcommand\fR argument specifies the text of the command to
be cancelled.
If there exists such a command among those whose execution is
still pending, then it is cancelled and will never be executed;
if no such command is currently pending then the \fBafter cancel\fR
command has no effect.
.TP
\fBafter idle \fIscript \fR?\fIscript script ...\fR?
Concatenates the \fIscript\fR arguments together with space
separators (just as in the \fBconcat\fR command), and arranges
for the resulting script to be evaluated later as an idle handler
(the script runs the next time the Tk event loop is entered
and there are no events to process).
The command returns an identifier that can be used
to cancel the delayed command using \fBafter cancel\fR.
If an error occurs while executing the script then the
\fBtkerror\fR mechanism is used to report the error.
.VE

.SH "SEE ALSO"
tkerror

.SH KEYWORDS
cancel, delay, sleep, time
