#include "resource.h"       
#include "cwinsock.h"
extern "C" 
{
	#include <gssapi/gssapi.h>
	#include <gssapi/gssapi_g.h>
}

#define RCVBUFFERLEN 10000
#define TOKENBUFFERSIZE 8000
#define MAXORDERNUMLEN 100
#define MAXHOSTNAMELEN 100
#define MAXFILENAME 100
#define MAXSECURITYLEN 100

#define WM_USER_STREAM (WM_USER+1)

static const gss_OID_desc oids[] = {
   {10, "\052\206\110\206\367\022\001\002\001\001"},
   {10, "\052\206\110\206\367\022\001\002\001\002"},
   {10, "\052\206\110\206\367\022\001\002\001\003"},
   {10, "\052\206\110\206\367\022\001\002\001\004"},
};

const_gss_OID gss_nt_user_name = oids+0;
const_gss_OID gss_nt_machine_uid_name = oids+1;
const_gss_OID gss_nt_string_uid_name = oids+2;
const_gss_OID gss_nt_service_name = oids+3;
                       
enum States
{
	UNINITIALIZED, ORDERAUTHSPOOLING, ORDERAUTHCOMPLETE, ORDERREQUESTED,
	ORDERSPOOLING, WAITONUSER, SIGNAUTHSPOOLING,	SIGNAUTHCOMPLETE,
	SIGNPRESSED, SIGNREQUESTED, SIGNSPOOLING, SIGNDONE
};

enum GSS_Results  // used for debugging in Visual C++
{
	S_COMPLETE = GSS_S_COMPLETE, S_CONTEXT_EXPIRED = GSS_S_CONTEXT_EXPIRED,
	S_CREDENTIAL_EXPIRED = GSS_S_CREDENTIALS_EXPIRED,
	S_NO_CONTEXT = GSS_S_NO_CONTEXT, S_FAILURE = GSS_S_FAILURE
} DBFeedback;

void Upgrade(States *current);

class CKsignDialog : public CDialog
{
public:
    CKsignDialog();

// Dialog Data
    //{{AFX_DATA(CKsignDialog)
	enum { IDD = IDD_KSIGNDLG };
	CEdit	m_ctrlEdit;
	CString	m_strText;
	//}}AFX_DATA

protected: // global variables
   CFile * m_pInput; // stores connection to inp file
	CWinSock * m_pWinSock;
	CStreamSocket * m_pStream; 
	CString m_strConfirmation;

	char m_szHostname[MAXHOSTNAMELEN]; // 100 currently
	long m_nPort;
	char m_szServiceNo[MAXORDERNUMLEN]; // 100 currently         
	char m_szOrderNo[MAXORDERNUMLEN]; // 100 currently         
	char m_szReceiveBuffer[RCVBUFFERLEN]; // 1024 currently    
	char m_szSecurity[MAXSECURITYLEN]; // 100 currently

	long perr; // error code Daniel made	
	enum States m_nState;

	struct 
	{  
		unsigned long nLen;
		unsigned long nType;
		char strMessage[100];
	}	rqst;  
	
	struct
	{
		unsigned long nLen;
		char strMessage[TOKENBUFFERSIZE];
	}	rqst2;	
	                                     
	// kerberos variables                                     
	gss_buffer_desc send_tok, recv_tok, *token_ptr;
	gss_name_t target_name;
	OM_uint32 maj_stat, min_stat, ignore; 
	
	// querydaemon's variables
	gss_ctx_id_t context;       
	int conf_state;     
	   
// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
//	void DisplayData(LPCSTR pszData, long len);
	void ProcessToken(gss_buffer_desc *recv_tok);
	void ProcessSignature(gss_buffer_desc *encrypted);
	void ProcessOrder(gss_buffer_desc *encrypted);
	
	//{{AFX_MSG(CKsignDialog)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();
	afx_msg void OnAbout();
	afx_msg void OnCompute();
	afx_msg void OnCancel();
	//}}AFX_MSG
	afx_msg LONG OnStream(WPARAM wParam, LPARAM lParam);	
	DECLARE_MESSAGE_MAP()
};

class CKsignApp : public CWinApp
{
private:
	CKsignDialog m_dialog;
	
public:
	BOOL InitInstance(); 
};

// stuff necessary for about box:

class CAboutDlg : public CDialog
{
public:
	CAboutDlg(CWnd* pParent);

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUT };
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
		afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

