/* ptst.c:  build a .prc from a pile of files.
 *
 * (c) 1996, Dionne & Associates
 * This is Free Software, under the GNU Public Licence v2 or greater.
 */

#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <malloc.h>
#include "prc.h"

#ifdef CYGWIN32
#define O_PLATFORM O_BINARY
#else
#define O_PLATFORM 0
#endif

main(int argc, char *argv[])
{
  pfd_t *pf;
  int fd;
  int i;
  char *sd;
  char sname[5];
  int slen;

  if (argc < 5) {
    fprintf(stderr, "Usage: %s fname.prc 'App Name' apid resource resource ...\n", argv[0]);
    exit (1);
  }

  if (!(pf = openw_pfd(argv[2], argv[3], argv[1]))) {
    printf ("can't open prc file\n");
    exit(2);
  }

  /* the .prc write routines write the resources in reverse order! */

  for (i=argc-1; i > 3; i--) {
    if ((fd = open(argv[i], O_PLATFORM | O_RDONLY)) < 1) {
      fprintf(stderr, "Can't open resource file %s\n",argv[i]);
      exit(3);
    }

    slen = lseek(fd, 0, SEEK_END);
    lseek(fd, 0, SEEK_SET);

    sd = malloc(slen);
    read(fd, sd, slen);
    close (fd);

    add_section_pfd(pf, argv[i], strtoul(argv[i] + 4, (void *)0, 16),
		    sd, slen);
  }

  write_pfd(pf);
  exit(0);
}

