/* sccsid[] = "@(#)clrfcbse.h     20.2     SAP     95/06/13" */   
//
// SAP RFC Classes C++ library.
// Copyright (C) 1994 SAP America, Inc.
// All rights reserved.


#define  MAX_LEN    1024
#define  FIELDNAME_LEN  10  
#define  MAX_SAPCOLUMN_LEN  1024 

                  
class CRfcString;   

typedef unsigned char BYTE; 
typedef int   BOOL;  

#define TRUE   1
#define FALSE  0                

///////////////////////////////////////////////////////////////////////////////
//  Variable definition  

typedef struct tagRfcVARIANT{
    union {
      short	         iVal;       // TYPEINT2, TYPEINT1
      long	         lVal;       // TYPEINT
      double	     dblVal;     // TYPEFLOAT    
      float          fltVal;     // TYPEP
      char FAR*      bstrVal;    // TYPEC,TYPEX,TYPENUM,TYPEDATE,TYPETIME
    };
    unsigned short   nType; 
} CELLDATATYPE;



                  
/////////////////////////////////////////////////////////////////////////////
// Column definition

typedef struct tagCOLUMNINFO
{
  char             strFieldName[FIELDNAME_LEN+1];
  unsigned short   nPosition;
  unsigned short   nOffset;
  unsigned short   nLength;
  unsigned short   nDecimals;
  unsigned short   nType; 
} COLUMNINFO,  *LPCOLUMNINFO;    
                                  
/////////////////////////////////////////////////////////////////////////////
// Global functions
                                  
extern const char* _strSAPType(short nSapType);
short CTOX(char c); 
int REV_INT(void *pAddr);  
long  REV_LONG(void *pAddr); 
double REV_DOUBLE(void *pAddr); 
void  CharToHex(unsigned char * hexBuf, char* charBuf, unsigned length); 
void  HexToChar(char* charBuf, unsigned char * hexBuf, unsigned length); 
void ABAPTypeChange(CELLDATATYPE& va, void * address, unsigned length, 
                                   short decimals, short type, BOOL m_bIsBigIndian); 
void TypeChangeToABAP(const CELLDATATYPE& vaTemp,void * address,unsigned length, 
                                   short decimals, short type, BOOL m_bIsBigIndian);  
void VariantChangeType(CELLDATATYPE & va);

/////////////////////////////////////////////////////////////////////////////
// Strings


class CRfcString
{
public:

// Constructors
	CRfcString();
	CRfcString(const char* psz);
	~CRfcString();

// Attributes & Operations
    
    void Init();
    void AllocBuffer(int nLen);
    void AssignCopy(int nSrcLen, const char* pszSrcData);
    
	// as an array of characters
	int GetLength() const;
    void Empty();
    void SafeDelete(char* psz);
    
	// overloaded assignment
	const CRfcString& operator=(const CRfcString& stringSrc);
	const char*       operator=(const char* psz);


	// Access to string implementation buffer as "C" character array
	char* GetString();

protected:
	// lengths/sizes in characters
	//  (note: an extra character is always allocated)
	char* m_pchData;            // actual string (zero terminated)
	int m_nDataLength;          // does not include terminating 0

};


                              
                              
/////////////////////////////////////////////////////////////////////////////
// Table Control structure

class CRfcTableStructure
{    
public:
    CRfcTableStructure();
    virtual ~CRfcTableStructure();
    
    BOOL Create(char*, LPCOLUMNINFO, int);
public:    
    CRfcString      m_TableName;
    LPCOLUMNINFO    m_pColumnInfo;
    int             m_nColumn;
    int             m_nLength;
    
    LPCOLUMNINFO    GetColumnInfo(int index); 
    LPCOLUMNINFO    GetColumnInfo(char *columnName);
    int             GetColumnCount();
    int             GetLength(); 
    void            GetDescription(CRfcString *lpDescription);
};                              
                        
                        
/////////////////////////////////////////////////////////////////////////////
//  CStructure

class CRfcParameterStructure
{
public:
      CRfcParameterStructure();
      BOOL Create(char* pName, LPCOLUMNINFO p, int n);
      virtual ~CRfcParameterStructure();
      
      
      CRfcString      m_strParamName;
      LPCOLUMNINFO    m_pControlStructure;
      int             m_nColumn;     
      int             m_nLength;
      
  LPCOLUMNINFO        GetColumnInfo(int index); 
  const char*         GetParamName();
  void                GetDescription(CRfcString *lp);
  int                 GetLength();
};  
                              

