/* sccsid[] = "@(#)clrfclib.h     20.2     SAP     95/06/13" */   
//

// SAP RFC C++ Class library.
// Copyright (C) 1994 SAP America, Inc.
// All rights reserved.
                        

//////////////////////////////////////////////////////////////////////////////////
// CRfcConnection class declaration 

class CRfcConnection : public CRfcObject
{
   // constructor & destructor
public:       
    CRfcConnection();      
//    CRfcConnection(char*, CRfcApp*);
    virtual ~CRfcConnection();
 
public:    
  // Attributes
    RFC_HANDLE        m_Handle;           // Connection handel;
    CRfcOption        m_Connection;       // Connection options;

public:    
  // Connection member functions
    RFC_HANDLE   RfcOpen(void);           // Open connection
    void         RfcClose(void);          // Close this connection;
    void         RfcAbort(char *text);    // Abort this connection; 
    RFC_HANDLE   RfcAccept(char **argv);  // Accept an incoming connection;  
    RFC_HANDLE   GetHandle();            
    char         *GetHost();
    char         *GetDestination();
    int          GetOptions(RFC_OPTIONS *p);
    void         SetOptions(char* de,  char* cl, char* us, char* ps ,char* l,
                       char* hn, char* gn, char* gs, RFC_MODE m=RFC_MODE_R3ONLY ,int n=0, int t=0);
    void         SetOptions(char* user, char* pass);
    void         SetLanguage(char* l);
    void         SetDestination(char* de);
    void         SetClient(char* cl);
    void         SetHost(char* host);
    void         SetGatewayHost(char* ghost);
    void         SetGatewayService(char* sr);
    void         SetSystemNo(int srn);
    void         SetTraceLevel(int t);                    
    void         SetMode(RFC_MODE m); 
                                                                    
};

//////////////////////////////////////////////////////////////////////////////////
// CRfcFunction class declaration 

class CRfcFunction : public CRfcObject
{
  // constructor & destructor 
public:
    CRfcFunction(char *na);
    virtual ~CRfcFunction();
  
  // Attributes
public:
    RFC_HANDLE     m_Handle;                  // Function handle needed when make a remote call;
    CRfcParameterArray  m_Export;             // Export parameters;                             
    CRfcParameterArray  m_Import;             // Import parameters;
    CRfcTableArray m_Tables;                  // Table parameter;
    CRfcString     m_FunctionName;            // Last called remote function name; 
    
    
    // operations
    

  // RFC interface functions                           
public:  
     // calling & communication function
    RFC_RC       RfcCall(CRfcConnection *p);                             
    RFC_RC       RfcCall(); 
    RFC_RC       Call(CRfcConnection *p);
    RFC_RC       RfcCall(CRfcConnection *p, char* na);
    RFC_RC       RfcCall(char *na);
    
    RFC_RC       RfcReceive(char **exception);                             
    
    RFC_RC       RfcCallReceive(char *function_name, char **exception);    
    RFC_RC       RfcCallReceive(char **exception);
    RFC_RC       RfcCallReceive(CRfcConnection *p, char **exception);
    RFC_RC       RfcCallReceive(CRfcConnection *p, char* fn, char** exception);
    
    RFC_RC       RfcGetName(CRfcConnection *p=NULL);                                         
    RFC_RC       RfcGetData(CRfcConnection *p=NULL);                                         
    RFC_RC       RfcSendData(CRfcConnection *p=NULL);                                        
    
     // other functions
    RFC_RC       RfcInstallFunction(char *function_name, RFC_ONCALL fp, char *description); 
    RFC_RC       RfcDispatch(CRfcConnection *p=NULL);
                                                                           
    int          RfcListen(CRfcConnection *p=NULL);                                
    RFC_RC       RfcRaise(char *exception,CRfcConnection *p=NULL);                                
    void         RfcEnvironment(RFC_ENV *new_env);                         
    int          RfcLastError(RFC_ERROR_INFO *errorinfo);                  
//    int          RfcConnArgv(char **argv); 
                                    
 // Parameters operate functions   
    char         *SetFunctionName(char* na);
    void         SetParamSize(int in, int en, int tn); 
    void         AddImportParam(CRfcParameter *p);
    void         AddExportParam(CRfcParameter *p);
    void         AddTableParam(CRfcTable *p);
    
                                                                                
};                                            


//////////////////////////////////////////////////////////////////////////////////
// CRfcLogon class declaration 
                               
                                                                           
class CRfcLogon
{
public:
   // constructor
public:
    CRfcLogon();                // Construct CRfcLogon instance;
    virtual ~CRfcLogon();                                      
    
    CRfcConnection  m_LogonConnection;
    
    void SetDestination(char *);
    void SetMode(RFC_MODE);
    void SetClient(char *);
    void SetOptions(char* user, char* pass);
    void SetLanguage(char *);
    void SetHost(char *);
    void SetGatewayHost(char *);
    void SetGatewayService(char *);
    void SetSystemNo(int);
    void SetTraceLevel(int);
    RFC_HANDLE Logon();
    CRfcConnection *  GetConnection();
};
