/* sccsid[] = "@(#)clrfcobj.h     20.2     SAP     95/06/13" */   
//
// SAP RFC Classes C++ library.
// Copyright (C) 1994 SAP America, Inc.
// All rights reserved.


/////////////////////////////////////////////////////////
//Classes declared in this file  

class CRfcString;

class CRfcObject;
class CRfcData;
class CRfcOption;
class CRfcTable;
class CRfcParameterArray;
class CRfcTableArray;
class CRfcApp;

  
enum CRfcParameterType { STRUCTURE_TYPE, BASIC_TYPE}; 

 
/////////////////////////////////////////////////////////
//  CRfcObject class declaration, the principle base class   

class CRfcObject
{
  // Constructor
public:                                          
    CRfcObject();
    CRfcObject(char *objname);     
    virtual ~CRfcObject();
    
  // Attributes                                 
private:  
    CRfcString   m_Name;                // Name of the object;
    unsigned     m_nLen;                // Length of the name;

  // Operations
public:  
    void         Create(char *objname);
    char         *GetName(void);        // Return the name of the object;
    unsigned     GetNameLength(void);
    char         *SetName(char *na);
};                                                                  


/////////////////////////////////////////////////////////
//  CRfcData class declaration  

class CRfcData : public CRfcObject
{
   // Constructor
public:                                                   
    CRfcData();
    CRfcData(char *na, unsigned ty, void* ad);
    virtual ~CRfcData();
    
public:
   // Attributes
   unsigned   m_nType;                  // Datatype of a row;
   unsigned   m_nLength;                // Length of a row in bytes;   
   void*      m_pAddr;                  // Address of the field;
        
public:        
   // Operations                                                            
   virtual void       SetDefault();
   unsigned           GetType(); 
   unsigned           GetDataLength();         
   void               *GetAddr();          
   unsigned           SetType(unsigned ty); 
   unsigned           SetDataLength(unsigned l); 
   void               *SetAddr(void *ln); 
   void               GetParameter(RFC_PARAMETER *p);
   void               SetParameter(RFC_PARAMETER *p);
};

/////////////////////////////////////////////////////////
//  CRfcParameter class declaration      

class CRfcParameter : public CRfcData
{

public:                              
      CRfcParameter();                 
      BOOL Create(char*, unsigned,unsigned,unsigned, char*);
      BOOL Create(char*, unsigned,unsigned,unsigned, int);
      BOOL Create(char*, unsigned,unsigned,unsigned, long);
      BOOL Create(char*, unsigned,unsigned,unsigned, float);
      BOOL Create(char*, unsigned,unsigned,unsigned, double);
      BOOL Create(char* na, CRfcParameterStructure *p, int n);
      virtual ~CRfcParameter();

   CRfcParameterStructure  *m_pControlStructure;
   CRfcParameterType       m_nDataType; 
   BOOL                    m_bPass;                         
   int                     m_nColumn;
   unsigned                m_nDecimals;
   CELLDATATYPE            m_vaValue;
                           
   void  SetValue(int col, CELLDATATYPE& value, BOOL IsBigIndian);
   void  SetValue(CELLDATATYPE& value, BOOL IsBigIndian);
   CELLDATATYPE&  GetValue(int col);
   CELLDATATYPE&  GetValue();                   
   void operator=(const CRfcParameter& src);
   
   
   
};     

/////////////////////////////////////////////////////////
//  CRfcTable class declaration      

class CRfcTable : public CRfcData
{

public:                              
      CRfcTable();
      BOOL Create(char* na, CRfcTableStructure *p, RFC_ITMODE m=RFC_ITMODE_BYREFERENCE );
      virtual ~CRfcTable();
      

   // Atrributes
   RFC_ITMODE                 m_nItmode;              // Mode in which this table must be received;
   int                        m_nNewitab;             // Internal use;  
   int                        m_nRowCount;
   CRfcTableStructure  *m_pControlStructure;
   
   // Operations
   void         SetDefault();          
   void         GetTable(RFC_TABLE *p); 
   void         SetTable(RFC_TABLE *p);
   
   void          SetValue(int row, int col, CELLDATATYPE& value, BOOL IsBigIndian); 
   CELLDATATYPE& GetValue(int row, int col, CELLDATATYPE& value);
   //Itab functions                              
   
   int          GetRowCount();
   int          DeleteTable();

   int          RemoveRow(unsigned );
   void*        Append();
   void         *InsertRow(unsigned n);
   void         *GetRow(unsigned n);                      
   void         operator=(const CRfcTable& src);
                                                        
};                                                        
          

/////////////////////////////////////////////////////////
//  CRfcOption class declaration      

class CRfcOption   : public CRfcObject
{
public:                             
     CRfcOption();
//     CRfcOption(CRfcApp* p);
     virtual ~CRfcOption();
     
   // Attributes                                                          
public:   
     CRfcString   		  m_Destination;         // Name of destination;
     RFC_MODE             m_nMode;               // Connection mode;
     RFC_CONNOPT_R3ONLY   m_ConnR3Only;
     RFC_CONNOPT_CPIC     m_ConnCPIC;
     CRfcString           m_Client;              // Client name;
     CRfcString           m_User;                // User ID;
     CRfcString           m_Password;            // User password;
     CRfcString           m_Language;            // Display language;
     CRfcString           m_HostName;            // Host name of target system;
     CRfcString           m_GatewayHost;         // Gateway host name;
     CRfcString           m_GatewayService;      // Gateway service;
     int                  m_nSystemNo;           // System number ( 0-99 ); 
     
     int                  m_nTraceLevel;         // Trace level;
     
   // Operations;
     void      SetDefault();                     // Set every field to default values;     
public:
     int       GetOptions(RFC_OPTIONS *);
     void      SetOptions(char* de, char* cl, char* us, char* ps ,char* l,
                       char* hn, char* gn, char* gs, RFC_MODE m , int n=0, int t=0); 
     char*     GetDestination(){ return m_Destination.GetString(); } 
     char*     GetClient(){ return m_Client.GetString(); }
     char*     GetUser(){ return m_User.GetString(); }
     char*     GetHost(){ return m_HostName.GetString(); }
     char*     GetGatewayHost(){ return m_GatewayHost.GetString(); }
     char*     GetGatewayService(){ return m_GatewayService.GetString(); }
     int       GetSystemNo(){ return m_nSystemNo; }
     int       GetTraceLevel(){ return m_nTraceLevel; }
     void      SetDestination(char* d){ m_Destination = d; }
     void      SetMode(RFC_MODE m){ m_nMode = m;}
     void      SetClient(char* c){ m_Client = c; }
     void      SetUser(char* user){ m_User = user; }
     void      SetPassword(char* pass){ m_Password = pass; }
     void      SetLanguage(char* l){ m_Language = l; }
     void      SetHost(char* host){ m_HostName = host; }
     void      SetGatewayHost(char* gh){ m_GatewayHost = gh; }
     void      SetGatewayService(char* gs){ m_GatewayService = gs; }
     void      SetSystemNo(int n){ m_nSystemNo = n; }
     void      SetTraceLevel(int n){ m_nTraceLevel = n; }
};                                                                                     
              
                                                                                      
/////////////////////////////////////////////////////////
//  CRfcParameterArray class declaration      

class CRfcParameterArray : public CRfcObject
{                      
public:                                 
   CRfcParameterArray();                   // Create a tablearray control structure;
   virtual ~CRfcParameterArray();        
   
   // Attributes
   int             m_nCount;               // Current number of data in the array;
   CRfcParameter*  m_pData;                // Actual data;
   int             m_nMax;                 // Maximize number of data allowed in the table;    
private:   
   int             m_nCurrentPos;
public:              
   // operations                                    
   int         GetSize();
   int         GetUpperBound();
   void        SetSize(int n);
   
   void        RemoveAll();
   void        RemoveAt(int index, int nCount=1);
   
   CRfcParameter    *GetAt(int n);
   CRfcParameter    *SetAt(int n, CRfcParameter *p, int f=1);
   CRfcParameter    *SetAt(int n, char* name, void* as, unsigned ty);  
   void             SetZeroAt(int n);
   CRfcParameter    *GetByName(char *name);
   void             Add(CRfcParameter *p);               
   
   void        GetParameters(RFC_PARAMETER *p); 
   void        SetParameters(RFC_PARAMETER *p);
   
   CRfcParameter &  operator[](int index);
       
};                                                                                        
                                                                                      

/////////////////////////////////////////////////////////
//  CRfcTableArray class declaration      

class CRfcTableArray : public CRfcObject
{                      
public:                                 
   CRfcTableArray();                    // Create a tablearray control structure;
   virtual ~CRfcTableArray();        
   
   // Attributes
   int          m_nCount;               // Current number of tables in the array;
   CRfcTable*   m_pData;                // Actual data;
   int          m_nMax ;                // Maximize number of table allowed in the table;   
private:   
   int          m_nCurrentPos;
public:              
   // operations                               
   int          GetSize();
   int          GetUpperBound();
   void         SetSize(int n);
   
   void         RemoveAll();
   void         RemoveAt(int index, int nCount=1);
       
   CRfcTable    *GetAt(int index);
   CRfcTable    *SetAt(int index, CRfcTable *p, int f);
   CRfcTable    *SetAt(int n, char* na, void* ad, unsigned ty, RFC_ITMODE mode); 
   void         SetZeroAt(int n);
   CRfcTable    *GetByName(char *name);   
   void         Add(CRfcTable *p);     
   
   void         GetTables(RFC_TABLE *p);
   void         SetTables(RFC_TABLE *p);
   
   CRfcTable &  operator[](int index);
   
};  
