/* sccsid[]="@(#) Module SAPVRFC.H   Version 20.4.1.1     SAP     96/05/07" */ 
#ifndef _SAPVRFC_H
#define _SAPVRFC_H

#ifdef __cplusplus
extern "C" {
#endif
#include "sapitab.h"
#include "saprfc.h"
#ifdef __cplusplus
}
#endif


#ifndef UINT_MAX
#define UINT_MAX 0xFFFF
#endif
//  All Logon functions return these values if the user presses the cancel button
#define RFC_HANDLE_CANCEL UINT_MAX
#define VRFCLoginID_CANCEL 0xFFFF          /* User pressed the Cancel button*/


#define VRFCLoginID_PARAMETERMISSING 0xFFFE				 /* a parameter is missing inorder to logon quietly */
#define RFC_HANDLE_PARAMETERMISSING (UINT_MAX -1)


/* ------------------------------------------------------------------
 *   New fucntions by the Visual RFC Service Provider
 * ----------------------------------------------------------------*/
/* the exported interface is c like */
#ifdef __cplusplus
#define CPP_HEADER extern "C" 
#else
#define CPP_HEADER
#endif            

/* some special type defintions */



typedef enum
{
 VRFC_CONNECT_WITHOUTDIALOG           = 1,      /* donot display a dialog for SAP logon */
 VRFC_CONNECT_WITH_DIALOG             = 2,         /* display a dialog for SAP logon */
 VRFC_CONNECT_EXCLUSIVE_WITHOUTDIALOG = 5,      /* donot display a dialog for SAP logon */
 VRFC_CONNECT_EXCLUSIVE_WITH_DIALOG   = 6        /* display a dialog for SAP logon */
} VRFCService_CONNECTMODE;



typedef WORD VRFCService_HANDLE;    /* Handle to task context data */
#define VRFCService_HANDLE_NULL 0   /* Error Handle */

typedef WORD VRFCLoginID;           /* Login Handle for uing a R/3 connection */

#define VRFCLoginID_NULL 0          /* INVALID Login Handle */
                  

/* function prototypes for the exported interface */


CPP_HEADER VRFCService_HANDLE SAP_API RegisterVRFCService 
                                        (LPSTR lpcszAppName,  // name of application
                                         HINSTANCE hIns);     // instance of application
 /*
  * The Visual RFC Service Provider prepares a 
  * context for the new task will connects to it.
  */  



CPP_HEADER void SAP_API UnRegisterVRFCService (VRFCService_HANDLE hAppl);
 /* 
  * The Visual RFC Service Provider disables 
  * the associated context for the task.   
  * No further calls to the Dll can be done until a new 
  * ConnectRFCService is done
  */  

#ifdef __cplusplus   
CPP_HEADER VRFCLoginID SAP_API RequestVRFCLogon (
                            HWND hWnd,                         // Window Handle of parent window
                            VRFCService_HANDLE hAppl,          // register application handle
                            VRFCService_CONNECTMODE c_mode,    // connection mode
                            char SAP_FAR* destination = NULL,  // rfc logon parameters
                            char SAP_FAR* hostname = NULL,
                            int sysnr = -1,
                            char SAP_FAR* gateway_host = NULL,
                            char SAP_FAR* gateway_service = NULL,
                            char SAP_FAR* client = NULL,
                            char SAP_FAR* user = NULL,
                            char SAP_FAR* password = NULL, 
                            char SAP_FAR* language = NULL,
                            int trace = 0,
                            RFC_MODE mode = RFC_MODE_R3ONLY
                            );
#else
VRFCLoginID SAP_API RequestVRFCLogon (
                            HWND hWnd,                         // Window Handle of parent window
                            VRFCService_HANDLE hAppl,          // register application handle
                            VRFCService_CONNECTMODE c_mode,    // connection mode
                            char SAP_FAR* destination/* = NULL*/,  // rfc logon parameters
                            char SAP_FAR* hostname/* = NULL*/,
                            int sysnr/* = -1*/,
                            char SAP_FAR* gateway_host/* = NULL*/,
                            char SAP_FAR* gateway_service/* = NULL*/,
                            char SAP_FAR* client/* = NULL*/,
                            char SAP_FAR* user/* = NULL*/,
                            char SAP_FAR* password/* = NULL*/, 
                            char SAP_FAR* language/* = NULL*/,
                            int trace/* = 0*/,
                            RFC_MODE mode/* = RFC_MODE_R3ONLY*/
                            );
#endif                            


#ifdef __cplusplus   
CPP_HEADER VRFCLoginID SAP_API RequestVRFCGroupLogon (
                            HWND hWnd,                         // Window Handle of parent window
                            VRFCService_HANDLE hAppl,          // register application handle
                            VRFCService_CONNECTMODE c_mode,    // connection mode
                            char SAP_FAR* destination = NULL,  // rfc logon parameters
                            char SAP_FAR* group = NULL,
                            char SAP_FAR* mesageserver = NULL,
                            char SAP_FAR* client = NULL,
                            char SAP_FAR* user = NULL,
                            char SAP_FAR* password = NULL, 
                            char SAP_FAR* language = NULL,
                            int trace = 0
                            );
#else
VRFCLoginID SAP_API RequestVRFCGroupLogon (
                            HWND hWnd,                         // Window Handle of parent window
                            VRFCService_HANDLE hAppl,          // register application handle
                            VRFCService_CONNECTMODE c_mode,    // connection mode
                            char SAP_FAR* destination/* = NULL*/,  // rfc logon parameters
                            char SAP_FAR* group/* = NULL*/,
                            char SAP_FAR* mesageserver /*= NULL */,
                            char SAP_FAR* client/* = NULL*/,
                            char SAP_FAR* user/* = NULL*/,
                            char SAP_FAR* password/* = NULL*/, 
                            char SAP_FAR* language/* = NULL*/,
                            int trace/* = 0*/
                            );
#endif                            


#ifdef __cplusplus   
CPP_HEADER RFC_HANDLE SAP_API RequestRFCGroupLogon (
                            HWND hWnd,                         // Window Handle of parent window
                            VRFCService_HANDLE hAppl,          // register application handle
                            VRFCService_CONNECTMODE c_mode,    // connection mode
                            char SAP_FAR* destination = NULL,  // rfc logon parameters
                            char SAP_FAR* group = NULL,
                            char SAP_FAR* mesageserver = NULL,
                            char SAP_FAR* client = NULL,
                            char SAP_FAR* user = NULL,
                            char SAP_FAR* password = NULL, 
                            char SAP_FAR* language = NULL,
                            int trace = 0
                            );
#else
RFC_HANDLE SAP_API RequestRFCGroupLogon (
                            HWND hWnd,                         // Window Handle of parent window
                            VRFCService_HANDLE hAppl,          // register application handle
                            VRFCService_CONNECTMODE c_mode,    // connection mode
                            char SAP_FAR* destination/* = NULL*/,  // rfc logon parameters
                            char SAP_FAR* group/* = NULL*/,
                            char SAP_FAR* mesageserver /*= NULL */,
                            char SAP_FAR* client/* = NULL*/,
                            char SAP_FAR* user/* = NULL*/,
                            char SAP_FAR* password/* = NULL*/, 
                            char SAP_FAR* language/* = NULL*/,
                            int trace/* = 0*/
                            );
#endif                            



 /* 
  * This function requests a new logon to the SAP System without determining
  * any old connections, hard new logon
  * The RRC parameters are provided in linear types inorder to call this library 
  * from visual basic                    
  */
   
#ifdef __cplusplus
CPP_HEADER RFC_HANDLE SAP_API RequestRFCLogon (
                            HWND hWnd,                         // Window Handle of parent window
                            VRFCService_HANDLE hAppl,          // register application handle
                            VRFCService_CONNECTMODE c_mode,    // connection mode
                            char SAP_FAR* destination = NULL,  // rfc logon parameters
                            char SAP_FAR* hostname = NULL,
                            int sysnr = -1,
                            char SAP_FAR* gateway_host = NULL,
                            char SAP_FAR* gateway_service = NULL,
                            char SAP_FAR* client = NULL,
                            char SAP_FAR* user = NULL,
                            char SAP_FAR* password = NULL, 
                            char SAP_FAR* language = NULL,
                            int trace = 0,
                            RFC_MODE mode = RFC_MODE_R3ONLY
                            );
#else
RFC_HANDLE SAP_API RequestRFCLogon (
                            HWND hWnd,                         // Window Handle of parent window
                            VRFCService_HANDLE hAppl,          // register application handle
                            VRFCService_CONNECTMODE c_mode,    // connection mode
                            char SAP_FAR* destination/* = NULL*/,  // rfc logon parameters
                            char SAP_FAR* hostname/* = NULL*/,
                            int sysnr/* = -1*/,
                            char SAP_FAR* gateway_host/* = NULL*/,
                            char SAP_FAR* gateway_service/* = NULL*/,
                            char SAP_FAR* client/* = NULL*/,
                            char SAP_FAR* user/* = NULL*/,
                            char SAP_FAR* password/* = NULL*/, 
                            char SAP_FAR* language/* = NULL*/,
                            int trace/* = 0*/,
                            RFC_MODE mode/* = RFC_MODE_R3ONLY*/
                            );
#endif                            



CPP_HEADER BOOL SAP_API SAP_EXPORT RequestVRFCLogonParameter (
                            VRFCService_HANDLE hAppl,          // register application handle
                            VRFCLoginID  hLID,
                            char SAP_FAR* destination,  // rfc logon parameters
                            int destlen,
                            char SAP_FAR* hostname,
                            int hostlen,
                            int *sysnr,
                            char SAP_FAR* gateway_host,
                            int ghostlen,
                            char SAP_FAR* gateway_service,
                            int gservlen,
                            char SAP_FAR* client,
                            int clientlen,
                            char SAP_FAR* user,
                            int userlen,
                            char SAP_FAR* password, 
                            int passwordlen,
                            char SAP_FAR* language,
                            int langlen,
                            int *trace,
                            RFC_MODE *mode
                            );
 /* 
  * This function returns all parameters which are used for the  logon to connection
  * hLID
  * The RRC parameters are provided in linear types inorder to call this library 
  * from visual basic                    
  */



CPP_HEADER BOOL SAP_API SAP_EXPORT RequestRFCLogonParameter (
                            VRFCService_HANDLE hAppl,          // register application handle
                            RFC_HANDLE  hRfc,
                            char SAP_FAR* destination,  // rfc logon parameters
                            int destlen,
                            char SAP_FAR* hostname,
                            int hostlen,
                            int *sysnr,
                            char SAP_FAR* gateway_host,
                            int ghostlen,
                            char SAP_FAR* gateway_service,
                            int gservlen,
                            char SAP_FAR* client,
                            int clientlen,
                            char SAP_FAR* user,
                            int userlen,
                            char SAP_FAR* password, 
                            int passwordlen,
                            char SAP_FAR* language,
                            int langlen,
                            int *trace,
                            RFC_MODE *mode
                            );
 /* 
  * This function returns all parameters which are used for the  logon to connection
  * hLID
  * The RRC parameters are provided in linear types inorder to call this library 
  * from visual basic                    
  */






 /* 
  * This function requests a new logon to the SAP System without determining
  * any old connections, hard new logon
  * The RRC parameters are provided in linear types inorder to call this library 
  * from visual basic                    
  */




CPP_HEADER void SAP_API RequestVRFCReconnect (     
                              VRFCService_HANDLE hAppl,            // VRFC Service Handle
                              VRFCLoginID hLID); // current connection handle

   

                                  
CPP_HEADER VRFCLoginID SAP_API RequestVRFCADMConnections (
                                            HWND   hWnd,                // parent window handle
                                            VRFCService_HANDLE hAppl);  // VRFC Service Handle
 
 /*
  *  The task requests to call the connection selction with full dialog support 
  */
                                              
                                              
#ifdef __cplusplus                                              
CPP_HEADER void SAP_API RequestVRFCLogoff (     
                              HWND   hWnd,                         // parent window handle
                              VRFCService_HANDLE hAppl,            // VRFC Service Handle
                              VRFCLoginID hLID= VRFCLoginID_NULL); // current connection handle
#else
void SAP_API RequestVRFCLogoff (     
                              HWND   hWnd,                         // parent window handle
                              VRFCService_HANDLE hAppl,            // VRFC Service Handle
                              VRFCLoginID hLID/*= VRFCLoginID_NULL*/); // current connection handle
#endif                              


CPP_HEADER void SAP_API RequestRFCLogoff (     
                              HWND   hWnd,                         // parent window handle
                              VRFCService_HANDLE hAppl,            // VRFC Service Handle
                              RFC_HANDLE hRfc); // current connection handle


 /*
  *  Discconect a task from a single connection
  *  if the second parameter is NULL all connection of the current application are
  *  removed
  */




CPP_HEADER void SAP_API DisplayR3SystemInformation (
                              HWND   hWnd,                  // parent window handle
                              VRFCService_HANDLE hAppl,     // VRC Service handle
                              VRFCLoginID hLID);            // current SAP connection
                                        

CPP_HEADER void SAP_API DisplayRFCSystemInformation (
                              HWND   hWnd,                  // parent window handle
                              VRFCService_HANDLE hAppl,     // VRC Service handle
                              RFC_HANDLE hRfc);            // current SAP connection


 /*
  *  Display Systeminformation for a connection
  */

CPP_HEADER void SAP_API DisplayConnectionInformation (  
                              HWND   hWnd,                  // parent window handle
                              VRFCService_HANDLE hAppl,     // VRFC Service handle
                              VRFCLoginID hLID);            // current SAP connection
 /*
  *  Show information about the usage of the current connection
  *
  */




/****************************************************************************************/
/*    functionality for call and receive */

/* Visual RFC Service Provider return codes */
// actually RFC_RC plus other returncodes in the future
typedef RFC_RC VRFC_RC;

// Visual Error reporting function
CPP_HEADER int SAP_API DisplayVRFCLastError (LPSTR lpstrDialogTitle);
CPP_HEADER int SAP_API DisplayRFCLastError (LPSTR lpstrDialogTitle);

/* Calling an RFC function */

CPP_HEADER VRFC_RC SAP_API SAP_EXPORT VRFCCall(
                             VRFCService_HANDLE hAppl,               // VRFC Service Handle
                             VRFCLoginID hLID,                       // current connection handle
                             char SAP_FAR*           function,
                             RFC_PARAMETER SAP_FAR*  exportparameters,
                             RFC_PARAMETER SAP_FAR*  importparameters,
                             RFC_TABLE     SAP_FAR*  tables,
                             char SAP_FAR**          exception );

CPP_HEADER VRFC_RC SAP_API SAP_EXPORT VRFCReceive( 
                             VRFCService_HANDLE hAppl,            // VRFC Service Handle
                             VRFCLoginID hLID                     // current connection handle
                                                 );

CPP_HEADER VRFC_RC SAP_API SAP_EXPORT VRFCCallReceive( 
                              VRFCService_HANDLE hAppl,            // VRFC Service Handle
                              VRFCLoginID hLID,                    // current connection handle
                              char SAP_FAR*           function,
                              RFC_PARAMETER SAP_FAR*  exportparameters,
                              RFC_PARAMETER SAP_FAR*  importparameters,
                              RFC_TABLE     SAP_FAR*  tables,
                              char SAP_FAR**          exception );


CPP_HEADER VRFC_RC SAP_API SAP_EXPORT VRFCCallExt(
                             VRFCService_HANDLE hAppl,               // VRFC Service Handle
                             VRFCLoginID        hLID,                // current connection handle
                             RFC_PARAM_SPACE    PSpace,
                             char SAP_FAR*      function,
                             char SAP_FAR*      exception );


CPP_HEADER VRFC_RC SAP_API SAP_EXPORT VRFCReceiveExt( 
                             VRFCService_HANDLE hAppl,            // VRFC Service Handle
                             VRFCLoginID        hLID              // current connection handle
                                                 );

CPP_HEADER VRFC_RC SAP_API SAP_EXPORT VRFCCallReceiveExt( 
                             VRFCService_HANDLE hAppl,               // VRFC Service Handle
                             VRFCLoginID        hLID,                // current connection handle
                             RFC_PARAM_SPACE    PSpace,
                             char SAP_FAR*      function,
                             char SAP_FAR*      exception );





/* enhanced interface for R/3 Version 3.0c or later */

/* The following two functions  provide support for RFC with dialogs */                                         


#ifdef __cplusplus                                              
CPP_HEADER VRFCLoginID SAP_API   RequestVRFCLogonEx (
                            HWND hWnd,                         // Window Handle of parent window
                            VRFCService_HANDLE hAppl,          // register application handle
                            VRFCService_CONNECTMODE c_mode,    // connection mode
                            char SAP_FAR* destination = NULL,  // rfc logon parameters
                            char SAP_FAR* hostname = NULL,
                            long sysnr = -1,
                            char SAP_FAR* client = NULL,
                            char SAP_FAR* user = NULL,
                            char SAP_FAR* password = NULL, 
                            char SAP_FAR* language = NULL,
                            long trace = 0,
                            long dialog = 0        // set this value != 0 if dialog is supported
                            );                                  
#else
VRFCLoginID SAP_API   RequestVRFCLogonEx (
                            HWND hWnd,                         // Window Handle of parent window
                            VRFCService_HANDLE hAppl,          // register application handle
                            VRFCService_CONNECTMODE c_mode,    // connection mode
                            char SAP_FAR* destination,         // rfc logon parameters
                            char SAP_FAR* hostname,
                            long sysnr,
                            char SAP_FAR* client,
                            char SAP_FAR* user,
                            char SAP_FAR* password, 
                            char SAP_FAR* language,
                            long trace,
                            long dialog                        // set this value != 0 if dialog is supported
                            );                                  
#endif                            


#ifdef __cplusplus                                              
CPP_HEADER VRFCLoginID SAP_API RequestVRFCGroupLogonEx (
                            HWND hWnd,                         // Window Handle of parent window
                            VRFCService_HANDLE hAppl,          // register application handle
                            VRFCService_CONNECTMODE c_mode,    // connection mode
                            char SAP_FAR* destination = NULL,  // rfc logon parameters
                            char SAP_FAR* group = NULL,
                            char SAP_FAR* mesageserver = NULL,
                            char SAP_FAR* client = NULL,
                            char SAP_FAR* user = NULL,
                            char SAP_FAR* password = NULL, 
                            char SAP_FAR* language = NULL,
                            long trace = 0,
                            long dialog = 0               // set this value != 0 if dialog is supported
                            );
                                                                
#else
VRFCLoginID SAP_API RequestVRFCGroupLogonEx (
                            HWND hWnd,                         // Window Handle of parent window
                            VRFCService_HANDLE hAppl,          // register application handle
                            VRFCService_CONNECTMODE c_mode,    // connection mode
                            char SAP_FAR* destination,         // rfc logon parameters
                            char SAP_FAR* group,
                            char SAP_FAR* mesageserver,
                            char SAP_FAR* client,
                            char SAP_FAR* user,
                            char SAP_FAR* password, 
                            char SAP_FAR* language,
                            long trace,
                            long dialog                        // set this value != 0 if dialog is supported
                            );
#endif                                                                






#ifdef __cplusplus                                              
CPP_HEADER RFC_HANDLE SAP_API   RequestRFCLogonEx (
                            HWND hWnd,                         // Window Handle of parent window
                            VRFCService_HANDLE hAppl,          // register application handle
                            VRFCService_CONNECTMODE c_mode,    // connection mode
                            char SAP_FAR* destination = NULL,  // rfc logon parameters
                            char SAP_FAR* hostname = NULL,
                            long sysnr = -1,
                            char SAP_FAR* client = NULL,
                            char SAP_FAR* user = NULL,
                            char SAP_FAR* password = NULL, 
                            char SAP_FAR* language = NULL,
                            long trace = 0,
                            long dialog = 0        // set this value != 0 if dialog is supported
                            );                                  
#else
RFC_HANDLE SAP_API   RequestRFCLogonEx (
                            HWND hWnd,                         // Window Handle of parent window
                            VRFCService_HANDLE hAppl,          // register application handle
                            VRFCService_CONNECTMODE c_mode,    // connection mode
                            char SAP_FAR* destination,         // rfc logon parameters
                            char SAP_FAR* hostname,
                            long sysnr,
                            char SAP_FAR* client,
                            char SAP_FAR* user,
                            char SAP_FAR* password, 
                            char SAP_FAR* language,
                            long trace,
                            long dialog                        // set this value != 0 if dialog is supported
                            );                                  
#endif                            


#ifdef __cplusplus                                              
CPP_HEADER RFC_HANDLE SAP_API RequestRFCGroupLogonEx (
                            HWND hWnd,                         // Window Handle of parent window
                            VRFCService_HANDLE hAppl,          // register application handle
                            VRFCService_CONNECTMODE c_mode,    // connection mode
                            char SAP_FAR* destination = NULL,  // rfc logon parameters
                            char SAP_FAR* group = NULL,
                            char SAP_FAR* mesageserver = NULL,
                            char SAP_FAR* client = NULL,
                            char SAP_FAR* user = NULL,
                            char SAP_FAR* password = NULL, 
                            char SAP_FAR* language = NULL,
                            long trace = 0,
                            long dialog = 0               // set this value != 0 if dialog is supported
                            );
                                                                
#else
RFC_HANDLE SAP_API RequestRFCGroupLogonEx (
                            HWND hWnd,                         // Window Handle of parent window
                            VRFCService_HANDLE hAppl,          // register application handle
                            VRFCService_CONNECTMODE c_mode,    // connection mode
                            char SAP_FAR* destination,         // rfc logon parameters
                            char SAP_FAR* group,
                            char SAP_FAR* mesageserver,
                            char SAP_FAR* client,
                            char SAP_FAR* user,
                            char SAP_FAR* password, 
                            char SAP_FAR* language,
                            long trace,
                            long dialog                        // set this value != 0 if dialog is supported
                            );
#endif                                                                
                  
#endif //_SAPVRFC_H                  


