/*@(#)srfcserv.h          20.15.5.1     SAP     96/06/26 */

/*====================================================================*/
/*                                                                    */
/*     PROGRAM     :   srfcserv.h (running on Windows, Windows_NT,    */
/*                                 Windows_95, OS/2 and R/3-Platforms)*/
/*                                                                    */
/*                                                                    */
/*     DESCRIPTION :   Includes file for RFC-Test                     */
/*                                                                    */
/*                                                                    */
/*     SAP AG Walldorf                                                */
/*     Systeme, Anwendungen und Produkte in der Datenverarbeitung     */
/*                                                                    */
/*     Copyright (C) SAP AG 1994                                      */
/*                                                                    */
/*====================================================================*/


/*--------------------------------------------------------------------*/
/* Defines                                                            */
/*--------------------------------------------------------------------*/

#define BLANK                  ' '
#define MAXBUFF                32000
#define LINE_SIZE              256
#define ITAB0332_ENTRY_SIZE    332
#define ITAB1000_ENTRY_SIZE    1000
#define ETAB0332_ENTRY_SIZE    332
#define ETAB1000_ENTRY_SIZE    1000

/*--------------------------------------------------------------------*/
/* Set up includes                                                    */
/*--------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include "saprfc.h"
#include "sapitab.h"

#if defined(SAPonWINDOWS) || defined(SAPonNT)
#include <windows.h>
#endif

/*--------------------------------------------------------------------*/
/* Function prototypes                                                */
/*--------------------------------------------------------------------*/

static void help(void);

int fill_table(ITAB_H itab_h,
               long   leng);

int check_table(ITAB_H itab_h,
                char   *itabname,
                long   recvleng,
                char   *checktab,
                char   *text,
                char   *retcode);

void function_abort(char *atext);

static RFC_RC install(void);

/*====================================================================*/
/* The prototype of following functions must be defined with _loadds  */
/* on Windows because it will run as a QuickWin application and work  */
/* with fprintf.                                                      */
/*                                                                    */
/*====================================================================*/
#ifdef SAPonWINDOWS
static RFC_RC DLL_CALL_BACK_FUNCTION _loadds connection_test(RFC_HANDLE rfc_handle);
static RFC_RC DLL_CALL_BACK_FUNCTION _loadds performance_test(RFC_HANDLE rfc_handle);
#else
static RFC_RC DLL_CALL_BACK_FUNCTION connection_test(RFC_HANDLE rfc_handle);
static RFC_RC DLL_CALL_BACK_FUNCTION performance_test(RFC_HANDLE rfc_handle);
#endif

static char *connection_test_docu(void);

static char *performance_test_docu(void);

void rfc_param(RFC_PARAMETER *rfc_param,
               char          *abap_field_name,
               unsigned      data_type,
               void          *data_addr,
               unsigned      data_len );

void DLL_CALL_BACK_FUNCTION rfc_error(char *operation );

/*--------------------------------------------------------------------*/
/* Declarations                                                       */
/*--------------------------------------------------------------------*/

int               i,
                  j,
                  rc,
                  znr;

unsigned	  ulen;

long              lineleng,
                  itableng;

char              ips[101],
                  tpname[101],
		  tphost[101],
		  gwhost[101],
		  gwserv[9];

char              requtext[256],
                  echotext[256],
                  resptext[256];

char              *ptr,
                  sbuf[32000+1];

long              lgit0332,
                  lgit1000,
                  lget0332,
                  lget1000;

char              retcode[2],
                  exitcode[2],
                  checktab[2],
                  printtab[2],
                  lgit0332_field[6],
                  lgit1000_field[6],
                  lget0332_field[6],
                  lget1000_field[6];

char              text0332[73],
                  text1000[73],
                  texi0332[73],
                  texi1000[73];

char              abort_text[80],
                  last_error_text[150];

char              *exception = NULL,
                  *function  = NULL;

struct         tm *time_ptr;

time_t            actutime;

RFC_RC            rfc_rc;
RFC_HANDLE        rfc_handle;
RFC_FUNCTIONNAME  function_name;
RFC_ERROR_INFO    error_info;
RFC_ATTRIBUTES    rfc_attributes;

RFC_PARAMETER     parameters[6];

RFC_TABLE         tables[5];

RFC_TID           tid;

char              name_connection_test[30]  = "STFC_CONNECTION",
                  name_performance_test[30] = "STFC_PERFORMANCE";

